/*	$OpenBSD: athnreg.h,v 1.19 2016/12/18 14:34:20 kettenis Exp $	*/

/*-
 * Copyright (c) 2009 Damien Bergamini <damien.bergamini@free.fr>
 * Copyright (c) 2008-2009 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * MAC registers.
 */
#define AR_CR				0x0008
#define AR_RXDP				0x000c
#define AR_CFG				0x0014
#define AR_RXBP_THRESH			0x0018
#define AR_MIRT				0x0020
#define AR_IER				0x0024
#define AR_TIMT				0x0028
#define AR_RIMT				0x002c
#define AR_TXCFG			0x0030
#define AR_RXCFG			0x0034
#define AR_MIBC				0x0040
#define AR_TOPS				0x0044
#define AR_RXNPTO			0x0048
#define AR_TXNPTO			0x004c
#define AR_RPGTO			0x0050
#define AR_RPCNT			0x0054
#define AR_MACMISC			0x0058
#define AR_DATABUF_SIZE			0x0060
#define AR_GTXTO			0x0064
#define AR_GTTM				0x0068
#define AR_CST				0x006c
#define AR_HP_RXDP			0x0074
#define AR_LP_RXDP			0x0078
#define AR_ISR				0x0080
#define AR_ISR_S0			0x0084
#define AR_ISR_S1			0x0088
#define AR_ISR_S2			0x008c
#define AR_ISR_S3			0x0090
#define AR_ISR_S4			0x0094
#define AR_ISR_S5			0x0098
#define AR_IMR				0x00a0
#define AR_IMR_S0			0x00a4
#define AR_IMR_S1			0x00a8
#define AR_IMR_S2			0x00ac
#define AR_IMR_S3			0x00b0
#define AR_IMR_S4			0x00b4
#define AR_IMR_S5			0x00b8
#define AR_ISR_RAC			0x00c0
#define AR_ISR_S0_S			0x00c4
#define AR_ISR_S1_S			0x00c8
#define AR_DMADBG(i)			(0x00e0 + (i) * 4)
#define AR_QTXDP(i)			(0x0800 + (i) * 4)
#define AR_Q_STATUS_RING_START		0x0830
#define AR_Q_STATUS_RING_END		0x0834
#define AR_Q_TXE			0x0840
#define AR_Q_TXD			0x0880
#define AR_QCBRCFG(i)			(0x08c0 + (i) * 4)
#define AR_QRDYTIMECFG(i)		(0x0900 + (i) * 4)
#define AR_Q_ONESHOTARM_SC		0x0940
#define AR_Q_ONESHOTARM_CC		0x0980
#define AR_QMISC(i)			(0x09c0 + (i) * 4)
#define AR_QSTS(i)			(0x0a00 + (i) * 4)
#define AR_Q_RDYTIMESHDN		0x0a40
#define AR_Q_DESC_CRCCHK		0x0a44
#define AR_DQCUMASK(i)			(0x1000 + (i) * 4)
#define AR_D_GBL_IFS_SIFS		0x1030
#define AR_D_TXBLK_CMD			0x1038
#define AR_DLCL_IFS(i)			(0x1040 + (i) * 4)
#define AR_D_GBL_IFS_SLOT		0x1070
#define AR_DRETRY_LIMIT(i)		(0x1080 + (i) * 4)
#define AR_D_GBL_IFS_EIFS		0x10b0
#define AR_DCHNTIME(i)			(0x10c0 + (i) * 4)
#define AR_D_GBL_IFS_MISC		0x10f0
#define AR_DMISC(i)			(0x1100 + (i) * 4)
#define AR_D_SEQNUM			0x1140
#define AR_D_FPCTL			0x1230
#define AR_D_TXPSE			0x1270
#define AR_D_TXSLOTMASK			0x12f0
#define AR_MAC_SLEEP			0x1f00
#define AR_CFG_LED			0x1f04
#define AR_EEPROM_OFFSET(i)		(0x2000 + (i) * 4)
#define AR_RC				0x4000
#define AR_WA				0x4004
#define AR_PM_STATE			0x4008
#define AR_PCIE_PM_CTRL			0x4014
#define AR_HOST_TIMEOUT			0x4018
#define AR_EEPROM			0x401c
#define AR_SREV				0x4020
#define AR_AHB_MODE			0x4024
#define AR_INTR_SYNC_CAUSE		0x4028
#define AR_INTR_SYNC_ENABLE		0x402c
#define AR_INTR_ASYNC_MASK		0x4030
#define AR_INTR_SYNC_MASK		0x4034
#define AR_INTR_ASYNC_CAUSE		0x4038
#define AR_INTR_ASYNC_ENABLE		0x403c
#define AR_PCIE_SERDES			0x4040
#define AR_PCIE_SERDES2			0x4044
#define AR_INTR_PRIO_SYNC_ENABLE	0x40c4
#define AR_INTR_PRIO_ASYNC_MASK		0x40c8
#define AR_INTR_PRIO_SYNC_MASK		0x40cc
#define AR_INTR_PRIO_ASYNC_ENABLE	0x40d4
#define AR_RTC_RC			0x7000
#define AR_RTC_XTAL_CONTROL		0x7004
#define AR_RTC_REG_CONTROL0		0x7008
#define AR_RTC_REG_CONTROL1		0x700c
#define AR_RTC_PLL_CONTROL		0x7014
#define AR_RTC_PLL_CONTROL2		0x703c
#define AR_RTC_RESET			0x7040
#define AR_RTC_STATUS 			0x7044
#define AR_RTC_SLEEP_CLK		0x7048
#define AR_RTC_FORCE_WAKE		0x704c
#define AR_RTC_INTR_CAUSE		0x7050
#define AR_RTC_INTR_ENABLE		0x7054
#define AR_RTC_INTR_MASK		0x7058
#define AR_STA_ID0			0x8000
#define AR_STA_ID1			0x8004
#define AR_BSS_ID0			0x8008
#define AR_BSS_ID1			0x800c
#define AR_BCN_RSSI_AVE			0x8010
#define AR_TIME_OUT			0x8014
#define AR_RSSI_THR			0x8018
#define AR_USEC				0x801c
#define AR_RESET_TSF			0x8020
#define AR_MAX_CFP_DUR			0x8038
#define AR_RX_FILTER			0x803c
#define AR_MCAST_FIL0			0x8040
#define AR_MCAST_FIL1			0x8044
#define AR_DIAG_SW			0x8048
#define AR_TSF_L32			0x804c
#define AR_TSF_U32			0x8050
#define AR_TST_ADDAC			0x8054
#define AR_DEF_ANTENNA			0x8058
#define AR_AES_MUTE_MASK0		0x805c
#define AR_AES_MUTE_MASK1		0x8060
#define AR_GATED_CLKS			0x8064
#define AR_OBS_BUS_CTRL			0x8068
#define AR_OBS_BUS_1			0x806c
#define AR_LAST_TSTP			0x8080
#define AR_NAV				0x8084
#define AR_RTS_OK			0x8088
#define AR_RTS_FAIL			0x808c
#define AR_ACK_FAIL			0x8090
#define AR_FCS_FAIL			0x8094
#define AR_BEACON_CNT			0x8098
#define AR_SLEEP1			0x80d4
#define AR_SLEEP2			0x80d8
#define AR_BSSMSKL			0x80e0
#define AR_BSSMSKU			0x80e4
#define AR_TPC				0x80e8
#define AR_TFCNT			0x80ec
#define AR_RFCNT			0x80f0
#define AR_RCCNT			0x80f4
#define AR_CCCNT			0x80f8
#define AR_QUIET1			0x80fc
#define AR_QUIET2			0x8100
#define AR_TSF_PARM			0x8104
#define AR_QOS_NO_ACK			0x8108
#define AR_PHY_ERR			0x810c
#define AR_RXFIFO_CFG			0x8114
#define AR_MIC_QOS_CONTROL		0x8118
#define AR_MIC_QOS_SELECT		0x811c
#define AR_PCU_MISC			0x8120
#define AR_FILT_OFDM			0x8124
#define AR_FILT_CCK			0x8128
#define AR_PHY_ERR_1			0x812c
#define AR_PHY_ERR_MASK_1		0x8130
#define AR_PHY_ERR_2			0x8134
#define AR_PHY_ERR_MASK_2		0x8138
#define AR_TSFOOR_THRESHOLD		0x813c
#define AR_PHY_ERR_EIFS_MASK		0x8144
#define AR_PHY_ERR_3			0x8168
#define AR_PHY_ERR_MASK_3		0x816c
#define AR_BT_COEX_MODE			0x8170
#define AR_BT_COEX_WEIGHT		0x8174
#define AR_BT_COEX_MODE2		0x817c
#define AR_NEXT_NDP2_TIMER(i)		(0x8180 + (i) * 4)
#define AR_NDP2_PERIOD(i)		(0x81a0 + (i) * 4)
#define AR_NDP2_TIMER_MODE		0x81c0
#define AR_TXSIFS			0x81d0
#define AR_TXOP_X			0x81ec
#define AR_TXOP_0_3			0x81f0
#define AR_TXOP_4_7			0x81f4
#define AR_TXOP_8_11			0x81f8
#define AR_TXOP_12_15			0x81fc
#define AR_GEN_TIMER(i)			(0x8200 + (i) * 4)
#define AR_NEXT_TBTT_TIMER		AR_GEN_TIMER(0)
#define AR_NEXT_DMA_BEACON_ALERT	AR_GEN_TIMER(1)
#define AR_NEXT_CFP			AR_GEN_TIMER(2)
#define AR_NEXT_HCF			AR_GEN_TIMER(3)
#define AR_NEXT_TIM			AR_GEN_TIMER(4)
#define AR_NEXT_DTIM			AR_GEN_TIMER(5)
#define AR_NEXT_QUIET_TIMER		AR_GEN_TIMER(6)
#define AR_NEXT_NDP_TIMER		AR_GEN_TIMER(7)
#define AR_BEACON_PERIOD		AR_GEN_TIMER(8)
#define AR_DMA_BEACON_PERIOD		AR_GEN_TIMER(9)
#define AR_SWBA_PERIOD			AR_GEN_TIMER(10)
#define AR_HCF_PERIOD			AR_GEN_TIMER(11)
#define AR_TIM_PERIOD			AR_GEN_TIMER(12)
#define AR_DTIM_PERIOD			AR_GEN_TIMER(13)
#define AR_QUIET_PERIOD			AR_GEN_TIMER(14)
#define AR_NDP_PERIOD			AR_GEN_TIMER(15)
#define AR_TIMER_MODE			0x8240
#define AR_SLP32_MODE			0x8244
#define AR_SLP32_WAKE			0x8248
#define AR_SLP32_INC			0x824c
#define AR_SLP_CNT			0x8250
#define AR_SLP_CYCLE_CNT		0x8254
#define AR_SLP_MIB_CTRL			0x8258
#define AR_WOW_PATTERN_REG		0x825c
#define AR_WOW_COUNT_REG		0x8260
#define AR_MAC_PCU_LOGIC_ANALYZER	0x8264
#define AR_WOW_BCN_EN_REG		0x8270
#define AR_WOW_BCN_TIMO_REG		0x8274
#define AR_WOW_KEEP_ALIVE_TIMO_REG	0x8278
#define AR_WOW_KEEP_ALIVE_REG		0x827c
#define AR_WOW_US_SCALAR_REG		0x8284
#define AR_WOW_KEEP_ALIVE_DELAY_REG	0x8288
#define AR_WOW_PATTERN_MATCH_REG	0x828c
#define AR_WOW_PATTERN_OFF1_REG		0x8290
#define AR_WOW_PATTERN_OFF2_REG		0x8294
#define AR_WOW_EXACT_REG		0x829c
#define AR_2040_MODE			0x8318
#define AR_EXTRCCNT			0x8328
#define AR_SELFGEN_MASK			0x832c
#define AR_PCU_TXBUF_CTRL		0x8340
#define AR_PCU_MISC_MODE2		0x8344
#define AR_MAC_PCU_ASYNC_FIFO_REG3	0x8358
#define AR_WOW_LENGTH1_REG		0x8360
#define AR_WOW_LENGTH2_REG		0x8364
#define AR_WOW_PATTERN_MATCH_LT_256B	0x8368
#define AR_RATE_DURATION(i)		(0x8700 + (i) * 4)
#define AR_KEYTABLE(i)			(0x8800 + (i) * 32)
#define AR_KEYTABLE_KEY0(i)		(AR_KEYTABLE(i) +  0)
#define AR_KEYTABLE_KEY1(i)		(AR_KEYTABLE(i) +  4)
#define AR_KEYTABLE_KEY2(i)		(AR_KEYTABLE(i) +  8)
#define AR_KEYTABLE_KEY3(i)		(AR_KEYTABLE(i) + 12)
#define AR_KEYTABLE_KEY4(i)		(AR_KEYTABLE(i) + 16)
#define AR_KEYTABLE_TYPE(i)		(AR_KEYTABLE(i) + 20)
#define AR_KEYTABLE_MAC0(i)		(AR_KEYTABLE(i) + 24)
#define AR_KEYTABLE_MAC1(i)		(AR_KEYTABLE(i) + 28)


/* Bits for AR_CR. */
#define AR_CR_RXE	0x00000004
#define AR_CR_RXD	0x00000020
#define AR_CR_SWI	0x00000040

/* Bits for AR_CFG. */
#define AR_CFG_SWTD				0x00000001
#define AR_CFG_SWTB				0x00000002
#define AR_CFG_SWRD				0x00000004
#define AR_CFG_SWRB				0x00000008
#define AR_CFG_SWRG				0x00000010
#define AR_CFG_AP_ADHOC_INDICATION		0x00000020
#define AR_CFG_PHOK				0x00000100
#define AR_CFG_EEBS				0x00000200
#define AR_CFG_CLK_GATE_DIS			0x00000400
#define AR_CFG_PCI_MASTER_REQ_Q_THRESH_M	0x00060000
#define AR_CFG_PCI_MASTER_REQ_Q_THRESH_S	17

/* Bits for AR_RXBP_THRESH. */
#define AR_RXBP_THRESH_HP_M	0x0000000f
#define AR_RXBP_THRESH_HP_S	0
#define AR_RXBP_THRESH_LP_M	0x00003f00
#define AR_RXBP_THRESH_LP_S	8

/* Bits for AR_IER. */
#define AR_IER_ENABLE	0x00000001

/* Bits for AR_TIMT. */
#define AR_TIMT_LAST_M	0x0000ffff
#define AR_TIMT_LAST_S	0
#define AR_TIMT_FIRST_M	0xffff0000
#define AR_TIMT_FIRST_S	16

/* Bits for AR_RIMT. */
#define AR_RIMT_LAST_M	0x0000ffff
#define AR_RIMT_LAST_S	0
#define AR_RIMT_FIRST_M	0xffff0000
#define AR_RIMT_FIRST_S	16

/* Bits for AR_[TR]XCFG_DMASZ fields. */
#define AR_DMASZ_4B	0
#define AR_DMASZ_8B	1
#define AR_DMASZ_16B	2
#define AR_DMASZ_32B	3
#define AR_DMASZ_64B	4
#define AR_DMASZ_128B	5
#define AR_DMASZ_256B	6
#define AR_DMASZ_512B	7

/* Bits for AR_TXCFG. */
#define AR_TXCFG_DMASZ_M			0x00000007
#define AR_TXCFG_DMASZ_S			0
#define AR_TXCFG_FTRIG_M			0x000003f0
#define AR_TXCFG_FTRIG_S			4
#define AR_TXCFG_FTRIG_IMMED			(  0 / 64)
#define AR_TXCFG_FTRIG_64B			( 64 / 64)
#define AR_TXCFG_FTRIG_128B			(128 / 64)
#define AR_TXCFG_FTRIG_192B			(192 / 64)
#define AR_TXCFG_FTRIG_256B			(256 / 64)
#define AR_TXCFG_FTRIG_512B			(512 / 64)
#define AR_TXCFG_ADHOC_BEACON_ATIM_TX_POLICY	0x00000800

/* Bits for AR_RXCFG. */
#define AR_RXCFG_DMASZ_M	0x00000007
#define AR_RXCFG_DMASZ_S	0
#define AR_RXCFG_CHIRP		0x00000008
#define AR_RXCFG_ZLFDMA		0x00000010

/* Bits for AR_MIBC. */
#define AR_MIBC_COW	0x00000001
#define AR_MIBC_FMC	0x00000002
#define AR_MIBC_CMC	0x00000004
#define AR_MIBC_MCS	0x00000008

/* Bits for AR_TOPS. */
#define AR_TOPS_MASK	0x0000ffff

/* Bits for AR_RXNPTO. */
#define AR_RXNPTO_MASK	0x000003ff

/* Bits for AR_TXNPTO. */
#define AR_TXNPTO_MASK		0x000003ff
#define AR_TXNPTO_QCU_MASK	0x000ffc00

/* Bits for AR_RPGTO. */
#define AR_RPGTO_MASK	0x000003ff

/* Bits for AR_RPCNT. */
#define AR_RPCNT_MASK	0x0000001f

/* Bits for AR_MACMISC. */
#define AR_MACMISC_PCI_EXT_FORCE	0x00000010
#define AR_MACMISC_DMA_OBS_M		0x000001e0
#define AR_MACMISC_DMA_OBS_S		5
#define AR_MACMISC_MISC_OBS_M		0x00000e00
#define AR_MACMISC_MISC_OBS_S		9
#define AR_MACMISC_MISC_OBS_BUS_LSB_M	0x00007000
#define AR_MACMISC_MISC_OBS_BUS_LSB_S	12
#define AR_MACMISC_MISC_OBS_BUS_MSB_M	0x00038000
#define AR_MACMISC_MISC_OBS_BUS_MSB_S	15

/* Bits for AR_GTXTO. */
#define AR_GTXTO_TIMEOUT_COUNTER_M	0x0000ffff
#define AR_GTXTO_TIMEOUT_COUNTER_S	0
#define AR_GTXTO_TIMEOUT_LIMIT_M	0xffff0000
#define AR_GTXTO_TIMEOUT_LIMIT_S	16

/* Bits for AR_GTTM. */
#define AR_GTTM_USEC		0x00000001
#define AR_GTTM_IGNORE_IDLE	0x00000002
#define AR_GTTM_RESET_IDLE	0x00000004
#define AR_GTTM_CST_USEC	0x00000008

/* Bits for AR_CST. */
#define AR_CST_TIMEOUT_COUNTER_M	0x0000ffff
#define AR_CST_TIMEOUT_COUNTER_S	0
#define AR_CST_TIMEOUT_LIMIT_M		0xffff0000
#define AR_CST_TIMEOUT_LIMIT_S		16

/* Bits for AR_ISR. */
#define AR_ISR_RXOK	0x00000001
#define AR_ISR_HP_RXOK	0x00000001
#define AR_ISR_RXDESC	0x00000002
#define AR_ISR_LP_RXOK	0x00000002
#define AR_ISR_RXERR	0x00000004
#define AR_ISR_RXNOPKT	0x00000008
#define AR_ISR_RXEOL	0x00000010
#define AR_ISR_RXORN	0x00000020
#define AR_ISR_TXOK	0x00000040
#define AR_ISR_TXDESC	0x00000080
#define AR_ISR_TXERR	0x00000100
#define AR_ISR_TXNOPKT	0x00000200
#define AR_ISR_TXEOL	0x00000400
#define AR_ISR_TXURN	0x00000800
#define AR_ISR_MIB	0x00001000
#define AR_ISR_SWI	0x00002000
#define AR_ISR_RXPHY	0x00004000
#define AR_ISR_RXKCM	0x00008000
#define AR_ISR_SWBA	0x00010000
#define AR_ISR_BRSSI	0x00020000
#define AR_ISR_BMISS	0x00040000
#define AR_ISR_TXMINTR	0x00080000
#define AR_ISR_BNR	0x00100000
#define AR_ISR_RXCHIRP	0x00200000
#define AR_ISR_BCNMISC	0x00800000
#define AR_ISR_TIM	0x00800000
#define AR_ISR_RXMINTR	0x01000000
#define AR_ISR_QCBROVF	0x02000000
#define AR_ISR_QCBRURN	0x04000000
#define AR_ISR_QTRIG	0x08000000
#define AR_ISR_GENTMR	0x10000000
#define AR_ISR_TXINTM	0x40000000
#define AR_ISR_RXINTM	0x80000000

/* Bits for AR_ISR_S0. */
#define AR_ISR_S0_QCU_TXOK_M	0x000003ff
#define AR_ISR_S0_QCU_TXOK_S	0
#define AR_ISR_S0_QCU_TXDESC_M	0x03ff0000
#define AR_ISR_S0_QCU_TXDESC_S	16

/* Bits for AR_ISR_S1. */
#define AR_ISR_S1_QCU_TXERR_M	0x000003ff
#define AR_ISR_S1_QCU_TXERR_S	0
#define AR_ISR_S1_QCU_TXEOL_M	0x03ff0000
#define AR_ISR_S1_QCU_TXEOL_S	16

/* Bits for AR_ISR_S2. */
#define AR_ISR_S2_QCU_TXURN_M		0x000003ff
#define AR_ISR_S2_QCU_TXURN_S		0
#define AR_ISR_S2_BB_WATCHDOG		0x00010000
#define AR_ISR_S2_CST			0x00400000
#define AR_ISR_S2_GTT			0x00800000
#define AR_ISR_S2_TIM			0x01000000
#define AR_ISR_S2_CABEND		0x02000000
#define AR_ISR_S2_DTIMSYNC		0x04000000
#define AR_ISR_S2_BCNTO			0x08000000
#define AR_ISR_S2_CABTO			0x10000000
#define AR_ISR_S2_DTIM			0x20000000
#define AR_ISR_S2_TSFOOR		0x40000000
#define AR_ISR_S2_TBTT_TIME		0x80000000

/* Bits for AR_ISR_S3. */
#define AR_ISR_S3_QCU_QCBROVF_M	0x000003ff
#define AR_ISR_S3_QCU_QCBROVF_S	0
#define AR_ISR_S3_QCU_QCBRURN_M	0x03ff0000
#define AR_ISR_S3_QCU_QCBRURN_S	0

/* Bits for  AR_ISR_S4. */
#define AR_ISR_S4_QCU_QTRIG_M	0x000003ff
#define AR_ISR_S4_QCU_QTRIG_S	0

/* Bits for AR_ISR_S5. */
#define AR_ISR_S5_TIMER_TRIG_M		0x000000ff
#define AR_ISR_S5_TIMER_TRIG_S		0
#define AR_ISR_S5_TIMER_THRESH_M	0x0007fe00
#define AR_ISR_S5_TIMER_THRESH_S	9
#define AR_ISR_S5_TIM_TIMER		0x00000010
#define AR_ISR_S5_DTIM_TIMER		0x00000020
#define AR_ISR_S5_GENTIMER_TRIG_M	0x0000ff80
#define AR_ISR_S5_GENTIMER_TRIG_S	0
#define AR_ISR_S5_GENTIMER_THRESH_M	0xff800000
#define AR_ISR_S5_GENTIMER_THRESH_S	16

/* Bits for AR_IMR. */
#define AR_IMR_RXOK	0x00000001
#define AR_IMR_HP_RXOK	0x00000001
#define AR_IMR_RXDESC	0x00000002
#define AR_IMR_LP_RXOK	0x00000002
#define AR_IMR_RXERR	0x00000004
#define AR_IMR_RXNOPKT	0x00000008
#define AR_IMR_RXEOL	0x00000010
#define AR_IMR_RXORN	0x00000020
#define AR_IMR_TXOK	0x00000040
#define AR_IMR_TXDESC	0x00000080
#define AR_IMR_TXERR	0x00000100
#define AR_IMR_TXNOPKT	0x00000200
#define AR_IMR_TXEOL	0x00000400
#define AR_IMR_TXURN	0x00000800
#define AR_IMR_MIB	0x00001000
#define AR_IMR_SWI	0x00002000
#define AR_IMR_RXPHY	0x00004000
#define AR_IMR_RXKCM	0x00008000
#define AR_IMR_SWBA	0x00010000
#define AR_IMR_BRSSI	0x00020000
#define AR_IMR_BMISS	0x00040000
#define AR_IMR_TXMINTR	0x00080000
#define AR_IMR_BNR	0x00100000
#define AR_IMR_RXCHIRP	0x00200000
#define AR_IMR_BCNMISC	0x00800000
#define AR_IMR_TIM	0x00800000
#define AR_IMR_RXMINTR	0x01000000
#define AR_IMR_QCBROVF	0x02000000
#define AR_IMR_QCBRURN	0x04000000
#define AR_IMR_QTRIG	0x08000000
#define AR_IMR_GENTMR	0x10000000
#define AR_IMR_TXINTM	0x40000000
#define AR_IMR_RXINTM	0x80000000

#define AR_IMR_DEFAULT	\
	(AR_IMR_TXERR | AR_IMR_TXURN | AR_IMR_RXERR |	\
	 AR_IMR_RXORN | AR_IMR_BCNMISC | AR_IMR_RXINTM |	\
	 AR_IMR_RXMINTR | AR_IMR_TXOK)
#define AR_IMR_HOSTAP	(AR_IMR_DEFAULT | AR_IMR_MIB)

/* Bits for AR_IMR_S0. */
#define AR_IMR_S0_QCU_TXOK(qid)		(1 << (qid))
#define AR_IMR_S0_QCU_TXDESC(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S1. */
#define AR_IMR_S1_QCU_TXERR(qid)	(1 << (qid))
#define AR_IMR_S1_QCU_TXEOL(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S2. */
#define AR_IMR_S2_QCU_TXURN(qid)	(1 << (qid))
#define AR_IMR_S2_CST			0x00400000
#define AR_IMR_S2_GTT			0x00800000
#define AR_IMR_S2_TIM			0x01000000
#define AR_IMR_S2_CABEND		0x02000000
#define AR_IMR_S2_DTIMSYNC		0x04000000
#define AR_IMR_S2_BCNTO			0x08000000
#define AR_IMR_S2_CABTO			0x10000000
#define AR_IMR_S2_DTIM			0x20000000
#define AR_IMR_S2_TSFOOR		0x40000000

/* Bits for AR_IMR_S3. */
#define AR_IMR_S3_QCU_QCBROVF(qid)	(1 << (qid))
#define AR_IMR_S3_QCU_QCBRURN(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S4. */
#define AR_IMR_S4_QCU_QTRIG(qid)	(1 << (qid))

/* Bits for AR_IMR_S5. */
#define AR_IMR_S5_TIM_TIMER		0x00000010
#define AR_IMR_S5_DTIM_TIMER		0x00000020
#define AR_IMR_S5_TIMER_TRIG_M		0x000000ff
#define AR_IMR_S5_TIMER_TRIG_S		0
#define AR_IMR_S5_TIMER_THRESH_M	0x0000ff00
#define AR_IMR_S5_TIMER_THRESH_S	0

#define AR_NUM_QCU	10
#define AR_QCU(x)	(1 << (x))

/* Bits for AR_Q_TXE. */
#define AR_Q_TXE_M	0x000003ff
#define AR_Q_TXE_S	0

/* Bits for AR_Q_TXD. */
#define AR_Q_TXD_M	0x000003ff
#define AR_Q_TXD_S	0

/* Bits for AR_QCBRCFG_*. */
#define AR_Q_CBRCFG_INTERVAL_M		0x00ffffff
#define AR_Q_CBRCFG_INTERVAL_S		0
#define AR_Q_CBRCFG_OVF_THRESH_M	0xff000000
#define AR_Q_CBRCFG_OVF_THRESH_S	24

/* Bits for AR_QRDYTIMECFG_*. */
#define AR_Q_RDYTIMECFG_DURATION_M	0x00ffffff
#define AR_Q_RDYTIMECFG_DURATION_S	0
#define AR_Q_RDYTIMECFG_EN		0x01000000

/* Bits for AR_QMISC_*. */
#define AR_Q_MISC_FSP_M			0x0000000f
#define AR_Q_MISC_FSP_S			0
#define AR_Q_MISC_FSP_ASAP		0
#define AR_Q_MISC_FSP_CBR		1
#define AR_Q_MISC_FSP_DBA_GATED		2
#define AR_Q_MISC_FSP_TIM_GATED		3
#define AR_Q_MISC_FSP_BEACON_SENT_GATED	4
#define AR_Q_MISC_FSP_BEACON_RCVD_GATED	5
#define AR_Q_MISC_ONE_SHOT_EN		0x00000010
#define AR_Q_MISC_CBR_INCR_DIS1		0x00000020
#define AR_Q_MISC_CBR_INCR_DIS0		0x00000040
#define AR_Q_MISC_BEACON_USE		0x00000080
#define AR_Q_MISC_CBR_EXP_CNTR_LIMIT_EN	0x00000100
#define AR_Q_MISC_RDYTIME_EXP_POLICY	0x00000200
#define AR_Q_MISC_RESET_CBR_EXP_CTR	0x00000400
#define AR_Q_MISC_DCU_EARLY_TERM_REQ	0x00000800

/* Bits for AR_QSTS_*. */
#define AR_Q_STS_PEND_FR_CNT_M	0x00000003
#define AR_Q_STS_PEND_FR_CNT_S	0
#define AR_Q_STS_CBR_EXP_CNT_M	0x0000ff00
#define AR_Q_STS_CBR_EXP_CNT_S	8

/* Bits for AR_Q_DESC_CRCCHK. */
#define AR_Q_DESC_CRCCHK_EN	0x00000001

#define AR_NUM_DCU	10
#define AR_DCU(x)	(1 << (x))

/* Bits for AR_D_QCUMASK_*. */
#define AR_D_QCUMASK_M	0x000003ff
#define AR_D_QCUMASK_S	0

/* Bits for AR_D_GBL_IFS_SIFS. */
#define AR_D_GBL_IFS_SIFS_ASYNC_FIFO_DUR	0x000003ab

/* Bits for AR_D_TXBLK_CMD. */
#define AR_D_TXBLK_WRITE_BITMASK_M	0x0000ffff
#define AR_D_TXBLK_WRITE_BITMASK_S	0
#define AR_D_TXBLK_WRITE_SLICE_M	0x000f0000
#define AR_D_TXBLK_WRITE_SLICE_S	16
#define AR_D_TXBLK_WRITE_DCU_M		0x00f00000
#define AR_D_TXBLK_WRITE_DCU_S		20
#define AR_D_TXBLK_WRITE_COMMAND_M	0x0f000000
#define AR_D_TXBLK_WRITE_COMMAND_S	24

/* Bits for AR_DLCL_IFS. */
#define AR_D_LCL_IFS_CWMIN_M	0x000003ff
#define AR_D_LCL_IFS_CWMIN_S	0
#define AR_D_LCL_IFS_CWMAX_M	0x000ffc00
#define AR_D_LCL_IFS_CWMAX_S	10
#define AR_D_LCL_IFS_AIFS_M	0x0ff00000
#define AR_D_LCL_IFS_AIFS_S	20

/* Bits for AR_D_GBL_IFS_SLOT. */
#define AR_D_GBL_IFS_SLOT_M			0x0000ffff
#define AR_D_GBL_IFS_SLOT_S			0
#define AR_D_GBL_IFS_SLOT_ASYNC_FIFO_DUR	0x00000420

/* Bits for AR_DRETRY_LIMIT_*. */
#define AR_D_RETRY_LIMIT_FR_SH_M	0x0000000f
#define AR_D_RETRY_LIMIT_FR_SH_S	0
#define AR_D_RETRY_LIMIT_STA_SH_M	0x00003f00
#define AR_D_RETRY_LIMIT_STA_SH_S	8
#define AR_D_RETRY_LIMIT_STA_LG_M	0x000fc000
#define AR_D_RETRY_LIMIT_STA_LG_S	14

/* Bits for AR_D_GBL_IFS_EIFS. */
#define AR_D_GBL_IFS_EIFS_M			0x0000ffff
#define AR_D_GBL_IFS_EIFS_S			0
#define AR_D_GBL_IFS_EIFS_ASYNC_FIFO_DUR	0x0000a5eb

/* Bits for AR_DCHNTIME_*. */
#define AR_D_CHNTIME_DUR_M	0x000fffff
#define AR_D_CHNTIME_DUR_S	0
#define AR_D_CHNTIME_EN		0x00100000

/* Bits for AR_D_GBL_IFS_MISC. */
#define AR_D_GBL_IFS_MISC_LFSR_SLICE_SEL	0x00000007
#define AR_D_GBL_IFS_MISC_TURBO_MODE		0x00000008
#define AR_D_GBL_IFS_MISC_USEC_DURATION		0x000ffc00
#define AR_D_GBL_IFS_MISC_DCU_ARBITER_DLY	0x00300000
#define AR_D_GBL_IFS_MISC_RANDOM_LFSR_SLICE_DIS	0x01000000
#define AR_D_GBL_IFS_MISC_SLOT_XMIT_WIND_LEN	0x06000000
#define AR_D_GBL_IFS_MISC_FORCE_XMIT_SLOT_BOUND	0x08000000
#define AR_D_GBL_IFS_MISC_IGNORE_BACKOFF	0x10000000

/* Bits for AR_DMISC_*. */
#define AR_D_MISC_BKOFF_THRESH_M		0x0000003f
#define AR_D_MISC_BKOFF_THRESH_S		0
#define AR_D_MISC_RETRY_CNT_RESET_EN		0x00000040
#define AR_D_MISC_CW_RESET_EN			0x00000080
#define AR_D_MISC_FRAG_WAIT_EN			0x00000100
#define AR_D_MISC_FRAG_BKOFF_EN			0x00000200
#define AR_D_MISC_CW_BKOFF_EN			0x00001000
#define AR_D_MISC_VIR_COL_HANDLING_M		0x0000c000
#define AR_D_MISC_VIR_COL_HANDLING_S		14
#define AR_D_MISC_VIR_COL_HANDLING_DEFAULT	0
#define AR_D_MISC_VIR_COL_HANDLING_IGNORE	1
#define AR_D_MISC_BEACON_USE			0x00010000
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_M		0x00060000
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_S		17
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_NONE	0
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_INTRA_FR	1
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_GLOBAL	2
#define AR_D_MISC_ARB_LOCKOUT_IGNORE		0x00080000
#define AR_D_MISC_SEQ_NUM_INCR_DIS		0x00100000
#define AR_D_MISC_POST_FR_BKOFF_DIS		0x00200000
#define AR_D_MISC_VIT_COL_CW_BKOFF_EN		0x00400000
#define AR_D_MISC_BLOWN_IFS_RETRY_EN		0x00800000

/* Bits for AR_D_FPCTL. */
#define AR_D_FPCTL_DCU_M		0x0000000f
#define AR_D_FPCTL_DCU_S		0
#define AR_D_FPCTL_PREFETCH_EN		0x00000010
#define AR_D_FPCTL_BURST_PREFETCH_M	0x00007fe0
#define AR_D_FPCTL_BURST_PREFETCH_S	5

/* Bits for AR_D_TXPSE. */
#define AR_D_TXPSE_CTRL_M	0x000003ff
#define AR_D_TXPSE_CTRL_S	0
#define AR_D_TXPSE_STATUS	0x00010000

/* Bits for AR_D_TXSLOTMASK. */
#define AR_D_TXSLOTMASK_NUM	0x0000000f

/* Bits for AR_MAC_SLEEP. */
#define AR_MAC_SLEEP_MAC_ASLEEP	0x00000001

/* Bits for AR_CFG_LED. */
#define AR_CFG_SCLK_RATE_IND_M		0x00000003
#define AR_CFG_SCLK_RATE_IND_S		0
#define AR_CFG_SCLK_32MHZ		0
#define AR_CFG_SCLK_4MHZ		1
#define AR_CFG_SCLK_1MHZ		2
#define AR_CFG_SCLK_32KHZ		3
#define AR_CFG_LED_BLINK_SLOW		0x00000008
#define AR_CFG_LED_BLINK_THRESH_SEL_M	0x00000070
#define AR_CFG_LED_BLINK_THRESH_SEL_S	4
#define AR_CFG_LED_MODE_SEL_M		0x00000380
#define AR_CFG_LED_MODE_SEL_S		7
#define AR_CFG_LED_POWER_M		0x00000280
#define AR_CFG_LED_POWER_S		7
#define AR_CFG_LED_NETWORK_M		0x00000300
#define AR_CFG_LED_NETWORK_S		7
#define AR_CFG_LED_MODE_PROP		0
#define AR_CFG_LED_MODE_RPROP		1
#define AR_CFG_LED_MODE_SPLIT		2
#define AR_CFG_LED_MODE_RAND		3
#define AR_CFG_LED_MODE_POWER_OFF	4
#define AR_CFG_LED_MODE_POWER_ON	5
#define AR_CFG_LED_MODE_NETWORK_OFF	4
#define AR_CFG_LED_MODE_NETWORK_ON	6
#define AR_CFG_LED_ASSOC_CTL_M		0x00000c00
#define AR_CFG_LED_ASSOC_CTL_S		10
#define AR_CFG_LED_ASSOC_NONE		0
#define AR_CFG_LED_ASSOC_ACTIVE		1
#define AR_CFG_LED_ASSOC_PENDING	2

/* Bit for AR_RC. */
#define AR_RC_AHB	0x00000001
#define AR_RC_APB	0x00000002
#define AR_RC_HOSTIF	0x00000100

/* Bits for AR_WA. */
#define AR5416_WA_DEFAULT	0x0000073f
#define AR9280_WA_DEFAULT	0x0040073b
#define AR9285_WA_DEFAULT	0x004a050b
#define AR_WA_UNTIE_RESET_EN	0x00008000
#define AR_WA_RESET_EN		0x00040000
#define AR_WA_ANALOG_SHIFT	0x00100000
#define AR_WA_POR_SHORT		0x00200000

/* Bits for AR_PM_STATE. */
#define AR_PM_STATE_PME_D3COLD_VAUX	0x00100000

/* Bits for AR_PCIE_PM_CTRL. */
#define AR_PCIE_PM_CTRL_ENA	0x00080000

/* Bits for AR_HOST_TIMEOUT. */
#define AR_HOST_TIMEOUT_APB_CNTR_M	0x0000ffff
#define AR_HOST_TIMEOUT_APB_CNTR_S	0
#define AR_HOST_TIMEOUT_LCL_CNTR_M	0xffff0000
#define AR_HOST_TIMEOUT_LCL_CNTR_S	16

/* Bits for AR_EEPROM. */
#define AR_EEPROM_ABSENT	0x00000100
#define AR_EEPROM_CORRUPT	0x00000200
#define AR_EEPROM_PROT_MASK_M	0x03fffc00
#define AR_EEPROM_PROT_MASK_S	10

/* Bits for AR_SREV. */
#define AR_SREV_ID_M			0x000000ff
#define AR_SREV_ID_S			0
#define AR_SREV_REVISION_M		0x00000007
#define AR_SREV_REVISION_S		0
#define AR_SREV_VERSION_M		0x000000f0
#define AR_SREV_VERSION_S		4
#define AR_SREV_VERSION2_M		0xfffc0000
#define AR_SREV_VERSION2_S		12		/* XXX Hack. */
#define AR_SREV_TYPE2_M			0x0003f000
#define AR_SREV_TYPE2_S			12
#define AR_SREV_TYPE2_CHAIN		0x00001000
#define AR_SREV_TYPE2_HOST_MODE		0x00002000
#define AR_SREV_REVISION2_M		0x00000f00
#define AR_SREV_REVISION2_S		8
#define AR_SREV_VERSION_5416_PCI	0x00d
#define AR_SREV_VERSION_5416_PCIE	0x00c
#define AR_SREV_REVISION_5416_10	0
#define AR_SREV_REVISION_5416_20	1
#define AR_SREV_REVISION_5416_22	2
#define AR_SREV_VERSION_9100		0x014
#define AR_SREV_VERSION_9160		0x040
#define AR_SREV_REVISION_9160_10	0
#define AR_SREV_REVISION_9160_11	1
#define AR_SREV_VERSION_9280		0x080
#define AR_SREV_REVISION_9280_10	0
#define AR_SREV_REVISION_9280_20	1
#define AR_SREV_REVISION_9280_21	2
#define AR_SREV_VERSION_9285		0x0c0
#define AR_SREV_REVISION_9285_10	0
#define AR_SREV_REVISION_9285_11	1
#define AR_SREV_REVISION_9285_12	2
#define AR_SREV_VERSION_9271		0x140
#define AR_SREV_REVISION_9271_10	0
#define AR_SREV_REVISION_9271_11	1
#define AR_SREV_VERSION_9287		0x180
#define AR_SREV_REVISION_9287_10	0
#define AR_SREV_REVISION_9287_11	1
#define AR_SREV_REVISION_9287_12	2
#define AR_SREV_REVISION_9287_13	3
#define AR_SREV_VERSION_9380		0x1c0
#define AR_SREV_REVISION_9380_10	0
#define AR_SREV_REVISION_9380_20	2
#define AR_SREV_VERSION_9485		0x240
#define AR_SREV_REVISION_9485_10	0

/* Bits for AR_AHB_MODE. */
#define AR_AHB_EXACT_WR_EN			0x00000000
#define AR_AHB_BUF_WR_EN			0x00000001
#define AR_AHB_EXACT_RD_EN			0x00000000
#define AR_AHB_CACHELINE_RD_EN			0x00000002
#define AR_AHB_PREFETCH_RD_EN			0x00000004
#define AR_AHB_PAGE_SIZE_1K			0x00000000
#define AR_AHB_PAGE_SIZE_2K			0x00000008
#define AR_AHB_PAGE_SIZE_4K			0x00000010
#define AR_AHB_CUSTOM_BURST_M			0x000000c0
#define AR_AHB_CUSTOM_BURST_S			6
#define AR_AHB_CUSTOM_BURST_ASYNC_FIFO_VAL	3

/* Bits for AR_INTR_SYNC_CAUSE. */
#define AR_INTR_SYNC_RTC_IRQ			0x00000001
#define AR_INTR_SYNC_MAC_IRQ			0x00000002
#define AR_INTR_SYNC_EEPROM_ILLEGAL_ACCESS	0x00000004
#define AR_INTR_SYNC_APB_TIMEOUT		0x00000008
#define AR_INTR_SYNC_PCI_MODE_CONFLICT		0x00000010
#define AR_INTR_SYNC_HOST1_FATAL		0x00000020
#define AR_INTR_SYNC_HOST1_PERR			0x00000040
#define AR_INTR_SYNC_TRCV_FIFO_PERR		0x00000080
#define AR_INTR_SYNC_RADM_CPL_EP		0x00000100
#define AR_INTR_SYNC_RADM_CPL_DLLP_ABORT	0x00000200
#define AR_INTR_SYNC_RADM_CPL_TLP_ABORT		0x00000400
#define AR_INTR_SYNC_RADM_CPL_ECRC_ERR		0x00000800
#define AR_INTR_SYNC_RADM_CPL_TIMEOUT		0x00001000
#define AR_INTR_SYNC_LOCAL_TIMEOUT		0x00002000
#define AR_INTR_SYNC_PM_ACCESS			0x00004000
#define AR_INTR_SYNC_MAC_AWAKE			0x00008000
#define AR_INTR_SYNC_MAC_ASLEEP			0x00010000
#define AR_INTR_SYNC_MAC_SLEEP_ACCESS		0x00020000
#define AR_INTR_SYNC_ALL			0x0003ffff
#define AR_INTR_SYNC_GPIO_PIN(i)		(1 << (18 + (i)))

#define AR_INTR_SYNC_DEFAULT			\
	(AR_INTR_SYNC_HOST1_FATAL |		\
	 AR_INTR_SYNC_HOST1_PERR |		\
	 AR_INTR_SYNC_RADM_CPL_EP |		\
	 AR_INTR_SYNC_RADM_CPL_DLLP_ABORT |	\
	 AR_INTR_SYNC_RADM_CPL_TLP_ABORT |	\
	 AR_INTR_SYNC_RADM_CPL_ECRC_ERR |	\
	 AR_INTR_SYNC_RADM_CPL_TIMEOUT |	\
	 AR_INTR_SYNC_LOCAL_TIMEOUT |		\
	 AR_INTR_SYNC_MAC_SLEEP_ACCESS)

/* Bits for AR_INTR_ASYNC_CAUSE. */
#define AR_INTR_RTC_IRQ		0x00000001
#define AR_INTR_MAC_IRQ		0x00000002
#define AR_INTR_EEP_PROT_ACCESS	0x00000004
#define AR_INTR_MAC_AWAKE	0x00020000
#define AR_INTR_MAC_ASLEEP	0x00040000
#define AR_INTR_GPIO_PIN(i)	(1 << (18 + (i)))
#define AR_INTR_SPURIOUS	0xffffffff

/* Bits for AR_GPIO_OE_OUT. */
#define AR_GPIO_OE_OUT_DRV_M	0x00000003
#define AR_GPIO_OE_OUT_DRV_S	0
#define AR_GPIO_OE_OUT_DRV_NO	0
#define AR_GPIO_OE_OUT_DRV_LOW	1
#define AR_GPIO_OE_OUT_DRV_HI	2
#define AR_GPIO_OE_OUT_DRV_ALL	3

/* Bits for AR_GPIO_INTR_POL. */
#define AR_GPIO_INTR_POL_PIN(i)		(1 << (i))

/* Bits for AR_GPIO_INPUT_EN_VAL. */
#define AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_DEF	0x00000004
#define AR_GPIO_INPUT_EN_VAL_BT_FREQUENCY_DEF	0x00000008
#define AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_DEF	0x00000010
#define AR_GPIO_INPUT_EN_VAL_RFSILENT_DEF	0x00000080
#define AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_BB	0x00000400
#define AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_BB	0x00001000
#define AR_GPIO_INPUT_EN_VAL_RFSILENT_BB	0x00008000
#define AR_GPIO_RTC_RESET_OVERRIDE_ENABLE	0x00010000
#define AR_GPIO_JTAG_DISABLE			0x00020000

/* Bits for AR_GPIO_INPUT_MUX1. */
#define AR_GPIO_INPUT_MUX1_BT_PRIORITY_M	0x00000f00
#define AR_GPIO_INPUT_MUX1_BT_PRIORITY_S	8
#define AR_GPIO_INPUT_MUX1_BT_ACTIVE_M		0x000f0000
#define AR_GPIO_INPUT_MUX1_BT_ACTIVE_S		16

/* Bits for AR_GPIO_INPUT_MUX2. */
#define AR_GPIO_INPUT_MUX2_CLK25_M		0x0000000f
#define AR_GPIO_INPUT_MUX2_CLK25_S		0
#define AR_GPIO_INPUT_MUX2_RFSILENT_M		0x000000f0
#define AR_GPIO_INPUT_MUX2_RFSILENT_S		4
#define AR_GPIO_INPUT_MUX2_RTC_RESET_M		0x00000f00
#define AR_GPIO_INPUT_MUX2_RTC_RESET_S		8

/* Bits for AR_GPIO_OUTPUT_MUX[1-3]. */
#define AR_GPIO_OUTPUT_MUX_AS_OUTPUT			0
#define AR_GPIO_OUTPUT_MUX_AS_PCIE_ATTENTION_LED	1
#define AR_GPIO_OUTPUT_MUX_AS_PCIE_POWER_LED		2
#define AR_GPIO_OUTPUT_MUX_AS_TX_FRAME			3
#define AR_GPIO_OUTPUT_MUX_AS_RX_CLEAR_EXTERNAL		4
#define AR_GPIO_OUTPUT_MUX_AS_MAC_NETWORK_LED		5
#define AR_GPIO_OUTPUT_MUX_AS_MAC_POWER_LED		6

/* Bits for AR_EEPROM_STATUS_DATA. */
#define AR_EEPROM_STATUS_DATA_VAL_M		0x0000ffff
#define AR_EEPROM_STATUS_DATA_VAL_S		0
#define AR_EEPROM_STATUS_DATA_BUSY		0x00010000
#define AR_EEPROM_STATUS_DATA_BUSY_ACCESS	0x00020000
#define AR_EEPROM_STATUS_DATA_PROT_ACCESS	0x00040000
#define AR_EEPROM_STATUS_DATA_ABSENT_ACCESS	0x00080000

/* Bits for AR_PCIE_MSI. */
#define AR_PCIE_MSI_ENABLE	0x00000001

/* Bits for AR_RTC_RC. */
#define AR_RTC_RC_MAC_WARM	0x00000001
#define AR_RTC_RC_MAC_COLD	0x00000002
#define AR_RTC_RC_COLD_RESET	0x00000004
#define AR_RTC_RC_WARM_RESET	0x00000008

/* Bits for AR_RTC_REG_CONTROL1. */
#define AR_RTC_REG_CONTROL1_SWREG_PROGRAM	0x00000001

/* Bits for AR_RTC_PLL_CONTROL. */
#define AR_RTC_PLL_DIV_M		0x0000001f
#define AR_RTC_PLL_DIV_S		0
#define AR_RTC_PLL_DIV2			0x00000020
#define AR_RTC_PLL_REFDIV_5		0x000000c0
#define AR_RTC_PLL_CLKSEL_M		0x00000300
#define AR_RTC_PLL_CLKSEL_S		8
#define AR_RTC_9160_PLL_DIV_M		0x000003ff
#define AR_RTC_9160_PLL_DIV_S		0
#define AR_RTC_9160_PLL_REFDIV_M	0x00003c00
#define AR_RTC_9160_PLL_REFDIV_S	10
#define AR_RTC_9160_PLL_CLKSEL_M	0x0000c000
#define AR_RTC_9160_PLL_CLKSEL_S	14

/* Bits for AR_RTC_RESET. */
#define AR_RTC_RESET_EN		0x00000001

/* Bits for AR_RTC_STATUS. */
#define AR_RTC_STATUS_M		0x0000000f
#define AR_RTC_STATUS_S		0
#define AR_RTC_STATUS_SHUTDOWN	0x00000001
#define AR_RTC_STATUS_ON	0x00000002
#define AR_RTC_STATUS_SLEEP	0x00000004
#define AR_RTC_STATUS_WAKEUP	0x00000008

/* Bits for AR_RTC_SLEEP_CLK. */
#define AR_RTC_FORCE_DERIVED_CLK	0x00000002
#define AR_RTC_FORCE_SWREG_PRD		0x00000004

/* Bits for AR_RTC_FORCE_WAKE. */
#define AR_RTC_FORCE_WAKE_EN		0x00000001
#define AR_RTC_FORCE_WAKE_ON_INT	0x00000002

/* Bits for AR_STA_ID1. */
#define AR_STA_ID1_SADH_M		0x0000ffff
#define AR_STA_ID1_SADH_S		0
#define AR_STA_ID1_STA_AP		0x00010000
#define AR_STA_ID1_ADHOC		0x00020000
#define AR_STA_ID1_PWR_SAV		0x00040000
#define AR_STA_ID1_KSRCHDIS		0x00080000
#define AR_STA_ID1_PCF			0x00100000
#define AR_STA_ID1_USE_DEFANT		0x00200000
#define AR_STA_ID1_DEFANT_UPDATE	0x00400000
#define AR_STA_ID1_RTS_USE_DEF		0x00800000
#define AR_STA_ID1_ACKCTS_6MB		0x01000000
#define AR_STA_ID1_BASE_RATE_11B	0x02000000
#define AR_STA_ID1_SECTOR_SELF_GEN	0x04000000
#define AR_STA_ID1_CRPT_MIC_ENABLE	0x08000000
#define AR_STA_ID1_KSRCH_MODE		0x10000000
#define AR_STA_ID1_PRESERVE_SEQNUM	0x20000000
#define AR_STA_ID1_CBCIV_ENDIAN		0x40000000
#define AR_STA_ID1_MCAST_KSRCH		0x80000000

/* Bits for AR_BSS_ID1. */
#define AR_BSS_ID1_U16_M	0x0000ffff
#define AR_BSS_ID1_U16_S	0
#define AR_BSS_ID1_AID_M	0x07ff0000
#define AR_BSS_ID1_AID_S	16

/* Bits for AR_TIME_OUT. */
#define AR_TIME_OUT_ACK_M			0x00003fff
#define AR_TIME_OUT_ACK_S			0
#define AR_TIME_OUT_CTS_M			0x3fff0000
#define AR_TIME_OUT_CTS_S			16
#define AR_TIME_OUT_ACK_CTS_ASYNC_FIFO_DUR	0x16001d56

/* Bits for AR_RSSI_THR. */
#define AR_RSSI_THR_M		0x000000ff
#define AR_RSSI_THR_S		0
#define AR_RSSI_THR_BM_THR_M	0x0000ff00
#define AR_RSSI_THR_BM_THR_S	8
#define AR_RSSI_BCN_WEIGHT_M	0x1f000000
#define AR_RSSI_BCN_WEIGHT_S	24
#define AR_RSSI_BCN_RSSI_RST	0x20000000

/* Bits for AR_USEC. */
#define AR_USEC_USEC_M		0x0000007f
#define AR_USEC_USEC_S		0
#define AR_USEC_TX_LAT_M	0x007fc000
#define AR_USEC_TX_LAT_S	14
#define AR_USEC_RX_LAT_M	0x1f800000
#define AR_USEC_RX_LAT_S	23
#define AR_USEC_ASYNC_FIFO_DUR	0x12e00074

/* Bits for AR_RESET_TSF. */
#define AR_RESET_TSF_ONCE	0x01000000

/* Bits for AR_RX_FILTER. */
#define AR_RX_FILTER_UCAST	0x00000001
#define AR_RX_FILTER_MCAST	0x00000002
#define AR_RX_FILTER_BCAST	0x00000004
#define AR_RX_FILTER_CONTROL	0x00000008
#define AR_RX_FILTER_BEACON	0x00000010
#define AR_RX_FILTER_PROM	0x00000020
#define AR_RX_FILTER_PROBEREQ	0x00000080
#define AR_RX_FILTER_MYBEACON	0x00000200
#define AR_RX_FILTER_COMPR_BAR	0x00000400
#define AR_RX_FILTER_PSPOLL	0x00004000

/* Bits for AR_DIAG_SW. */
#define AR_DIAG_CACHE_ACK		0x00000001
#define AR_DIAG_ACK_DIS			0x00000002
#define AR_DIAG_CTS_DIS			0x00000004
#define AR_DIAG_ENCRYPT_DIS		0x00000008
#define AR_DIAG_DECRYPT_DIS		0x00000010
#define AR_DIAG_RX_DIS			0x00000020
#define AR_DIAG_LOOP_BACK		0x00000040
#define AR_DIAG_CORR_FCS		0x00000080
#define AR_DIAG_CHAN_INFO		0x00000100
#define AR_DIAG_SCRAM_SEED_M		0x0001fe00
#define AR_DIAG_SCRAM_SEED_S		8	/* XXX should be 9? */
#define AR_DIAG_FRAME_NV0		0x00020000
#define AR_DIAG_OBS_PT_SEL1_M		0x000c0000
#define AR_DIAG_OBS_PT_SEL1_S		18
#define AR_DIAG_FORCE_RX_CLEAR		0x00100000
#define AR_DIAG_IGNORE_VIRT_CS		0x00200000
#define AR_DIAG_FORCE_CH_IDLE_HIGH	0x00400000
#define AR_DIAG_EIFS_CTRL_ENA		0x00800000
#define AR_DIAG_DUAL_CHAIN_INFO		0x01000000
#define AR_DIAG_RX_ABORT		0x02000000
#define AR_DIAG_SATURATE_CYCLE_CNT	0x04000000
#define AR_DIAG_OBS_PT_SEL2		0x08000000
#define AR_DIAG_RX_CLEAR_CTL_LOW	0x10000000
#define AR_DIAG_RX_CLEAR_EXT_LOW	0x20000000

/* Bits for AR_AES_MUTE_MASK0. */
#define AR_AES_MUTE_MASK0_FC_M	0x0000ffff
#define AR_AES_MUTE_MASK0_FC_S	0
#define AR_AES_MUTE_MASK0_QOS_M	0xffff0000
#define AR_AES_MUTE_MASK0_QOS_S	16

/* Bits for AR_AES_MUTE_MASK1. */
#define AR_AES_MUTE_MASK1_SEQ_M		0x0000ffff
#define AR_AES_MUTE_MASK1_SEQ_S		0
#define AR_AES_MUTE_MASK1_FC_MGMT_M	0xffff0000
#define AR_AES_MUTE_MASK1_FC_MGMT_S	16
#define AR_AES_MUTE_MASK1_FC0_MGMT_M	0x00ff0000
#define AR_AES_MUTE_MASK1_FC0_MGMT_S	16
#define AR_AES_MUTE_MASK1_FC1_MGMT_M	0xff000000
#define AR_AES_MUTE_MASK1_FC1_MGMT_S	24

/* Bits for AR_GATED_CLKS. */
#define AR_GATED_CLKS_TX	0x00000002
#define AR_GATED_CLKS_RX	0x00000004
#define AR_GATED_CLKS_REG	0x00000008

/* Bits for AR_OBS_BUS_CTRL. */
#define AR_OBS_BUS_SEL_1	0x00040000
#define AR_OBS_BUS_SEL_2	0x00080000
#define AR_OBS_BUS_SEL_3	0x000c0000
#define AR_OBS_BUS_SEL_4	0x08040000
#define AR_OBS_BUS_SEL_5	0x08080000

/* Bits for AR_OBS_BUS_1. */
#define AR_OBS_BUS_1_PCU		0x00000001
#define AR_OBS_BUS_1_RX_END		0x00000002
#define AR_OBS_BUS_1_RX_WEP		0x00000004
#define AR_OBS_BUS_1_RX_BEACON		0x00000008
#define AR_OBS_BUS_1_RX_FILTER		0x00000010
#define AR_OBS_BUS_1_TX_HCF		0x00000020
#define AR_OBS_BUS_1_QUIET_TIME		0x00000040
#define AR_OBS_BUS_1_CHAN_IDLE		0x00000080
#define AR_OBS_BUS_1_TX_HOLD		0x00000100
#define AR_OBS_BUS_1_TX_FRAME		0x00000200
#define AR_OBS_BUS_1_RX_FRAME		0x00000400
#define AR_OBS_BUS_1_RX_CLEAR		0x00000800
#define AR_OBS_BUS_1_WEP_STATE_M	0x0003f000
#define AR_OBS_BUS_1_WEP_STATE_S	12
#define AR_OBS_BUS_1_RX_STATE_M		0x01f00000
#define AR_OBS_BUS_1_RX_STATE_S		20
#define AR_OBS_BUS_1_TX_STATE_M		0x7e000000
#define AR_OBS_BUS_1_TX_STATE_S		25

/* Bits for AR_SLEEP1. */
#define AR_SLEEP1_ASSUME_DTIM		0x00080000
#define AR_SLEEP1_CAB_TIMEOUT_M		0xffe00000
#define AR_SLEEP1_CAB_TIMEOUT_S		21
/* Default value. */
#define AR_CAB_TIMEOUT_VAL		10

/* Bits for AR_SLEEP2. */
#define AR_SLEEP2_BEACON_TIMEOUT_M	0xffe00000
#define AR_SLEEP2_BEACON_TIMEOUT_S	21

/* Bits for AR_TPC. */
#define AR_TPC_ACK_M	0x0000003f
#define AR_TPC_ACK_S	0
#define AR_TPC_CTS_M	0x00003f00
#define AR_TPC_CTS_S	8
#define AR_TPC_CHIRP_M	0x003f0000
#define AR_TPC_CHIRP_S	16

/* Bits for AR_QUIET1. */
#define AR_QUIET1_NEXT_QUIET_M		0x0000ffff
#define AR_QUIET1_NEXT_QUIET_S		0
#define AR_QUIET1_QUIET_ENABLE		0x00010000
#define AR_QUIET1_QUIET_ACK_CTS_ENABLE	0x00020000

/* Bits for AR_QUIET2. */
#define AR_QUIET2_QUIET_PERIOD_M	0x0000ffff
#define AR_QUIET2_QUIET_PERIOD_S	0
#define AR_QUIET2_QUIET_DUR_M		0xffff0000
#define AR_QUIET2_QUIET_DUR_S		16

/* Bits for AR_TSF_PARM. */
#define AR_TSF_INCREMENT_M	0x000000ff
#define AR_TSF_INCREMENT_S	0

/* Bits for AR_QOS_NO_ACK. */
#define AR_QOS_NO_ACK_TWO_BIT_M		0x0000000f
#define AR_QOS_NO_ACK_TWO_BIT_S		0
#define AR_QOS_NO_ACK_BIT_OFF_M		0x0000007f
#define AR_QOS_NO_ACK_BIT_OFF_S		4
#define AR_QOS_NO_ACK_BYTE_OFF_M	0x00000180
#define AR_QOS_NO_ACK_BYTE_OFF_S	7

/* Bits for AR_PHY_ERR. */
#define AR_PHY_ERR_DCHIRP	0x00000008
#define AR_PHY_ERR_RADAR	0x00000020
#define AR_PHY_ERR_OFDM_TIMING	0x00020000
#define AR_PHY_ERR_CCK_TIMING	0x02000000

/* Bits for AR_PCU_MISC. */
#define AR_PCU_FORCE_BSSID_MATCH	0x00000001
#define AR_PCU_MIC_NEW_LOC_ENA		0x00000004
#define AR_PCU_TX_ADD_TSF		0x00000008
#define AR_PCU_CCK_SIFS_MODE		0x00000010
#define AR_PCU_RX_ANT_UPDT		0x00000800
#define AR_PCU_TXOP_TBTT_LIMIT_ENA	0x00001000
#define AR_PCU_MISS_BCN_IN_SLEEP	0x00004000
#define AR_PCU_BUG_12306_FIX_ENA	0x00020000
#define AR_PCU_FORCE_QUIET_COLL		0x00040000
#define AR_PCU_BT_ANT_PREVENT_RX	0x00100000
#define AR_PCU_TBTT_PROTECT		0x00200000
#define AR_PCU_CLEAR_VMF		0x01000000
#define AR_PCU_CLEAR_BA_VALID		0x04000000

/* Bits for AR_BT_COEX_MODE. */
#define AR_BT_TIME_EXTEND_M	0x000000ff
#define AR_BT_TIME_EXTEND_S	0
#define AR_BT_TXSTATE_EXTEND	0x00000100
#define AR_BT_TX_FRAME_EXTEND	0x00000200
#define AR_BT_MODE_M		0x00000c00
#define AR_BT_MODE_S		10
#define AR_BT_MODE_LEGACY	0
#define AR_BT_MODE_UNSLOTTED	1
#define AR_BT_MODE_SLOTTED	2
#define AR_BT_MODE_DISABLED	3
#define AR_BT_QUIET		0x00001000
#define AR_BT_QCU_THRESH_M	0x0001e000
#define AR_BT_QCU_THRESH_S	13
#define AR_BT_RX_CLEAR_POLARITY	0x00020000
#define AR_BT_PRIORITY_TIME_M	0x00fc0000
#define AR_BT_PRIORITY_TIME_S	18
#define AR_BT_FIRST_SLOT_TIME_M	0xff000000
#define AR_BT_FIRST_SLOT_TIME_S	24

/* Bits for AR_BT_COEX_WEIGHT. */
#define AR_BTCOEX_BT_WGHT_M	0x0000ffff
#define AR_BTCOEX_BT_WGHT_S	0
#define AR_STOMP_LOW_BT_WGHT	0xff55
#define AR_BTCOEX_WL_WGHT_M	0xffff0000
#define AR_BTCOEX_WL_WGHT_S	16
#define AR_STOMP_LOW_WL_WGHT	0xaaa8

/* Bits for AR_BT_COEX_MODE2. */
#define AR_BT_BCN_MISS_THRESH_M	0x000000ff
#define AR_BT_BCN_MISS_THRESH_S	0
#define AR_BT_BCN_MISS_CNT_M	0x0000ff00
#define AR_BT_BCN_MISS_CNT_S	8
#define AR_BT_HOLD_RX_CLEAR	0x00010000
#define AR_BT_DISABLE_BT_ANT	0x00100000

/* Bits for AR_PCU_TXBUF_CTRL. */
#define AR_PCU_TXBUF_CTRL_SIZE_M		0x000007ff
#define AR_PCU_TXBUF_CTRL_SIZE_S		0
#define AR_PCU_TXBUF_CTRL_USABLE_SIZE		1792
#define AR9285_PCU_TXBUF_CTRL_USABLE_SIZE	(1792 / 2)

/* Bits for AR_PCU_MISC_MODE2. */
#define AR_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE		0x00000002
#define AR_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT	0x00000004
#define AR_PCU_MISC_MODE2_AGG_WEP_ENABLE_FIX		0x00000008
#define AR_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE	0x00000040
#define AR_PCU_MISC_MODE2_CFP_IGNORE			0x00000080
#define AR_PCU_MISC_MODE2_MGMT_QOS_M			0x0000ff00
#define AR_PCU_MISC_MODE2_MGMT_QOS_S			8
#define AR_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DUR	0x00010000
#define AR_PCU_MISC_MODE2_ENABLE_AGGWEP			0x00020000
#define AR_PCU_MISC_MODE2_HWWAR1			0x00100000
#define AR_PCU_MISC_MODE2_HWWAR2			0x02000000

/* Bits for AR_MAC_PCU_LOGIC_ANALYZER. */
#define AR_MAC_PCU_LOGIC_ANALYZER_DISBUG20768	0x20000000

/* Bits for AR_MAC_PCU_ASYNC_FIFO_REG3. */
#define AR_MAC_PCU_ASYNC_FIFO_REG3_DATAPATH_SEL	0x00000400
#define AR_MAC_PCU_ASYNC_FIFO_REG3_SOFT_RESET	0x80000000

/* Bits for AR_PHY_ERR_[123]. */
#define AR_PHY_ERR_COUNT_M	0x00ffffff
#define AR_PHY_ERR_COUNT_S	0

/* Bits for AR_TSFOOR_THRESHOLD. */
#define AR_TSFOOR_THRESHOLD_VAL_M	0x0000ffff
#define AR_TSFOOR_THRESHOLD_VAL_S	0

/* Bit for AR_TXSIFS. */
#define AR_TXSIFS_TIME_M	0x000000ff
#define AR_TXSIFS_TIME_S	0
#define AR_TXSIFS_TX_LATENCY_M	0x00000f00
#define AR_TXSIFS_TX_LATENCY_S	8
#define AR_TXSIFS_ACK_SHIFT_M	0x00007000
#define AR_TXSIFS_ACK_SHIFT_S	12

/* Bits for AR_TXOP_X. */
#define AR_TXOP_X_VAL	0x000000ff

/* Bits for AR_TIMER_MODE. */
#define AR_TBTT_TIMER_EN		0x00000001
#define AR_DBA_TIMER_EN			0x00000002
#define AR_SWBA_TIMER_EN		0x00000004
#define AR_HCF_TIMER_EN			0x00000008
#define AR_TIM_TIMER_EN			0x00000010
#define AR_DTIM_TIMER_EN		0x00000020
#define AR_QUIET_TIMER_EN		0x00000040
#define AR_NDP_TIMER_EN			0x00000080
#define AR_TIMER_OVERFLOW_INDEX_M	0x00000700
#define AR_TIMER_OVERFLOW_INDEX_S	8
#define AR_TIMER_THRESH_M		0xfffff000
#define AR_TIMER_THRESH_S		12

/* Bits for AR_SLP32_MODE. */
#define AR_SLP32_HALF_CLK_LATENCY_M	0x000fffff
#define AR_SLP32_HALF_CLK_LATENCY_S	0
#define AR_SLP32_ENA			0x00100000
#define AR_SLP32_TSF_WRITE_STATUS	0x00200000

/* Bits for AR_SLP32_WAKE. */
#define AR_SLP32_WAKE_XTL_TIME_M	0x0000ffff
#define AR_SLP32_WAKE_XTL_TIME_S	0

/* Bits for AR_SLP_MIB_CTRL. */
#define AR_SLP_MIB_CLEAR	0x00000001
#define AR_SLP_MIB_PENDING	0x00000002

/* Bits for AR_2040_MODE. */
#define AR_2040_JOINED_RX_CLEAR	0x00000001

/* Bits for AR_KEYTABLE_TYPE. */
#define AR_KEYTABLE_TYPE_M	0x00000007
#define AR_KEYTABLE_TYPE_S	0
#define AR_KEYTABLE_TYPE_40	0
#define AR_KEYTABLE_TYPE_104	1
#define AR_KEYTABLE_TYPE_128	3
#define AR_KEYTABLE_TYPE_TKIP	4
#define AR_KEYTABLE_TYPE_AES	5
#define AR_KEYTABLE_TYPE_CCM	6
#define AR_KEYTABLE_TYPE_CLR	7
#define AR_KEYTABLE_ANT		0x00000008
#define AR_KEYTABLE_VALID	0x00008000

/*
 * AR9271 specific registers.
 */
#define AR9271_RESET_POWER_DOWN_CONTROL	0x050044
#define AR9271_FIRMWARE			0x501000
#define AR9271_FIRMWARE_TEXT		0x903000
#define AR7010_FIRMWARE_TEXT		0x906000

/* Bits for AR9271_RESET_POWER_DOWN_CONTROL. */
#define AR9271_RADIO_RF_RST	0x00000020
#define AR9271_GATE_MAC_CTL	0x00004000


#define AR_BASE_PHY_ACTIVE_DELAY	100

#define AR_CLOCK_RATE_CCK		22
#define AR_CLOCK_RATE_5GHZ_OFDM		40
#define AR_CLOCK_RATE_FAST_5GHZ_OFDM	44
#define AR_CLOCK_RATE_2GHZ_OFDM		44

#define AR_PWR_DECREASE_FOR_2_CHAIN	6	/* 10 * log10(2) * 2 */
#define AR_PWR_DECREASE_FOR_3_CHAIN	9	/* 10 * log10(3) * 2 */

#define AR_SLEEP_SLOP	3	/* TUs */

#define AR_MIN_BEACON_TIMEOUT_VAL	1
#define AR_FUDGE			2
#define AR_BEACON_DMA_DELAY		2
#define AR_SWBA_DELAY			10
/* Divides by 1024 (usecs to TU) without doing 64-bit arithmetic. */
#define AR_TSF_TO_TU(hi, lo)	((hi) << 22 | (lo) >> 10)

#define AR_KEY_CACHE_SIZE		128
#define AR_RSVD_KEYTABLE_ENTRIES	4

#define AR_CAL_SAMPLES	64	/* XXX AR9280? */
#define AR_MAX_LOG_CAL	2	/* XXX AR9280? */

/* Maximum number of chains supported by any chipset. */
#define AR_MAX_CHAINS	3

/* Default number of key cache entries. */
#define AR_KEYTABLE_SIZE	128

/* GPIO pins. */
#define AR_GPIO_WLANACTIVE_PIN	5
#define AR_GPIO_BTACTIVE_PIN	6
#define AR_GPIO_BTPRIORITY_PIN	7

#define AR_SREV_5416(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_5416_PCI || \
	 (sc)->mac_ver == AR_SREV_VERSION_5416_PCIE)
#define AR_SREV_5416_20_OR_LATER(sc) \
	((AR_SREV_5416(sc) && \
	  (sc)->mac_rev >= AR_SREV_REVISION_5416_20) || \
	 (sc)->mac_ver >= AR_SREV_VERSION_9100)
#define AR_SREV_5416_22_OR_LATER(sc) \
	((AR_SREV_5416(sc) && \
	  (sc)->mac_rev >= AR_SREV_REVISION_5416_22) || \
	 (sc)->mac_ver >= AR_SREV_VERSION_9100)

#define AR_SREV_9160(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9160)
#define AR_SREV_9160_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9160)
#define AR_SREV_9160_11(sc) \
	(AR_SREV_9160(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9160_11)

#define AR_SREV_9280(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9280)
#define AR_SREV_9280_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9280)
#define AR_SREV_9280_10(sc) \
	(AR_SREV_9280(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9280_10)
#define AR_SREV_9280_20(sc) \
	(AR_SREV_9280(sc) && \
	 (sc)->mac_rev >= AR_SREV_REVISION_9280_20)
#define AR_SREV_9280_20_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9280 || \
	 (AR_SREV_9280(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9280_20))

#define AR_SREV_9285(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9285)
#define AR_SREV_9285_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9285)
#define AR_SREV_9285_11(sc) \
	(AR_SREV_9285(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9285_11)
#define AR_SREV_9285_11_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9285 || \
	 (AR_SREV_9285(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9285_11))
#define AR_SREV_9285_12(sc) \
	(AR_SREV_9285(sc) && \
	 ((sc)->mac_rev == AR_SREV_REVISION_9285_12))
#define AR_SREV_9285_12_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9285 || \
	 (AR_SREV_9285(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9285_12))

#define AR_SREV_9271(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9271)
#define AR_SREV_9271_10(sc) \
	(AR_SREV_9271(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9271_10)

#define AR_SREV_9287(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287)
#define AR_SREV_9287_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9287)
#define AR_SREV_9287_10(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_10)
#define AR_SREV_9287_11(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_11)
#define AR_SREV_9287_11_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9287 || \
	 (AR_SREV_9287(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9287_11))
#define AR_SREV_9287_12(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_12)
#define AR_SREV_9287_12_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9287 || \
	 (AR_SREV_9287(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9287_12))
#define AR_SREV_9287_13_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9287 || \
	 (AR_SREV_9287(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9287_13))

#define AR_SREV_9380(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9380)
#define AR_SREV_9380_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9380)
#define AR_SREV_9380_20(sc) \
	(AR_SREV_9380(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9380_20)
#define AR_SREV_9380_20_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9380 || \
	 (AR_SREV_9380(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9380_20))

#define AR_SREV_9485(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9485)

#define AR_SINGLE_CHIP(sc)	AR_SREV_9280_10_OR_LATER(sc)

#define AR_RADIO_SREV_MAJOR	0xf0
#define AR_RAD5133_SREV_MAJOR	0xc0
#define AR_RAD2133_SREV_MAJOR	0xd0
#define AR_RAD5122_SREV_MAJOR	0xe0
#define AR_RAD2122_SREV_MAJOR	0xf0

#define AR_BCHAN_UNUSED		0xff
#define AR_PD_GAINS_IN_MASK	4	/* NB: Max for all chips. */
#define AR_MAX_RATE_POWER	63

#define AR_HT40_POWER_INC_FOR_PDADC	2
#define AR_PWR_TABLE_OFFSET_DB		(-5)
#define AR9280_TX_GAIN_TABLE_SIZE	22
#define AR9003_TX_GAIN_TABLE_SIZE	32
#define AR9003_PAPRD_MEM_TAB_SIZE	24

#define AR_BASE_FREQ_2GHZ	2300
#define AR_BASE_FREQ_5GHZ	4900

#define AR_SD_NO_CTL	0xe0
#define AR_NO_CTL	0xff
#define AR_CTL_MODE_M	0x07
#define AR_CTL_MODE_S	0
#define AR_CTL_11A	0
#define AR_CTL_11B	1
#define AR_CTL_11G	2
#define AR_CTL_2GHT20	5
#define AR_CTL_5GHT20	6
#define AR_CTL_2GHT40	7
#define AR_CTL_5GHT40	8

/*
 * Macros to access registers.
 */
#define AR_READ(sc, reg)						\
	(sc)->ops.read((sc), (reg))

#define AR_WRITE(sc, reg, val)						\
	(sc)->ops.write((sc), (reg), (val))

#define AR_WRITE_BARRIER(sc)						\
	(sc)->ops.write_barrier((sc))

#define AR_SETBITS(sc, reg, mask)					\
	AR_WRITE(sc, reg, AR_READ(sc, reg) | (mask))

#define AR_CLRBITS(sc, reg, mask)					\
	AR_WRITE(sc, reg, AR_READ(sc, reg) & ~(mask))

/*
 * Macros to access subfields in registers.
 */
/* Mask and Shift (getter). */
#define MS(val, field)							\
	(((uint32_t)(val) & field##_M) >> field##_S)

/* Shift and Mask (setter). */
#define SM(field, val)							\
	(((uint32_t)(val) << field##_S) & field##_M)

/* Rewrite. */
#define RW(var, field, val)						\
	(((var) & ~field##_M) | SM(field, val))
