"""Generated message classes for logging version v2beta1.

Writes log entries and manages your Stackdriver Logging configuration.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'logging'


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GetLogsUsageResponse(_messages.Message):
  """The response from `GetLogsUsage`.

  Fields:
    usage: A collection of ranges that describes logs usage and allowed quota
      over requested time period. Ranges are aligned to the full hour, and are
      guaranteed to be contiguous.
  """

  usage = _messages.MessageField('Usage', 1, repeated=True)


class HttpRequest(_messages.Message):
  """A common proto for logging HTTP requests.

  Fields:
    cacheFillBytes: The number of HTTP response bytes inserted into cache. Set
      only when a cache fill was attempted.
    cacheHit: Whether or not an entity was served from cache (with or without
      validation).
    cacheLookup: Whether or not a cache lookup was attempted.
    cacheValidatedWithOriginServer: Whether or not the response was validated
      with the origin server before being served from cache. This field is
      only meaningful if `cache_hit` is True.
    referer: The referer URL of the request, as defined in [HTTP/1.1 Header
      Field
      Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
    remoteIp: The IP address (IPv4 or IPv6) of the client that issued the HTTP
      request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
    requestMethod: The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`,
      `"POST"`.
    requestSize: The size of the HTTP request message in bytes, including the
      request headers and the request body.
    requestUrl: The scheme (http, https), the host name, the path and the
      query portion of the URL that was requested. Example:
      `"http://example.com/some/info?color=red"`.
    responseSize: The size of the HTTP response message sent back to the
      client, in bytes, including the response headers and the response body.
    serverIp: The IP address (IPv4 or IPv6) of the origin server that the
      request was sent to.
    status: The response code indicating the status of response. Examples:
      200, 404.
    userAgent: The user agent sent by the client. Example: `"Mozilla/4.0
      (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
  """

  cacheFillBytes = _messages.IntegerField(1)
  cacheHit = _messages.BooleanField(2)
  cacheLookup = _messages.BooleanField(3)
  cacheValidatedWithOriginServer = _messages.BooleanField(4)
  referer = _messages.StringField(5)
  remoteIp = _messages.StringField(6)
  requestMethod = _messages.StringField(7)
  requestSize = _messages.IntegerField(8)
  requestUrl = _messages.StringField(9)
  responseSize = _messages.IntegerField(10)
  serverIp = _messages.StringField(11)
  status = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  userAgent = _messages.StringField(13)


class InternalEntityId(_messages.Message):
  """A InternalEntityId object.

  Fields:
    billingAccountId: Unique identifier of a billing account
    folderNumber: Gaia Id of a folder
    organizationNumber: Gaia Id of an organization
    projectNumber: Gaia Id of a project
  """

  billingAccountId = _messages.StringField(1)
  folderNumber = _messages.IntegerField(2)
  organizationNumber = _messages.IntegerField(3)
  projectNumber = _messages.IntegerField(4)


class LabelDescriptor(_messages.Message):
  """A description of a label.

  Enums:
    ValueTypeValueValuesEnum: The type of data that can be assigned to the
      label.

  Fields:
    description: A human-readable description for the label.
    key: The label key.
    valueType: The type of data that can be assigned to the label.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    """The type of data that can be assigned to the label.

    Values:
      STRING: A variable-length string. This is the default.
      BOOL: Boolean; true or false.
      INT64: A 64-bit signed integer.
    """
    STRING = 0
    BOOL = 1
    INT64 = 2

  description = _messages.StringField(1)
  key = _messages.StringField(2)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 3)


class ListLogEntriesRequest(_messages.Message):
  """The parameters to `ListLogEntries`.

  Fields:
    filter: Optional. An [advanced logs
      filter](/logging/docs/view/advanced_filters). The filter is compared
      against all log entries in the projects specified by `projectIds`.  Only
      entries that match the filter are retrieved.  An empty filter matches
      all log entries.
    isV1Request: A boolean attribute.
    orderBy: Optional. How the results should be sorted.  Presently, the only
      permitted values are `"timestamp asc"` (default) and `"timestamp desc"`.
      The first option returns entries in order of increasing values of
      `LogEntry.timestamp` (oldest first), and the second option returns
      entries in order of decreasing timestamps (newest first).  Entries with
      equal timestamps are returned in order of `LogEntry.insertId`.
    pageSize: Optional. The maximum number of results to return from this
      request. You must check for presence of `nextPageToken` to determine if
      additional results are available, which you can retrieve by passing the
      `nextPageToken` value as the `pageToken` parameter in the next request.
    pageToken: Optional. If the `pageToken` parameter is supplied, then the
      next page of results is retrieved.  The `pageToken` parameter must be
      set to the value of the `nextPageToken` from the previous response. The
      values of `projectIds`, `filter`, and `orderBy` must be the same as in
      the previous request.
    partialSuccess: Optional. If true, read access to all projects is not
      required and results will be returned for the subset of projects for
      which read access is permitted (empty subset is permitted).
    projectIds: Deprecated. One or more project IDs or project numbers from
      which to retrieve log entries.  Examples of a project ID: `"my-project-
      1A"`, `"1234567890"`.
    resourceNames: One or more cloud resources from which to retrieve log
      entries. These will be combined with the resources from project_ids
      above. e.g. "projects/my-project-1A"
  """

  filter = _messages.StringField(1)
  isV1Request = _messages.BooleanField(2)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  partialSuccess = _messages.BooleanField(6)
  projectIds = _messages.StringField(7, repeated=True)
  resourceNames = _messages.StringField(8, repeated=True)


class ListLogEntriesResponse(_messages.Message):
  """Result returned from `ListLogEntries`.

  Messages:
    ProjectIdErrorsValue: If partial_success is true, contains the project ids
      that had errors and the associated errors.

  Fields:
    entries: A list of log entries.
    lastObservedEntryTimestamp: The timestamp of the last log entry that was
      examined before returning this response. This can be used to observe
      progress between successive queries, in particular when only a page
      token is returned.
    nextPageToken: If there are more results than were returned, then
      `nextPageToken` is included in the response.  To get the next set of
      results, call this method again using the value of `nextPageToken` as
      `pageToken`.
    projectIdErrors: If partial_success is true, contains the project ids that
      had errors and the associated errors.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProjectIdErrorsValue(_messages.Message):
    """If partial_success is true, contains the project ids that had errors
    and the associated errors.

    Messages:
      AdditionalProperty: An additional property for a ProjectIdErrorsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ProjectIdErrorsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ProjectIdErrorsValue object.

      Fields:
        key: Name of the additional property.
        value: A Status attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Status', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entries = _messages.MessageField('LogEntry', 1, repeated=True)
  lastObservedEntryTimestamp = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)
  projectIdErrors = _messages.MessageField('ProjectIdErrorsValue', 4)


class ListLogMetricsResponse(_messages.Message):
  """Result returned from ListLogMetrics.

  Fields:
    metrics: A list of logs-based metrics.
    nextPageToken: If there are more results than were returned, then
      `nextPageToken` is included in the response.  To get the next set of
      results, call this method again using the value of `nextPageToken` as
      `pageToken`.
  """

  metrics = _messages.MessageField('LogMetric', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogsResponse(_messages.Message):
  """Result returned from ListLogs.

  Fields:
    logIds: A list of log ids matching the criteria.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of logs, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListLogs`. If
      `nextPageToken` is empty, then there are no more results.
  """

  logIds = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMonitoredResourceDescriptorsResponse(_messages.Message):
  """Result returned from ListMonitoredResourceDescriptors.

  Fields:
    nextPageToken: If there are more results than were returned, then
      `nextPageToken` is included in the response.  To get the next set of
      results, call this method again using the value of `nextPageToken` as
      `pageToken`.
    resourceDescriptors: A list of resource descriptors.
  """

  nextPageToken = _messages.StringField(1)
  resourceDescriptors = _messages.MessageField('MonitoredResourceDescriptor', 2, repeated=True)


class ListResourceKeysResponse(_messages.Message):
  """Result returned from `ListResourceKeysRequest`.

  Fields:
    logResourceKeys: A list of log resource keys.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of resource types, use the value
      of `nextPageToken` as `pageToken` in the next call of
      `ListResourceKeys`. If `nextPageToken` is empty, then there are no more
      results.
  """

  logResourceKeys = _messages.MessageField('ResourceKeys', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListResourceValuesResponse(_messages.Message):
  """Result returned from ListResourceValues.

  Fields:
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of indexes, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListResourceValues`.
      If `nextPageToken` is empty, then there are no more results.
    resourceValuePrefixes: A list of log resource type index values. Each
      index value has the form `"/value1/value2/..."`, where `value1` is a
      value in the primary index, `value2` is a value in the secondary index,
      and so forth.
  """

  nextPageToken = _messages.StringField(1)
  resourceValuePrefixes = _messages.StringField(2, repeated=True)


class ListSinksResponse(_messages.Message):
  """Result returned from `ListSinks`.

  Fields:
    nextPageToken: If there are more results than were returned, then
      `nextPageToken` is included in the response.  To get the next set of
      results, call this method again using the value of `nextPageToken` as
      `pageToken`.
    sinks: A list of sinks.
  """

  nextPageToken = _messages.StringField(1)
  sinks = _messages.MessageField('LogSink', 2, repeated=True)


class LogEntry(_messages.Message):
  """An individual entry in a log.

  Enums:
    SeverityValueValuesEnum: Optional. The severity of the log entry. The
      default value is `LogSeverity.DEFAULT`.

  Messages:
    JsonPayloadValue: The log entry payload, represented as a structure that
      is expressed as a JSON object.
    LabelsValue: Optional. A set of user-defined (key, value) data that
      provides additional information about the log entry.
    ProtoPayloadValue: The log entry payload, represented as a protocol
      buffer.  Some Google Cloud Platform services use this field for their
      log entry payloads.

  Fields:
    httpRequest: Optional. Information about the HTTP request associated with
      this log entry, if applicable.
    insertId: Optional. A unique ID for the log entry. If you provide this
      field, the logging service considers other log entries in the same log
      with the same ID as duplicates which can be removed.  If omitted,
      Stackdriver Logging will generate a unique ID for this log entry.
    internalId: A InternalEntityId attribute.
    jsonPayload: The log entry payload, represented as a structure that is
      expressed as a JSON object.
    labels: Optional. A set of user-defined (key, value) data that provides
      additional information about the log entry.
    logName: Required. The resource name of the log to which this log entry
      belongs. The format of the name is `"projects/<project-id>/logs/<log-
      id>"`.  Examples: `"projects/my-projectid/logs/syslog"`, `"projects/my-
      projectid/logs/library.googleapis.com%2Fbook_log"`.  The log ID part of
      resource name must be less than 512 characters long and can only include
      the following characters: upper and lower case alphanumeric characters:
      [A-Za-z0-9]; and punctuation characters: forward-slash, underscore,
      hyphen, and period. Forward-slash (`/`) characters in the log ID must be
      URL-encoded.
    operation: Optional. Information about an operation associated with the
      log entry, if applicable.
    protoPayload: The log entry payload, represented as a protocol buffer.
      Some Google Cloud Platform services use this field for their log entry
      payloads.
    resource: Required. The monitored resource associated with this log entry.
      Example: a log entry that reports a database error would be associated
      with the monitored resource designating the particular database that
      reported the error.
    severity: Optional. The severity of the log entry. The default value is
      `LogSeverity.DEFAULT`.
    textPayload: The log entry payload, represented as a Unicode string
      (UTF-8).
    timestamp: Optional. The time the event described by the log entry
      occurred.  If omitted, Stackdriver Logging will use the time the log
      entry is received.
    writerEmailAddress: A string attribute.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """Optional. The severity of the log entry. The default value is
    `LogSeverity.DEFAULT`.

    Values:
      DEFAULT: The log entry has no assigned severity level.
      DEBUG: Debug or trace information.
      INFO: Routine information, such as ongoing status or performance.
      NOTICE: Normal but significant events, such as start up, shut down, or
        configuration.
      WARNING: Warning events might cause problems.
      ERROR: Error events are likely to cause problems.
      CRITICAL: Critical events cause more severe problems or brief outages.
      ALERT: A person must take an action immediately.
      EMERGENCY: One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class JsonPayloadValue(_messages.Message):
    """The log entry payload, represented as a structure that is expressed as
    a JSON object.

    Messages:
      AdditionalProperty: An additional property for a JsonPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a JsonPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Optional. A set of user-defined (key, value) data that provides
    additional information about the log entry.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProtoPayloadValue(_messages.Message):
    """The log entry payload, represented as a protocol buffer.  Some Google
    Cloud Platform services use this field for their log entry payloads.

    Messages:
      AdditionalProperty: An additional property for a ProtoPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ProtoPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  httpRequest = _messages.MessageField('HttpRequest', 1)
  insertId = _messages.StringField(2)
  internalId = _messages.MessageField('InternalEntityId', 3)
  jsonPayload = _messages.MessageField('JsonPayloadValue', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  logName = _messages.StringField(6)
  operation = _messages.MessageField('LogEntryOperation', 7)
  protoPayload = _messages.MessageField('ProtoPayloadValue', 8)
  resource = _messages.MessageField('MonitoredResource', 9)
  severity = _messages.EnumField('SeverityValueValuesEnum', 10)
  textPayload = _messages.StringField(11)
  timestamp = _messages.StringField(12)
  writerEmailAddress = _messages.StringField(13)


class LogEntryOperation(_messages.Message):
  """Additional information about a potentially long-running operation with
  which a log entry is associated.

  Fields:
    first: Optional. Set this to True if this is the first log entry in the
      operation.
    id: Required. An arbitrary operation identifier. Log entries with the same
      identifier are assumed to be part of the same operation.
    last: Optional. Set this to True if this is the last log entry in the
      operation.
    producer: Required. An arbitrary producer identifier. The combination of
      `id` and `producer` must be globally unique.  Examples for `producer`:
      `"MyDivision.MyBigCompany.com"`, `"github.com/MyProject/MyApplication"`.
  """

  first = _messages.BooleanField(1)
  id = _messages.StringField(2)
  last = _messages.BooleanField(3)
  producer = _messages.StringField(4)


class LogError(_messages.Message):
  """Describes a problem with a logging resource or operation.

  Fields:
    resource: A resource name associated with this error. For example, the
      name of a Cloud Storage bucket that has insufficient permissions to be a
      destination for log entries.
    status: The error description, including a classification code, an error
      message, and other details.
    timeNanos: The time the error was observed, in nanoseconds since the Unix
      epoch.
  """

  resource = _messages.StringField(1)
  status = _messages.MessageField('Status', 2)
  timeNanos = _messages.IntegerField(3)


class LogLine(_messages.Message):
  """Application log line emitted while processing a request.

  Enums:
    SeverityValueValuesEnum: Severity of this log entry.

  Fields:
    logMessage: App-provided log message.
    severity: Severity of this log entry.
    sourceLocation: Where in the source code this log message was written.
    time: Approximate time when this log entry was made.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """Severity of this log entry.

    Values:
      DEFAULT: The log entry has no assigned severity level.
      DEBUG: Debug or trace information.
      INFO: Routine information, such as ongoing status or performance.
      NOTICE: Normal but significant events, such as start up, shut down, or
        configuration.
      WARNING: Warning events might cause problems.
      ERROR: Error events are likely to cause problems.
      CRITICAL: Critical events cause more severe problems or brief outages.
      ALERT: A person must take an action immediately.
      EMERGENCY: One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  logMessage = _messages.StringField(1)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)
  sourceLocation = _messages.MessageField('SourceLocation', 3)
  time = _messages.StringField(4)


class LogMetric(_messages.Message):
  """Describes a logs-based metric.  The value of the metric is the number of
  log entries that match a logs filter.

  Enums:
    VersionValueValuesEnum: The API version that created or updated this
      metric.

  Fields:
    description: A description of this metric, which is used in documentation.
    filter: An [advanced logs filter](/logging/docs/view/advanced_filters).
      Example: `"logName:syslog AND severity>=ERROR"`.
    name: Required. The client-assigned metric identifier. Example:
      `"severe_errors"`.  Metric identifiers are limited to 100 characters and
      can include only the following characters: `A-Z`, `a-z`, `0-9`, and the
      special characters `_-.,+!*',()%/`.  The forward-slash character (`/`)
      denotes a hierarchy of name pieces, and it cannot be the first character
      of the name.  The '%' character is used to URL encode unsafe and
      reserved characters and must be followed by two hexadecimal digits
      according to RFC 1738.
    version: The API version that created or updated this metric.
  """

  class VersionValueValuesEnum(_messages.Enum):
    """The API version that created or updated this metric.

    Values:
      V2: Cloud Logging API V2.
      V1: Cloud Logging API V1.
    """
    V2 = 0
    V1 = 1

  description = _messages.StringField(1)
  filter = _messages.StringField(2)
  name = _messages.StringField(3)
  version = _messages.EnumField('VersionValueValuesEnum', 4)


class LogSink(_messages.Message):
  """Describes a sink used to export log entries outside Stackdriver Logging.

  Enums:
    OutputVersionFormatValueValuesEnum: The log entry version to use for this
      sink's exported log entries. This version does not have to correspond to
      the version of the log entry when it was written to Stackdriver Logging.

  Fields:
    destination: The export destination. See [Exporting Logs With
      Sinks](/logging/docs/api/tasks/exporting-logs). Examples:
      `"storage.googleapis.com/a-bucket"`,
      `"bigquery.googleapis.com/projects/a-project-id/datasets/a-dataset"`.
    errors: _Output only._ All active errors found for this sink.
    filter: An [advanced logs filter](/logging/docs/view/advanced_filters).
      Only log entries matching that filter are exported. The filter must be
      consistent with the log entry format specified by the
      `outputVersionFormat` parameter, regardless of the format of the log
      entry that was originally written to Stackdriver Logging. Example (V2
      format): `"logName=projects/my-projectid/logs/syslog AND
      severity>=ERROR"`.
    formatChange: When the format was changed.
    name: Required. The client-assigned sink identifier. Example: `"my-severe-
      errors-to-pubsub"`. Sink identifiers are limited to 1000 characters and
      can include only the following characters: `A-Z`, `a-z`, `0-9`, and the
      special characters `_-.`. The maximum length of this value is 100
      characters.
    outputVersionFormat: The log entry version to use for this sink's exported
      log entries. This version does not have to correspond to the version of
      the log entry when it was written to Stackdriver Logging.
  """

  class OutputVersionFormatValueValuesEnum(_messages.Enum):
    """The log entry version to use for this sink's exported log entries. This
    version does not have to correspond to the version of the log entry when
    it was written to Stackdriver Logging.

    Values:
      VERSION_FORMAT_UNSPECIFIED: An unspecified version format will default
        to V2.
      V2: `LogEntry` version 2 format.
      V1: `LogEntry` version 1 format.
    """
    VERSION_FORMAT_UNSPECIFIED = 0
    V2 = 1
    V1 = 2

  destination = _messages.StringField(1)
  errors = _messages.MessageField('LogError', 2, repeated=True)
  filter = _messages.StringField(3)
  formatChange = _messages.StringField(4)
  name = _messages.StringField(5)
  outputVersionFormat = _messages.EnumField('OutputVersionFormatValueValuesEnum', 6)


class LoggingGetLogsUsageRequest(_messages.Message):
  """A LoggingGetLogsUsageRequest object.

  Enums:
    ResourceTierValueValuesEnum: Required. The Stackdriver tier to retrieve
      logs usage for.

  Fields:
    endTime: Optional. Exclusive. Retrieve logs usage before this timestamp.
      The request time period cannot be less than an hour, as that's the
      minimum data granularity we provide. If not provided, current time will
      be used as end_time.
    resourceName: Required. Resource to retrieve logs usage for. Examples are
      "projects/my-project-id", "organizations/google",
      "billingaccounts/ABC1234"
    resourceTier: Required. The Stackdriver tier to retrieve logs usage for.
    startTime: Required. Inclusive. Retrieve logs usage at or after this
      timestamp.
  """

  class ResourceTierValueValuesEnum(_messages.Enum):
    """Required. The Stackdriver tier to retrieve logs usage for.

    Values:
      TIER_UNSPECIFIED: <no description>
      FREE: <no description>
      PREMIUM: <no description>
    """
    TIER_UNSPECIFIED = 0
    FREE = 1
    PREMIUM = 2

  endTime = _messages.StringField(1)
  resourceName = _messages.StringField(2)
  resourceTier = _messages.EnumField('ResourceTierValueValuesEnum', 3)
  startTime = _messages.StringField(4)


class LoggingMonitoredResourceDescriptorsListRequest(_messages.Message):
  """A LoggingMonitoredResourceDescriptorsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. You must check for presence of `nextPageToken` to determine if
      additional results are available, which you can retrieve by passing the
      `nextPageToken` value as the `pageToken` parameter in the next request.
    pageToken: Optional. If the `pageToken` parameter is supplied, then the
      next page of results is retrieved.  The `pageToken` parameter must be
      set to the value of the `nextPageToken` from the previous response.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class LoggingProjectsLogsDeleteRequest(_messages.Message):
  """A LoggingProjectsLogsDeleteRequest object.

  Fields:
    logsId: Part of `logName`. See documentation of `projectsId`.
    projectsId: Part of `logName`. Required. The resource name of the log to
      delete.  Example: `"projects/my-project/logs/syslog"`.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsLogsListRequest(_messages.Message):
  """A LoggingProjectsLogsListRequest object.

  Fields:
    pageSize: The maximum number of results to return.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogs` operation.  If `pageToken` is supplied, then the other fields
      of this request are ignored, and instead the previous `ListLogs`
      operation is continued.
    projectsId: Part of `parent`. The resource name of the entity whose logs
      are requested. If both `resource_type` and `resourceIndexPrefix` are
      empty, then all logs with entries in this entity are listed.
    resourceIndexPrefix: The purpose of this field is to restrict the listed
      logs to those with entries of a certain kind. If `resource_type` is the
      name of a resource type, then this field may contain values for the log
      resource type's indexes. Only logs that have entries whose indexes
      include the values are listed. The format for this field is
      `"/val1/val2.../valN"`, where `val1` is a value for the first index,
      `val2` for the second index, etc. An empty value (a single slash) for an
      index matches all values, and you can omit values for later indexes
      entirely.
    resourceType: If not empty, this field must be a resource type such as
      `"gce_instance`. Only logs associated with that resource type are
      listed.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)
  resourceIndexPrefix = _messages.StringField(4)
  resourceType = _messages.StringField(5)


class LoggingProjectsMetricsCreateRequest(_messages.Message):
  """A LoggingProjectsMetricsCreateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    projectsId: Part of `parent`. The resource name of the project in which to
      create the metric. Example: `"projects/my-project-id"`.  The new metric
      must be provided in the request.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsDeleteRequest(_messages.Message):
  """A LoggingProjectsMetricsDeleteRequest object.

  Fields:
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the metric to
      delete. Example: `"projects/my-project-id/metrics/my-metric-id"`.
  """

  metricsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsGetRequest(_messages.Message):
  """A LoggingProjectsMetricsGetRequest object.

  Fields:
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the desired metric.
      Example: `"projects/my-project-id/metrics/my-metric-id"`.
  """

  metricsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsListRequest(_messages.Message):
  """A LoggingProjectsMetricsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. You must check for presence of `nextPageToken` to determine if
      additional results are available, which you can retrieve by passing the
      `nextPageToken` value as the `pageToken` parameter in the next request.
    pageToken: Optional. If the `pageToken` parameter is supplied, then the
      next page of results is retrieved.  The `pageToken` parameter must be
      set to the value of the `nextPageToken` from the previous response. The
      value of `parent` must be the same as in the previous request.
    projectsId: Part of `parent`. Required. The resource name containing the
      metrics. Example: `"projects/my-project-id"`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsMetricsUpdateRequest(_messages.Message):
  """A LoggingProjectsMetricsUpdateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the metric to
      update. Example: `"projects/my-project-id/metrics/my-metric-id"`.  The
      updated metric must be provided in the request and have the same
      identifier that is specified in `metricName`. If the metric does not
      exist, it is created.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  metricsId = _messages.StringField(2, required=True)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsResourceKeysListRequest(_messages.Message):
  """A LoggingProjectsResourceKeysListRequest object.

  Fields:
    pageSize: The maximum number of `ResourceKeys` objects to return in one
      operation.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListResourceKeys` operation.
    projectsId: Part of `parent`. The resource name of the entity whose
      reource keys are to be listed.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsResourceKeysValuesListRequest(_messages.Message):
  """A LoggingProjectsResourceKeysValuesListRequest object.

  Fields:
    depth: A non-negative integer that limits the number of levels of the
      index hierarchy that are returned. If `depth` is 1 (default), only the
      first index key value is returned. If `depth` is 2, both primary and
      secondary key values are returned. If `depth` is 0, the depth is the
      number of slash-separators in the `indexPrefix` field, not counting a
      slash appearing as the last character of the prefix. If the
      `indexPrefix` field is empty, the default depth is 1. It is an error for
      `depth` to be any positive value less than the number of components in
      `indexPrefix`.
    indexPrefix: Restricts the index values returned to be those with a
      specified prefix for each index key. This field has the form
      `"/prefix1/prefix2/..."`, in order corresponding to the `ResourceKeys
      indexKeys`. Non-empty prefixes must begin with `/`. For example, App
      Engine's two keys are the module ID and the version ID. Following is the
      effect of using various values for `indexPrefix`:  +  `"/Mod/"`
      retrieves `/Mod/10` and `/Mod/11` but not `/ModA/10`. +  `"/Mod`
      retrieves `/Mod/10`, `/Mod/11` and `/ModA/10` but not `/XXX/33`. +
      `"/Mod/1"` retrieves `/Mod/10` and `/Mod/11` but not `/ModA/10`. +
      `"/Mod/10/"` retrieves `/Mod/10` only. +  An empty prefix or `"/"`
      retrieves all values.
    pageSize: The maximum number of log resource index resources to return in
      one operation.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListResourceValues` operation.
    projectsId: Part of `resourceTypeName`. The resource name of a resource
      type whose indexes are requested. Example: `"projects/my-project-
      id/resourceTypes/gae_app"`.
    resourceKeysId: Part of `resourceTypeName`. See documentation of
      `projectsId`.
  """

  depth = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  indexPrefix = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectsId = _messages.StringField(5, required=True)
  resourceKeysId = _messages.StringField(6, required=True)


class LoggingProjectsSinksCreateRequest(_messages.Message):
  """A LoggingProjectsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `parent`. The resource in which to create the sink.
      Example: `"projects/my-project-id"`.  The new sink must be provided in
      the request.
  """

  logSink = _messages.MessageField('LogSink', 1)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsSinksDeleteRequest(_messages.Message):
  """A LoggingProjectsSinksDeleteRequest object.

  Fields:
    projectsId: Part of `sinkName`. The resource name of the sink to delete.
      Example: `"projects/my-project-id/sinks/my-sink-id"`.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  projectsId = _messages.StringField(1, required=True)
  sinksId = _messages.StringField(2, required=True)


class LoggingProjectsSinksGetRequest(_messages.Message):
  """A LoggingProjectsSinksGetRequest object.

  Fields:
    projectsId: Part of `sinkName`. The resource name of the sink to return.
      Example: `"projects/my-project-id/sinks/my-sink-id"`.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  projectsId = _messages.StringField(1, required=True)
  sinksId = _messages.StringField(2, required=True)


class LoggingProjectsSinksListRequest(_messages.Message):
  """A LoggingProjectsSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. You must check for presence of `nextPageToken` to determine if
      additional results are available, which you can retrieve by passing the
      `nextPageToken` value as the `pageToken` parameter in the next request.
    pageToken: Optional. If the `pageToken` parameter is supplied, then the
      next page of results is retrieved.  The `pageToken` parameter must be
      set to the value of the `nextPageToken` from the previous response. The
      value of `parent` must be the same as in the previous request.
    projectsId: Part of `parent`. Required. The resource name containing the
      sinks. Example: `"projects/my-logging-project"`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsSinksUpdateRequest(_messages.Message):
  """A LoggingProjectsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `sinkName`. The resource name of the sink to update.
      Example: `"projects/my-project-id/sinks/my-sink-id"`.  The updated sink
      must be provided in the request and have the same name that is specified
      in `sinkName`.  If the sink does not exist, it is created.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logSink = _messages.MessageField('LogSink', 1)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class MonitoredResource(_messages.Message):
  """An object representing a resource that can be used for monitoring,
  logging, billing, or other purposes. Examples include virtual machine
  instances, databases, and storage devices such as disks. The `type` field
  identifies a MonitoredResourceDescriptor object that describes the
  resource's schema. Information in the `labels` field identifies the actual
  resource and its attributes according to the schema. For example, a
  particular Compute Engine VM instance could be represented by the following
  object, because the MonitoredResourceDescriptor for `"gce_instance"` has
  labels `"instance_id"` and `"zone"`:      { "type": "gce_instance",
  "labels": { "instance_id": "12345678901234",                   "zone": "us-
  central1-a" }}

  Messages:
    LabelsValue: Required. Values for all of the labels listed in the
      associated monitored resource descriptor. For example, Cloud SQL
      databases use the labels `"database_id"` and `"zone"`.

  Fields:
    labels: Required. Values for all of the labels listed in the associated
      monitored resource descriptor. For example, Cloud SQL databases use the
      labels `"database_id"` and `"zone"`.
    type: Required. The monitored resource type. This field must match the
      `type` field of a MonitoredResourceDescriptor object. For example, the
      type of a Cloud SQL database is `"cloudsql_database"`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Required. Values for all of the labels listed in the associated
    monitored resource descriptor. For example, Cloud SQL databases use the
    labels `"database_id"` and `"zone"`.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  type = _messages.StringField(2)


class MonitoredResourceDescriptor(_messages.Message):
  """An object that describes the schema of a MonitoredResource object using a
  type name and a set of labels.  For example, the monitored resource
  descriptor for Google Compute Engine VM instances has a type of
  `"gce_instance"` and specifies the use of the labels `"instance_id"` and
  `"zone"` to identify particular VM instances.  Different APIs can support
  different monitored resource types. APIs generally provide a `list` method
  that returns the monitored resource descriptors used by the API.

  Fields:
    description: Optional. A detailed description of the monitored resource
      type that might be used in documentation.
    displayName: Optional. A concise name for the monitored resource type that
      might be displayed in user interfaces. For example, `"Google Cloud SQL
      Database"`.
    labels: Required. A set of labels used to describe instances of this
      monitored resource type. For example, an individual Google Cloud SQL
      database is identified by values for the labels `"database_id"` and
      `"zone"`.
    name: Optional. The resource name of the monitored resource descriptor:
      `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
      {type} is the value of the `type` field in this object and {project_id}
      is a project ID that provides API-specific context for accessing the
      type.  APIs that do not use project information can use the resource
      name format `"monitoredResourceDescriptors/{type}"`.
    type: Required. The monitored resource type. For example, the type
      `"cloudsql_database"` represents databases in Google Cloud SQL. The
      maximum length of this value is 256 characters.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)
  type = _messages.StringField(5)


class ReadLogEntriesRequest(_messages.Message):
  """The parameters to `ReadLogEntries`. There are two different use cases for
  streaming:  1.  To return a very large result set. The request eventually
  completes when all entries have been returned. 2.  To "tail" a log stream,
  returning new entries as they arrive.     In this case, the request never
  completes.  Only the first use case is supported.

  Fields:
    batchSize: Optional. The number of LogEntrys to return in each streamed
      response. If unspecified, the default will be 10.
    filter: Optional. An [advanced logs
      filter](/logging/docs/view/advanced_filters). The response includes only
      entries that match the filter. If `filter` is empty, then all entries in
      all logs are retrieved.
    maxResponseInterval: Optional. The maximum time between successive
      streamed responses. A response will be sent every max_response_interval
      even if page_size entries have not yet been accumulated provided that
      either some entries have been accumulated OR the
      last_observed_entry_timestamp / resume_token has changed. (i.e. a
      response containg 0 entries is allowed) If unspecified, the default will
      be 1 second.
    orderBy: Optional. How the results should be sorted.  Presently, the only
      permitted values are `"timestamp asc"` (default) and `"timestamp desc"`.
      The first option returns entries in order of increasing values of
      `LogEntry.timestamp` (oldest first), and the second option returns
      entries in order of decreasing timestamps (newest first).  Entries with
      equal timestamps will be returned in order of `LogEntry.insertId`.
    projectIds: Required. A list of project ids from which to retrieve log
      entries. Example: `"my-project-id"`.
    resumeToken: Optional. If the `resumeToken` parameter is supplied, then
      the next batch of results is retrieved. The `resumeToken` parameter must
      be set to the value from the previous response.
  """

  batchSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  filter = _messages.StringField(2)
  maxResponseInterval = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  projectIds = _messages.StringField(5, repeated=True)
  resumeToken = _messages.StringField(6)


class ReadLogEntriesResponse(_messages.Message):
  """Result returned from `ReadLogEntries`.

  Fields:
    entries: A list of log entries - may be empty.
    lastObservedEntryTimestamp: The timestamp of the last log entry that was
      examined before returning this response. This can be used to observe
      progress between successive queries, in particular when only a resume
      token is returned.
    resumeToken: A token to use to resume from this position of the stream.
      Note that even if there are no entries, it might still be possible to
      continue from this point at some later time.
  """

  entries = _messages.MessageField('LogEntry', 1, repeated=True)
  lastObservedEntryTimestamp = _messages.StringField(2)
  resumeToken = _messages.StringField(3)


class RequestLog(_messages.Message):
  """Complete log information about a single HTTP request to an App Engine
  application.

  Fields:
    appEngineRelease: App Engine release version.
    appId: Application that handled this request.
    cost: An indication of the relative cost of serving this request.
    endTime: Time when the request finished.
    finished: Whether this request is finished or active.
    first: Whether this is the first RequestLog entry for this request.  If an
      active request has several RequestLog entries written to Cloud Logging,
      this field will be set for one of them.
    host: Internet host and port number of the resource being requested.
    httpVersion: HTTP version of request. Example: `"HTTP/1.1"`.
    instanceId: An identifier for the instance that handled the request.
    instanceIndex: If the instance processing this request belongs to a
      manually scaled module, then this is the 0-based index of the instance.
      Otherwise, this value is -1.
    ip: Origin IP address.
    latency: Latency of the request.
    line: A list of log lines emitted by the application while serving this
      request.
    megaCycles: Number of CPU megacycles used to process request.
    method: Request method. Example: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`,
      `"DELETE"`.
    moduleId: Module of the application that handled this request.
    nickname: The logged-in user who made the request.  Most likely, this is
      the part of the user's email before the `@` sign.  The field value is
      the same for different requests from the same user, but different users
      can have similar names.  This information is also available to the
      application via the App Engine Users API.  This field will be populated
      starting with App Engine 1.9.21.
    pendingTime: Time this request spent in the pending request queue.
    referrer: Referrer URL of request.
    requestId: Globally unique identifier for a request, which is based on the
      request start time.  Request IDs for requests which started later will
      compare greater as strings than those for requests which started
      earlier.
    resource: Contains the path and query portion of the URL that was
      requested. For example, if the URL was
      "http://example.com/app?name=val", the resource would be
      "/app?name=val".  The fragment identifier, which is identified by the
      `#` character, is not included.
    responseSize: Size in bytes sent back to client by request.
    sourceReference: Source code for the application that handled this
      request. There can be more than one source reference per deployed
      application if source code is distributed among multiple repositories.
    startTime: Time when the request started.
    status: HTTP response status code. Example: 200, 404.
    taskName: Task name of the request, in the case of an offline request.
    taskQueueName: Queue name of the request, in the case of an offline
      request.
    traceId: Cloud Trace identifier for this request.
    urlMapEntry: File or class that handled the request.
    userAgent: User agent that made the request.
    versionId: Version of the application that handled this request.
    wasLoadingRequest: Whether this was a loading request for the instance.
  """

  appEngineRelease = _messages.StringField(1)
  appId = _messages.StringField(2)
  cost = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  finished = _messages.BooleanField(5)
  first = _messages.BooleanField(6)
  host = _messages.StringField(7)
  httpVersion = _messages.StringField(8)
  instanceId = _messages.StringField(9)
  instanceIndex = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  ip = _messages.StringField(11)
  latency = _messages.StringField(12)
  line = _messages.MessageField('LogLine', 13, repeated=True)
  megaCycles = _messages.IntegerField(14)
  method = _messages.StringField(15)
  moduleId = _messages.StringField(16)
  nickname = _messages.StringField(17)
  pendingTime = _messages.StringField(18)
  referrer = _messages.StringField(19)
  requestId = _messages.StringField(20)
  resource = _messages.StringField(21)
  responseSize = _messages.IntegerField(22)
  sourceReference = _messages.MessageField('SourceReference', 23, repeated=True)
  startTime = _messages.StringField(24)
  status = _messages.IntegerField(25, variant=_messages.Variant.INT32)
  taskName = _messages.StringField(26)
  taskQueueName = _messages.StringField(27)
  traceId = _messages.StringField(28)
  urlMapEntry = _messages.StringField(29)
  userAgent = _messages.StringField(30)
  versionId = _messages.StringField(31)
  wasLoadingRequest = _messages.BooleanField(32)


class ResourceKeys(_messages.Message):
  """_Output only._ Describes resource keys for log entries.

  Fields:
    displayName: Displayable name for this type that can be presented in a UI.
    keys: A list of the names of the keys used to index and label individual
      log entries associated with this resource type.      [ "module_id",
      "version_id" ]
    type: The type of the resource - e.g. "gce_instance" This value can appear
      in the `LogEntry.resource.type` field of log entries
  """

  displayName = _messages.StringField(1)
  keys = _messages.StringField(2, repeated=True)
  type = _messages.StringField(3)


class SourceLocation(_messages.Message):
  """Specifies a location in a source code file.

  Fields:
    file: Source file name. Depending on the runtime environment, this might
      be a simple name or a fully-qualified name.
    functionName: Human-readable name of the function or method being invoked,
      with optional context such as the class or package name. This
      information is used in contexts such as the logs viewer, where a file
      and line number are less meaningful. The format can vary by language.
      For example: `qual.if.ied.Class.method` (Java), `dir/package.func` (Go),
      `function` (Python).
    line: Line within the source file.
  """

  file = _messages.StringField(1)
  functionName = _messages.StringField(2)
  line = _messages.IntegerField(3)


class SourceReference(_messages.Message):
  """A reference to a particular snapshot of the source tree used to build and
  deploy an application.

  Fields:
    repository: Optional. A URI string identifying the repository. Example:
      "https://github.com/GoogleCloudPlatform/kubernetes.git"
    revisionId: The canonical and persistent identifier of the deployed
      revision. Example (git): "0035781c50ec7aa23385dc841529ce8a4b70db1b"
  """

  repository = _messages.StringField(1)
  revisionId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Usage(_messages.Message):
  """Describes logs usage over a period of time.

  Fields:
    byteCount: The volume of ingested logs, in bytes.
    byteQuota: The allowed free quota, also in bytes. Note that the quota for
      Free Tier is monthly, while for Premium Tier, it's calculated hourly.
    endTime: Exclusive. End time of the usage interval.
    startTime: Inclusive. Start time of the usage interval.
  """

  byteCount = _messages.IntegerField(1)
  byteQuota = _messages.IntegerField(2)
  endTime = _messages.StringField(3)
  startTime = _messages.StringField(4)


class WriteLogEntriesRequest(_messages.Message):
  """The parameters to WriteLogEntries.

  Messages:
    LabelsValue: Optional. User-defined `key:value` items that are added to
      the `labels` field of each log entry in `entries`, except when a log
      entry specifies its own `key:value` item with the same key. Example: `{
      "size": "large", "color":"red" }`

  Fields:
    entries: Required. The log entries to write. The log entries must have
      values for all required fields.  To improve throughput and to avoid
      exceeding the [quota limit](/logging/quota-policy) for calls to
      `entries.write`, use this field to write multiple log entries at once
      rather than calling this method for each log entry.
    labels: Optional. User-defined `key:value` items that are added to the
      `labels` field of each log entry in `entries`, except when a log entry
      specifies its own `key:value` item with the same key. Example: `{
      "size": "large", "color":"red" }`
    logName: Optional. A default log resource name for those log entries in
      `entries` that do not specify their own `logName`.  Example: `"projects
      /my-project/logs/syslog"`.  See LogEntry.
    partialSuccess: Optional. Whether valid entries should be written even if
      some other entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED
      errors. If any entry is not written, the response status will be the
      error associated with one of the failed entries and include error
      details in the form of WriteLogEntriesPartialErrors.
    resource: Optional. A default monitored resource for those log entries in
      `entries` that do not specify their own `resource`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Optional. User-defined `key:value` items that are added to the `labels`
    field of each log entry in `entries`, except when a log entry specifies
    its own `key:value` item with the same key. Example: `{ "size": "large",
    "color":"red" }`

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entries = _messages.MessageField('LogEntry', 1, repeated=True)
  labels = _messages.MessageField('LabelsValue', 2)
  logName = _messages.StringField(3)
  partialSuccess = _messages.BooleanField(4)
  resource = _messages.MessageField('MonitoredResource', 5)


class WriteLogEntriesResponse(_messages.Message):
  """Result returned from WriteLogEntries.
empty"""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'logging')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'logging')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'logging')
