/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.Record;

final class TaskModel {
    private ProjectFile m_parentFile;
    private boolean[] m_flags = new boolean[153];
    private int[] m_fields = new int[154];
    private int m_count;
    private String[] m_taskNames;
    private HashMap<String, Integer> m_taskNumbers = new HashMap();

    TaskModel(ProjectFile projectFile, Locale locale) {
        this.m_parentFile = projectFile;
        this.setLocale(locale);
    }

    void setLocale(Locale locale) {
        this.m_taskNames = LocaleData.getStringArray(locale, "TASK_NAMES");
        this.m_taskNumbers.clear();
        for (int i = 0; i < this.m_taskNames.length; ++i) {
            String string = this.m_taskNames[i];
            if (string == null) continue;
            this.m_taskNumbers.put(string, i);
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    public void update(Record record, boolean bl) throws MPXJException {
        int n = record.getLength();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.add(this.getTaskCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    private void add(int n) {
        if (n < this.m_flags.length && !this.m_flags[n]) {
            this.m_flags[n] = true;
            this.m_fields[this.m_count] = n;
            ++this.m_count;
        }
    }

    private void populateModel() {
        if (this.m_count != 0) {
            this.m_count = 0;
            Arrays.fill(this.m_flags, false);
        }
        for (Task task : this.m_parentFile.getAllTasks()) {
            for (int i = 0; i < 153; ++i) {
                if (task.getCachedValue(MPXTaskField.getMpxjField(i)) == null || this.m_flags[i]) continue;
                this.m_flags[i] = true;
                this.m_fields[this.m_count] = i;
                ++this.m_count;
            }
        }
        Arrays.sort(this.m_fields);
        System.arraycopy(this.m_fields, this.m_fields.length - this.m_count, this.m_fields, 0, this.m_count);
    }

    public String toString() {
        this.populateModel();
        char c = this.m_parentFile.getProjectProperties().getMpxDelimiter();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append(60);
        stringBuilder2.append(61);
        for (int i = 0; i < this.m_count; ++i) {
            int n = this.m_fields[i];
            stringBuilder.append(c);
            stringBuilder2.append(c);
            stringBuilder.append(this.getTaskField(n));
            stringBuilder2.append(n);
        }
        stringBuilder.append("\r\n");
        stringBuilder2.append("\r\n");
        stringBuilder.append(stringBuilder2.toString());
        return stringBuilder.toString();
    }

    private String getTaskField(int n) {
        String string = null;
        if (n > 0 && n < this.m_taskNames.length) {
            string = this.m_taskNames[n];
        }
        return string;
    }

    private int getTaskCode(String string) throws MPXJException {
        Integer n = this.m_taskNumbers.get(string.trim());
        if (n == null) {
            throw new MPXJException("Invalid task field name " + string);
        }
        return n;
    }
}

