/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.TableDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileRow
extends MapRow {
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = new ThreadLocal();
    private static final long JAVA_EPOCH = -2208988800000L;
    private static final long ASTA_EPOCH = 2415021L;

    public FileRow(TableDefinition tableDefinition, List<String> list) throws MPXJException {
        super(new HashMap<String, Object>());
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        for (int i = 0; i < columnDefinitionArray.length; ++i) {
            ColumnDefinition columnDefinition = columnDefinitionArray[i];
            if (i >= list.size()) continue;
            this.m_map.put(columnDefinition.getName(), this.getColumnValue(tableDefinition.getName(), columnDefinition.getName(), list.get(i), columnDefinition.getType()));
        }
    }

    private Object getColumnValue(String string, String string2, String string3, int n) throws MPXJException {
        try {
            Object object = null;
            switch (n) {
                case -7: {
                    object = this.parseBoolean(string3);
                    break;
                }
                case -1: 
                case 12: {
                    object = this.parseString(string3);
                    break;
                }
                case 93: {
                    object = this.parseTimestamp(string3);
                    break;
                }
                case 8: {
                    object = this.parseDouble(string3);
                    break;
                }
                case 4: {
                    object = this.parseInteger(string3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + n);
                }
            }
            return object;
        }
        catch (Exception exception) {
            throw new MPXJException("Failed to parse " + string + "." + string2 + " (data=" + string3 + ", type=" + n + ")");
        }
    }

    private Boolean parseBoolean(String string) throws ParseException {
        Boolean bl = null;
        Integer n = this.parseInteger(string);
        if (n != null) {
            bl = n == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl;
    }

    private Integer parseInteger(String string) throws ParseException {
        Integer n = null;
        if (string.length() > 0 && string.indexOf(32) == -1) {
            if (string.indexOf(46) == -1) {
                n = Integer.valueOf(string);
            } else {
                Number number = this.parseDouble(string);
                n = number.intValue();
            }
        }
        return n;
    }

    private String parseString(String string) {
        if (string != null) {
            if (!string.isEmpty() && string.charAt(0) == '<') {
                string = string.substring(1, string.length() - 1);
            }
            if (!string.isEmpty() && string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    private Number parseDouble(String string) throws ParseException {
        Number number = null;
        if ((string = this.parseString(string)) != null && !string.isEmpty() && !string.equals("-1 -1")) {
            int n = string.indexOf("E+");
            if (n != -1) {
                string = string.substring(0, n) + 'E' + string.substring(n + 2, string.length());
            }
            if (string.indexOf(69) != -1) {
                DecimalFormat decimalFormat = DOUBLE_FORMAT.get();
                if (decimalFormat == null) {
                    decimalFormat = new DecimalFormat("#.#E0");
                    DOUBLE_FORMAT.set(decimalFormat);
                }
                number = decimalFormat.parse(string);
            } else {
                number = Double.valueOf(string);
            }
        }
        return number;
    }

    private Date parseTimestamp(String string) {
        Date date = null;
        if (string.length() > 0 && !string.equals("-1 -1")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(-2208988800000L);
            int n = string.indexOf(32);
            if (n == -1) {
                if (string.length() < 6) {
                    string = "000000" + string;
                    string = string.substring(string.length() - 6);
                }
                int n2 = Integer.parseInt(string.substring(0, 2));
                int n3 = Integer.parseInt(string.substring(2, 4));
                int n4 = Integer.parseInt(string.substring(4));
                calendar.set(10, n2);
                calendar.set(12, n3);
                calendar.set(13, n4);
            } else {
                long l = Long.parseLong(string.substring(0, n));
                int n5 = Integer.parseInt(string.substring(n + 1));
                calendar.add(6, (int)(l - 2415021L));
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(10, 0);
                calendar.add(13, n5);
            }
            date = calendar.getTime();
        }
        return date;
    }
}

