/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.common.DateHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendarException
extends ProjectCalendarDateRanges
implements Comparable<ProjectCalendarException> {
    private Date m_fromDate;
    private Date m_toDate;

    ProjectCalendarException(Date date, Date date2) {
        this.m_fromDate = DateHelper.getDayStartDate(date);
        this.m_toDate = DateHelper.getDayEndDate(date2);
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public boolean getWorking() {
        return this.getRangeCount() != 0;
    }

    public boolean contains(Date date) {
        boolean bl = false;
        if (date != null) {
            bl = DateHelper.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return bl;
    }

    @Override
    public int compareTo(ProjectCalendarException projectCalendarException) {
        long l;
        long l2 = this.m_fromDate.getTime();
        return l2 < (l = projectCalendarException.m_fromDate.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ProjectCalendarException");
        stringBuilder.append(" working=" + this.getWorking());
        stringBuilder.append(" fromDate=" + this.m_fromDate);
        stringBuilder.append(" toDate=" + this.m_toDate);
        for (DateRange dateRange : this) {
            stringBuilder.append(dateRange.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

