/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendar
extends ProjectCalendarWeek
implements ProjectEntityWithUniqueID {
    private ProjectFile m_projectFile;
    private Integer m_uniqueID = 0;
    private List<ProjectCalendarException> m_exceptions = new LinkedList<ProjectCalendarException>();
    private boolean m_exceptionsSorted;
    private Resource m_resource;
    private ArrayList<ProjectCalendar> m_derivedCalendars = new ArrayList();
    private Map<DateRange, Long> m_workingDateCache = new WeakHashMap<DateRange, Long>();
    private Map<Date, Date> m_startTimeCache = new WeakHashMap<Date, Date>();
    private ArrayList<ProjectCalendarWeek> m_workWeeks = new ArrayList();
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    private static final int MAX_NONWORKING_DAYS = 1000;

    public ProjectCalendar(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
        if (projectFile.getProjectConfig().getAutoCalendarUniqueID()) {
            this.setUniqueID(projectFile.getProjectConfig().getNextCalendarUniqueID());
        }
    }

    public ProjectCalendarWeek addWorkWeek() {
        ProjectCalendarWeek projectCalendarWeek = new ProjectCalendarWeek();
        projectCalendarWeek.setParent(this);
        this.m_workWeeks.add(projectCalendarWeek);
        return projectCalendarWeek;
    }

    public List<ProjectCalendarWeek> getWorkWeeks() {
        return this.m_workWeeks;
    }

    public ProjectCalendarException addCalendarException(Date date, Date date2) {
        ProjectCalendarException projectCalendarException = new ProjectCalendarException(date, date2);
        this.m_exceptions.add(projectCalendarException);
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
        return projectCalendarException;
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        if (!this.m_exceptionsSorted) {
            Collections.sort(this.m_exceptions);
        }
        return this.m_exceptions;
    }

    @Override
    public ProjectCalendarHours addCalendarHours(Day day) {
        this.clearWorkingDateCache();
        return super.addCalendarHours(day);
    }

    @Override
    public void attachHoursToDay(ProjectCalendarHours projectCalendarHours) {
        this.clearWorkingDateCache();
        super.attachHoursToDay(projectCalendarHours);
    }

    @Override
    public void removeHoursFromDay(ProjectCalendarHours projectCalendarHours) {
        this.clearWorkingDateCache();
        super.removeHoursFromDay(projectCalendarHours);
    }

    public void setParent(ProjectCalendar projectCalendar) {
        if (this.getParent() != null) {
            this.getParent().removeDerivedCalendar(this);
        }
        super.setParent(projectCalendar);
        if (projectCalendar != null) {
            projectCalendar.addDerivedCalendar(this);
        }
        this.clearWorkingDateCache();
    }

    @Override
    public ProjectCalendar getParent() {
        return (ProjectCalendar)super.getParent();
    }

    public boolean isWorkingDay(Day day) {
        ProjectCalendar projectCalendar;
        DayType dayType = this.getWorkingDay(day);
        boolean bl = dayType == DayType.DEFAULT ? ((projectCalendar = this.getParent()) != null ? projectCalendar.isWorkingDay(day) : day != Day.SATURDAY && day != Day.SUNDAY) : dayType == DayType.WORKING;
        return bl;
    }

    public Duration getDuration(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = this.getDaysInRange(date, date2);
        int n2 = 0;
        Day day = Day.getInstance(calendar.get(7));
        while (n > 0) {
            if (this.isWorkingDate(calendar.getTime(), day)) {
                ++n2;
            }
            --n;
            day = day.getNextDay();
            calendar.set(6, calendar.get(6) + 1);
        }
        return Duration.getInstance(n2, TimeUnit.DAYS);
    }

    public Date getStartTime(Date date) {
        Date date2 = this.m_startTimeCache.get(date);
        if (date2 == null) {
            ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, null, null);
            date2 = projectCalendarDateRanges == null ? this.getParentFile().getProjectProperties().getDefaultStartTime() : projectCalendarDateRanges.getRange(0).getStart();
            date2 = DateHelper.getCanonicalTime(date2);
            this.m_startTimeCache.put(new Date(date.getTime()), date2);
        }
        return date2;
    }

    public Date getFinishTime(Date date) {
        Date date2 = null;
        if (date != null) {
            ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, null, null);
            if (projectCalendarDateRanges == null) {
                date2 = this.getParentFile().getProjectProperties().getDefaultEndTime();
                date2 = DateHelper.getCanonicalTime(date2);
            } else {
                Date date3 = date2 = projectCalendarDateRanges.getRange(0).getStart();
                Date date4 = projectCalendarDateRanges.getRange(projectCalendarDateRanges.getRangeCount() - 1).getEnd();
                Date date5 = DateHelper.getDayStartDate(date3);
                Date date6 = DateHelper.getDayStartDate(date4);
                date2 = DateHelper.getCanonicalTime(date4);
                if (date5 != null && date6 != null && date5.getTime() != date6.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date2);
                    calendar.add(6, 1);
                    date2 = calendar.getTime();
                }
            }
        }
        return date2;
    }

    public Date getDate(Date date, Duration duration, boolean bl) {
        ProjectProperties projectProperties = this.getParentFile().getProjectProperties();
        double d = NumberHelper.truncate(duration.convertUnits(TimeUnit.MINUTES, projectProperties).getDuration(), 2.0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        while (d > 0.0) {
            Date date2;
            Object object;
            Date date3 = calendar.getTime();
            calendar2.setTime(date3);
            calendar2.add(6, 1);
            Date date4 = DateHelper.getDayStartDate(calendar2.getTime());
            double d2 = this.getWork(date3, date4, TimeUnit.MINUTES).getDuration();
            if (d > d2) {
                d = NumberHelper.truncate(d - d2, 2.0);
                int n = 0;
                do {
                    calendar.add(6, 1);
                    object = Day.getInstance(calendar.get(7));
                    if (++n <= 1000) continue;
                    calendar.setTime(date);
                    calendar.add(6, 1);
                    d = 0.0;
                    break;
                } while (!this.isWorkingDate(calendar.getTime(), (Day)object));
                date2 = this.getStartTime(calendar.getTime());
                DateHelper.setTime(calendar, date2);
                continue;
            }
            object = this.getRanges(calendar.getTime(), calendar, null);
            Date date5 = null;
            date2 = DateHelper.getCanonicalTime(date3);
            boolean bl2 = true;
            Iterator<DateRange> iterator = ((ProjectCalendarDateRanges)object).iterator();
            while (iterator.hasNext()) {
                DateRange dateRange = iterator.next();
                Date date6 = dateRange.getStart();
                Date date7 = dateRange.getEnd();
                if (date6 == null || date7 == null) continue;
                Date date8 = DateHelper.getCanonicalTime(date7);
                Date date9 = DateHelper.getCanonicalTime(date6);
                Date date10 = DateHelper.getDayStartDate(date6);
                Date date11 = DateHelper.getDayStartDate(date7);
                if (date10.getTime() != date11.getTime()) {
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.setTime(date8);
                    calendar3.add(6, 1);
                    date8 = calendar3.getTime();
                }
                if (bl2 && date8.getTime() < date2.getTime()) continue;
                if (bl2 && date9.getTime() < date2.getTime()) {
                    date9 = date2;
                }
                bl2 = false;
                double d3 = date8.getTime() - date9.getTime();
                if (d > (d3 /= 60000.0)) {
                    d = NumberHelper.truncate(d - d3, 2.0);
                    continue;
                }
                if (Duration.durationValueEquals(d, d3)) {
                    date5 = date8;
                    if (date10.getTime() != date11.getTime()) {
                        calendar.add(6, 1);
                    }
                } else {
                    date5 = new Date((long)((double)date9.getTime() + d * 60000.0));
                    bl = false;
                }
                d = 0.0;
                break;
            }
            DateHelper.setTime(calendar, date5);
        }
        if (bl) {
            this.updateToNextWorkStart(calendar);
        }
        return calendar.getTime();
    }

    public Date getStartDate(Date date, Duration duration) {
        ProjectProperties projectProperties = this.getParentFile().getProjectProperties();
        double d = NumberHelper.truncate(duration.convertUnits(TimeUnit.MINUTES, projectProperties).getDuration(), 2.0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        while (d > 0.0) {
            Date date2;
            Object object;
            Date date3 = calendar.getTime();
            calendar2.setTime(date3);
            calendar2.add(6, -1);
            Date date4 = DateHelper.getDayEndDate(calendar2.getTime());
            double d2 = this.getWork(date4, date3, TimeUnit.MINUTES).getDuration();
            if (d > d2) {
                int n;
                d = NumberHelper.truncate(d - d2, 2.0);
                for (n = 0; n <= 7; ++n) {
                    calendar.add(6, -1);
                    object = Day.getInstance(calendar.get(7));
                    if (!this.isWorkingDate(calendar.getTime(), (Day)object)) continue;
                }
                if (n > 7) {
                    return null;
                }
                date2 = this.getFinishTime(calendar.getTime());
                DateHelper.setTime(calendar, date2);
                continue;
            }
            ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(calendar.getTime(), calendar, null);
            object = null;
            date2 = DateHelper.getCanonicalTime(date3);
            boolean bl = true;
            for (int i = projectCalendarDateRanges.getRangeCount() - 1; i >= 0; --i) {
                DateRange dateRange = projectCalendarDateRanges.getRange(i);
                Date date5 = dateRange.getStart();
                Date date6 = dateRange.getEnd();
                if (date5 == null || date6 == null) continue;
                Date date7 = DateHelper.getCanonicalTime(date6);
                Date date8 = DateHelper.getCanonicalTime(date5);
                Date date9 = DateHelper.getDayStartDate(date5);
                Date date10 = DateHelper.getDayStartDate(date6);
                if (date9.getTime() != date10.getTime()) {
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.setTime(date7);
                    calendar3.add(6, 1);
                    date7 = calendar3.getTime();
                }
                if (bl && date8.getTime() > date2.getTime()) continue;
                if (bl && date7.getTime() > date2.getTime()) {
                    date7 = date2;
                }
                bl = false;
                double d3 = date7.getTime() - date8.getTime();
                if (d > (d3 /= 60000.0)) {
                    d = NumberHelper.truncate(d - d3, 2.0);
                    continue;
                }
                object = Duration.durationValueEquals(d, d3) ? date8 : new Date((long)((double)date7.getTime() - d * 60000.0));
                d = 0.0;
                break;
            }
            DateHelper.setTime(calendar, (Date)object);
        }
        return calendar.getTime();
    }

    private void updateToNextWorkStart(Calendar calendar) {
        Date date = calendar.getTime();
        ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, calendar, null);
        if (projectCalendarDateRanges != null) {
            Date date2 = DateHelper.getCanonicalTime(calendar.getTime());
            Date date3 = null;
            for (DateRange dateRange : projectCalendarDateRanges) {
                Date date4 = DateHelper.getCanonicalTime(dateRange.getStart());
                Date date5 = DateHelper.getCanonicalTime(dateRange.getEnd());
                Date date6 = DateHelper.getDayStartDate(dateRange.getStart());
                Date date7 = DateHelper.getDayStartDate(dateRange.getEnd());
                if (date6.getTime() != date7.getTime()) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(date5);
                    calendar2.add(6, 1);
                    date5 = calendar2.getTime();
                }
                if (date2.getTime() >= date5.getTime()) continue;
                if (date2.getTime() > date4.getTime()) {
                    date3 = date2;
                    break;
                }
                date3 = date4;
                break;
            }
            if (date3 == null) {
                Day day;
                int n = 0;
                do {
                    calendar.set(6, calendar.get(6) + 1);
                    day = Day.getInstance(calendar.get(7));
                    if (++n <= 1000) continue;
                    calendar.setTime(date);
                    break;
                } while (!this.isWorkingDate(calendar.getTime(), day));
                date3 = this.getStartTime(calendar.getTime());
            }
            DateHelper.setTime(calendar, date3);
        }
    }

    private void updateToPreviousWorkFinish(Calendar calendar) {
        Date date = calendar.getTime();
        ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, calendar, null);
        if (projectCalendarDateRanges != null) {
            Date date2 = DateHelper.getCanonicalTime(calendar.getTime());
            Date date3 = null;
            for (DateRange dateRange : projectCalendarDateRanges) {
                Date date4 = DateHelper.getCanonicalTime(dateRange.getEnd());
                Date date5 = DateHelper.getDayStartDate(dateRange.getStart());
                Date date6 = DateHelper.getDayStartDate(dateRange.getEnd());
                if (date5.getTime() != date6.getTime()) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(date4);
                    calendar2.add(6, 1);
                    date4 = calendar2.getTime();
                }
                if (date2.getTime() < date4.getTime()) continue;
                date3 = date4;
                break;
            }
            if (date3 == null) {
                Day day;
                int n = 0;
                do {
                    calendar.set(6, calendar.get(6) - 1);
                    day = Day.getInstance(calendar.get(7));
                    if (++n <= 1000) continue;
                    calendar.setTime(date);
                    break;
                } while (!this.isWorkingDate(calendar.getTime(), day));
                date3 = this.getFinishTime(calendar.getTime());
            }
            DateHelper.setTime(calendar, date3);
        }
    }

    public Date getNextWorkStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.updateToNextWorkStart(calendar);
        return calendar.getTime();
    }

    public Date getPreviousWorkFinish(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.updateToPreviousWorkFinish(calendar);
        return calendar.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Day day = Day.getInstance(calendar.get(7));
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, null, day);
        return projectCalendarDateRanges.getRangeCount() != 0;
    }

    private int getDaysInRange(Date date, Date date2) {
        int n;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        int n2 = calendar.get(1);
        int n3 = calendar.get(6);
        calendar.setTime(date);
        if (n2 == calendar.get(1)) {
            n = n3 - calendar.get(6) + 1;
        } else {
            n = 0;
            do {
                n += calendar.getActualMaximum(6) - calendar.get(6) + 1;
                calendar.roll(1, 1);
                calendar.set(6, 1);
            } while (calendar.get(1) < n2);
            n += n3;
        }
        return n;
    }

    @Override
    public void setUniqueID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        if (this.m_uniqueID != null) {
            projectFile.getCalendars().unmapUniqueID(this.m_uniqueID);
        }
        projectFile.getCalendars().mapUniqueID(n, this);
        this.m_uniqueID = n;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
        String string = this.m_resource.getName();
        if (string == null || string.length() == 0) {
            string = "Unnamed Resource";
        }
        this.setName(string);
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        ProjectCalendarException projectCalendarException = null;
        if (!this.m_exceptions.isEmpty()) {
            if (!this.m_exceptionsSorted) {
                Collections.sort(this.m_exceptions);
                this.m_exceptionsSorted = true;
            }
            int n = 0;
            int n2 = this.m_exceptions.size() - 1;
            long l = date.getTime();
            while (n <= n2) {
                int n3 = n + n2 >>> 1;
                ProjectCalendarException projectCalendarException2 = this.m_exceptions.get(n3);
                int n4 = 0 - DateHelper.compare(projectCalendarException2.getFromDate(), projectCalendarException2.getToDate(), l);
                if (n4 < 0) {
                    n = n3 + 1;
                    continue;
                }
                if (n4 > 0) {
                    n2 = n3 - 1;
                    continue;
                }
                projectCalendarException = projectCalendarException2;
                break;
            }
        }
        if (projectCalendarException == null && this.getParent() != null) {
            projectCalendarException = this.getParent().getException(date);
        }
        return projectCalendarException;
    }

    public Duration getWork(Date date, TimeUnit timeUnit) {
        ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, null, null);
        long l = this.getTotalTime(projectCalendarDateRanges);
        return this.convertFormat(l, timeUnit);
    }

    public Duration getWork(Date date, Date date2, TimeUnit timeUnit) {
        DateRange dateRange = new DateRange(date, date2);
        Long l = this.m_workingDateCache.get(dateRange);
        long l2 = 0L;
        if (l == null) {
            Date date3;
            boolean bl = false;
            if (date.getTime() > date2.getTime()) {
                bl = true;
                date3 = date;
                date = date2;
                date2 = date3;
            }
            date3 = DateHelper.getDayStartDate(date);
            Date date4 = DateHelper.getDayStartDate(date2);
            if (date3.getTime() == date4.getTime()) {
                ProjectCalendarDateRanges projectCalendarDateRanges = this.getRanges(date, null, null);
                if (projectCalendarDateRanges.getRangeCount() != 0) {
                    l2 = this.getTotalTime(projectCalendarDateRanges, date, date2);
                }
            } else {
                ProjectCalendarDateRanges projectCalendarDateRanges;
                Date date5 = date;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Day day = Day.getInstance(calendar.get(7));
                while (!this.isWorkingDate(date5, day) && date5.getTime() < date4.getTime()) {
                    calendar.add(6, 1);
                    date5 = calendar.getTime();
                    day = day.getNextDay();
                }
                if (date5.getTime() < date4.getTime()) {
                    l2 += this.getTotalTime(this.getRanges(date5, null, day), date5, true);
                    while (true) {
                        calendar.add(6, 1);
                        date5 = calendar.getTime();
                        day = day.getNextDay();
                        if (date5.getTime() >= date4.getTime()) break;
                        projectCalendarDateRanges = this.getRanges(date5, null, day);
                        if (projectCalendarDateRanges.getRangeCount() == 0) continue;
                        l2 += this.getTotalTime(projectCalendarDateRanges);
                    }
                }
                if ((projectCalendarDateRanges = this.getRanges(date2, null, day)).getRangeCount() != 0) {
                    l2 += this.getTotalTime(projectCalendarDateRanges, DateHelper.getDayStartDate(date2), date2);
                }
            }
            if (bl) {
                l2 = -l2;
            }
            this.m_workingDateCache.put(dateRange, l2);
        } else {
            l2 = l;
        }
        return this.convertFormat(l2, timeUnit);
    }

    private Duration convertFormat(long l, TimeUnit timeUnit) {
        double d = l;
        double d2 = this.getParentFile().getProjectProperties().getMinutesPerDay().doubleValue();
        double d3 = this.getParentFile().getProjectProperties().getMinutesPerWeek().doubleValue();
        double d4 = this.getParentFile().getProjectProperties().getDaysPerMonth().doubleValue();
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                d /= 60000.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                d /= 3600000.0;
                break;
            }
            case DAYS: {
                if (d2 != 0.0) {
                    d /= d2 * 60.0 * 1000.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case WEEKS: {
                if (d3 != 0.0) {
                    d /= d3 * 60.0 * 1000.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case MONTHS: {
                if (d4 != 0.0 && d2 != 0.0) {
                    d /= d4 * d2 * 60.0 * 1000.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case ELAPSED_DAYS: {
                d /= 8.64E7;
                break;
            }
            case ELAPSED_WEEKS: {
                d /= 6.048E8;
                break;
            }
            case ELAPSED_MONTHS: {
                d /= -1.702967296E9;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + timeUnit + " not supported");
            }
        }
        return Duration.getInstance(d, timeUnit);
    }

    private long getTotalTime(ProjectCalendarDateRanges projectCalendarDateRanges, Date date, boolean bl) {
        long l = DateHelper.getCanonicalTime(date).getTime();
        long l2 = 0L;
        for (DateRange dateRange : projectCalendarDateRanges) {
            l2 += this.getTime(dateRange.getStart(), dateRange.getEnd(), l, bl);
        }
        return l2;
    }

    private long getTotalTime(ProjectCalendarDateRanges projectCalendarDateRanges) {
        long l = 0L;
        for (DateRange dateRange : projectCalendarDateRanges) {
            l += this.getTime(dateRange.getStart(), dateRange.getEnd());
        }
        return l;
    }

    private long getTotalTime(ProjectCalendarDateRanges projectCalendarDateRanges, Date date, Date date2) {
        long l = 0L;
        if (date.getTime() != date2.getTime()) {
            Date date3 = DateHelper.getCanonicalTime(date);
            Date date4 = DateHelper.getCanonicalTime(date2);
            for (DateRange dateRange : projectCalendarDateRanges) {
                Date date5 = dateRange.getStart();
                Date date6 = dateRange.getEnd();
                if (date5 == null || date6 == null) continue;
                Date date7 = DateHelper.getCanonicalTime(date5);
                Date date8 = DateHelper.getCanonicalTime(date6);
                Date date9 = DateHelper.getDayStartDate(date5);
                Date date10 = DateHelper.getDayStartDate(date6);
                if (date9.getTime() != date10.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date8);
                    calendar.add(6, 1);
                    date8 = calendar.getTime();
                }
                if (date7.getTime() == date8.getTime() && date6.getTime() > date5.getTime()) {
                    l += 86400000L;
                    continue;
                }
                l += this.getTime(date3, date4, date7, date8);
            }
        }
        return l;
    }

    private long getTime(Date date, Date date2, long l, boolean bl) {
        long l2 = 0L;
        if (date != null && date2 != null) {
            int n;
            Date date3 = DateHelper.getCanonicalTime(date);
            Date date4 = DateHelper.getCanonicalTime(date2);
            Date date5 = DateHelper.getDayStartDate(date);
            Date date6 = DateHelper.getDayStartDate(date2);
            if (date5.getTime() != date6.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date4);
                calendar.add(6, 1);
                date4 = calendar.getTime();
            }
            if ((n = DateHelper.compare(date3, date4, l)) == 0) {
                l2 = bl ? date4.getTime() - l : l - date3.getTime();
            } else if (bl && n < 0 || !bl && n > 0) {
                l2 = date4.getTime() - date3.getTime();
            }
        }
        return l2;
    }

    private long getTime(Date date, Date date2) {
        long l = 0L;
        if (date != null && date2 != null) {
            Date date3 = DateHelper.getCanonicalTime(date);
            Date date4 = DateHelper.getCanonicalTime(date2);
            Date date5 = DateHelper.getDayStartDate(date);
            Date date6 = DateHelper.getDayStartDate(date2);
            if (date5.getTime() != date6.getTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date4);
                calendar.add(6, 1);
                date4 = calendar.getTime();
            }
            l = date4.getTime() - date3.getTime();
        }
        return l;
    }

    private long getTime(Date date, Date date2, Date date3, Date date4) {
        long l;
        long l2;
        long l3 = 0L;
        if (date != null && date2 != null && date3 != null && date4 != null && (l2 = date.getTime() < date3.getTime() ? date3.getTime() : date.getTime()) < (l = date2.getTime() < date4.getTime() ? date2.getTime() : date4.getTime())) {
            l3 = l - l2;
        }
        return l3;
    }

    protected void addDerivedCalendar(ProjectCalendar projectCalendar) {
        this.m_derivedCalendars.add(projectCalendar);
    }

    protected void removeDerivedCalendar(ProjectCalendar projectCalendar) {
        this.m_derivedCalendars.remove(projectCalendar);
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return this.m_derivedCalendars;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("[ProjectCalendar");
        printWriter.println("   ID=" + this.m_uniqueID);
        printWriter.println("   name=" + this.getName());
        printWriter.println("   baseCalendarName=" + (this.getParent() == null ? "" : this.getParent().getName()));
        printWriter.println("   resource=" + (this.m_resource == null ? "" : this.m_resource.getName()));
        String[] stringArray = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        for (int i = 0; i < 7; ++i) {
            printWriter.println("   [Day " + stringArray[i]);
            printWriter.println("      type=" + this.getDays()[i]);
            printWriter.println("      hours=" + this.getHours()[i]);
            printWriter.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            printWriter.println("   [Exceptions=");
            for (ProjectCalendarException projectCalendarException : this.m_exceptions) {
                printWriter.println("      " + projectCalendarException.toString());
            }
            printWriter.println("   ]");
        }
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public ProjectCalendar(ProjectFile projectFile, ProjectCalendar projectCalendar, ProjectCalendar projectCalendar2) {
        this.m_projectFile = projectFile;
        this.setResource(projectCalendar2.getResource());
        block0: for (int i = 1; i <= 7; ++i) {
            Day day;
            this.setWorkingDay(day, projectCalendar.isWorkingDay(day = Day.getInstance(i)) && projectCalendar2.isWorkingDay(day));
            ProjectCalendarHours projectCalendarHours = this.addCalendarHours(day);
            int n = 0;
            int n2 = 0;
            ProjectCalendarHours projectCalendarHours2 = projectCalendar.getHours(day);
            ProjectCalendarHours projectCalendarHours3 = projectCalendar2.getHours(day);
            DateRange dateRange = null;
            DateRange dateRange2 = null;
            Date date = null;
            Date date2 = null;
            Date date3 = null;
            Date date4 = null;
            Date date5 = null;
            Date date6 = null;
            while (projectCalendarHours2.getRangeCount() > n) {
                dateRange = projectCalendarHours2.getRange(n);
                if (projectCalendarHours3.getRangeCount() <= n2) continue block0;
                dateRange2 = projectCalendarHours3.getRange(n2);
                date3 = dateRange.getStart();
                date4 = dateRange2.getStart();
                date5 = dateRange.getEnd();
                date6 = dateRange2.getEnd();
                date = date3.compareTo(date4) > 0 ? date3 : date4;
                if (date5.compareTo(date6) < 0) {
                    date2 = date5;
                    ++n;
                } else {
                    date2 = date6;
                    ++n2;
                }
                if (date2 == null || date2.compareTo(date) <= 0) continue;
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
        }
        this.m_exceptions.addAll(projectCalendar.getCalendarExceptions());
        this.m_exceptions.addAll(projectCalendar2.getCalendarExceptions());
        this.m_exceptionsSorted = false;
    }

    public void copy(ProjectCalendar projectCalendar) {
        this.setName(projectCalendar.getName());
        this.setParent(projectCalendar.getParent());
        System.arraycopy(projectCalendar.getDays(), 0, this.getDays(), 0, this.getDays().length);
        for (ProjectCalendarException projectCalendarException : projectCalendar.m_exceptions) {
            this.addCalendarException(projectCalendarException.getFromDate(), projectCalendarException.getToDate());
            for (DateRange object : projectCalendarException) {
                projectCalendarException.addRange(new DateRange(object.getStart(), object.getEnd()));
            }
        }
        for (ProjectCalendarHours projectCalendarHours : this.getHours()) {
            if (projectCalendarHours == null) continue;
            ProjectCalendarHours projectCalendarHours2 = projectCalendar.addCalendarHours(projectCalendarHours.getDay());
            for (DateRange dateRange : projectCalendarHours) {
                projectCalendarHours2.addRange(new DateRange(dateRange.getStart(), dateRange.getEnd()));
            }
        }
    }

    private void clearWorkingDateCache() {
        this.m_workingDateCache.clear();
        this.m_startTimeCache.clear();
        for (ProjectCalendar projectCalendar : this.m_derivedCalendars) {
            projectCalendar.clearWorkingDateCache();
        }
    }

    private ProjectCalendarDateRanges getRanges(Date date, Calendar calendar, Day day) {
        ProjectCalendarDateRanges projectCalendarDateRanges = this.getException(date);
        if (projectCalendarDateRanges == null) {
            if (day == null) {
                if (calendar == null) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(date);
                }
                day = Day.getInstance(calendar.get(7));
            }
            projectCalendarDateRanges = this.getHours(day);
        }
        return projectCalendarDateRanges;
    }

    public final ProjectFile getParentFile() {
        return this.m_projectFile;
    }
}

