/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.dialog.ColumnDialog;
import com.projity.dialog.FieldAliasDialog;
import com.projity.field.Field;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;

public class SpreadSheetColumnMenu
extends JPopupMenu {
    private static final long serialVersionUID = -8788124911790572547L;
    private JMenuItem insert = new JMenuItem(Messages.getString("SpreadSheetColumnMenu.InsertColumn"));
    private JMenuItem hide = new JMenuItem(Messages.getString("SpreadSheetColumnMenu.HideColumn"));
    private JMenuItem rename = new JMenuItem(Messages.getString("RenameDialog.Rename"));
    private JMenuItem find = new JMenuItem(Messages.getString("LookupDialog.Find"));

    public SpreadSheetColumnMenu(CommonSpreadSheet commonSpreadSheet, final int n) {
        this.setBorder(new BevelBorder(0));
        final CommonSpreadSheet commonSpreadSheet2 = commonSpreadSheet;
        final SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)commonSpreadSheet2.getFieldArray();
        this.insert.setIcon(IconManager.getIcon("menu.insertColumn"));
        this.insert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Field field = ColumnDialog.getFieldFromDialog(commonSpreadSheet2, commonSpreadSheet2.getAvailableFields(), spreadSheetFieldArray);
                if (field != null) {
                    int n2 = n;
                    if (n2 == 0) {
                        n2 = spreadSheetFieldArray.size();
                    }
                    commonSpreadSheet2.setFieldArray(spreadSheetFieldArray.insertField(n2, field));
                }
            }
        });
        this.hide.setIcon(IconManager.getIcon("menu.hideColumn"));
        this.hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (spreadSheetFieldArray.size() > 2) {
                    commonSpreadSheet2.setFieldArray(spreadSheetFieldArray.removeField(n));
                } else {
                    Alert.warn(Messages.getString("Message.cantEmptySpreadsheet"), commonSpreadSheet2);
                }
            }
        });
        final Field field = (Field)spreadSheetFieldArray.get(n);
        this.rename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (spreadSheetFieldArray.size() > 2) {
                    FieldAliasDialog.doRename(field);
                    commonSpreadSheet2.setFieldArray(spreadSheetFieldArray);
                } else {
                    Alert.warn(Messages.getString("Message.cantEmptySpreadsheet"), commonSpreadSheet2);
                }
            }
        });
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicManager.getInstance().doFind(commonSpreadSheet2, field);
            }
        });
        this.add(this.insert);
        this.add(this.hide);
        if (field.isCustom()) {
            this.add(this.rename);
        }
        this.add(this.find);
    }
}

