/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.pm.graphic.gantt.Gantt;
import com.projity.pm.graphic.gantt.GanttInteractor;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.gantt.GanttRenderer;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.GraphZone;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.timescale.CoordinatesConverter;

public class GanttUI
extends GraphUI {
    public static final int PROGRESS_BAR_ZONE_ID = 1;

    public GanttUI(Gantt gantt) {
        super(gantt, new GanttRenderer(gantt));
        this.interactor = new GanttInteractor(this);
    }

    public double getBarY(int n) {
        return n * ((Gantt)this.graph).getRowHeight() + this.config.getGanttBarYOffset();
    }

    public GraphZone getNodeAt(double d, double d2) {
        double d3;
        double d4 = ((Gantt)this.graph).getRowHeight();
        int n = (int)Math.floor(d2 / d4);
        if (n < 0 || n >= this.graph.getModel().getCache().getSize()) {
            return null;
        }
        GraphicNode graphicNode = (GraphicNode)this.graph.getModel().getCache().getElementAt(n);
        double d5 = this.getBarY(n) + graphicNode.getGanttShapeOffset();
        double d6 = graphicNode.getGanttShapeHeight();
        double d7 = this.config.getSelectionSquare();
        if (d2 < d5 || d2 > d5 + d6) {
            return null;
        }
        CoordinatesConverter coordinatesConverter = this.getCoord();
        double d8 = coordinatesConverter.toTime(d);
        if (graphicNode.contains(d8, d3 = coordinatesConverter.toDuration(d7), d3, coordinatesConverter) == null) {
            return null;
        }
        double d9 = this.config.getGanttProgressBarHeight();
        GraphZone graphZone = new GraphZone();
        graphZone.setObject(graphicNode);
        if (d2 >= d5 + d6 / 2.0 - d9 / 2.0 && d2 < d5 + d6 / 2.0 + d9 / 2.0) {
            graphZone.setZoneId(1);
        }
        return graphZone;
    }

    public CoordinatesConverter getCoord() {
        return ((GanttParams)this.graphRenderer.getGraphInfo()).getCoord();
    }
}

