/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.projity.configuration.FieldDictionary;
import com.projity.dialog.ButtonPanel;
import com.projity.help.HelpUtil;
import com.projity.menu.HyperLinkToolTip;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.strings.Messages;
import com.projity.util.BrowserControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import org.apache.commons.collections.Closure;

public abstract class AbstractDialog
extends JDialog {
    protected JButton ok;
    protected JButton cancel;
    protected JComponent help;
    protected Frame owner;
    private int dialogResult = 2;
    protected JComponent contentPanel = null;
    protected ButtonPanel buttonPanel = null;
    private String helpAddress = null;
    protected boolean listenersActivated = true;

    public AbstractDialog() {
    }

    public AbstractDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.createRootPane();
        this.setLocationRelativeTo(null);
        this.owner = frame;
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onCancel();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onOk();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onHelp();
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        jRootPane.registerKeyboardAction(actionListener2, keyStroke2, 2);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(112, 0);
        jRootPane.registerKeyboardAction(actionListener3, keyStroke3, 2);
        return jRootPane;
    }

    protected boolean hasHelp() {
        return this.helpAddress != null;
    }

    protected boolean hasHelpButton() {
        return this.hasHelp();
    }

    protected void onHelp() {
        if (this.helpAddress != null) {
            BrowserControl.displayURL(HelpUtil.getHelpURL(this.helpAddress));
        } else {
            System.out.println("no help available");
        }
    }

    protected void onCancel() {
        this.setVisible(false);
        this.setDialogResult(2);
    }

    public void onOk() {
        if (!this.bind(false)) {
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
    }

    public abstract JComponent createContentPanel();

    public void setVisible(boolean bl) {
        if (bl && !this.listenersActivated) {
            this.activateListeners();
        } else if (!bl && this.listenersActivated) {
            this.desactivateListeners();
        }
        super.setVisible(bl);
    }

    protected void activateListeners() {
        this.listenersActivated = true;
    }

    protected void desactivateListeners() {
        this.listenersActivated = false;
    }

    protected boolean bind(boolean bl) {
        return true;
    }

    protected void initComponents() {
        this.contentPanel = this.createContentPanel();
        this.buttonPanel = this.createButtonPanel();
        this.getContentPane().setLayout(new BorderLayout());
        if (this.contentPanel != null) {
            this.getContentPane().add((Component)this.contentPanel, "Center");
        }
        if (this.buttonPanel != null) {
            this.getContentPane().add((Component)this.buttonPanel, "Last");
        }
    }

    protected void clearComponents() {
        if (this.contentPanel != null) {
            this.getContentPane().remove(this.contentPanel);
        }
        if (this.buttonPanel != null) {
            this.getContentPane().remove(this.buttonPanel);
        }
    }

    public void pack() {
        this.initComponents();
        super.pack();
    }

    protected void createOkCancelButtons(String string, String string2) {
        this.ok = new JButton(string);
        this.ok.setEnabled(this.initialOkEnabledState());
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onOk();
            }
        });
        this.cancel = new JButton(string2);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onCancel();
            }
        });
    }

    protected JComponent getHelpButton() {
        if (this.help == null) {
            this.help = new JButton(MenuManager.getMenuString("Help.text"));
            this.help.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractDialog.this.onHelp();
                }
            });
        }
        return this.help;
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons(Messages.getString("ButtonText.OK"), Messages.getString("ButtonText.Cancel"));
    }

    protected void createCloseButton() {
        this.ok = new JButton(Messages.getString("ButtonText.Close"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.onOk();
            }
        });
    }

    public ButtonPanel createButtonPanel() {
        if (!this.hasOkAndCancelButtons() && !this.hasCloseButton()) {
            return null;
        }
        if (this.hasCloseButton()) {
            this.createCloseButton();
        } else {
            this.createOkCancelButtons();
        }
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton(this.ok);
        if (this.hasOkAndCancelButtons()) {
            buttonPanel.addButton(this.cancel);
        }
        if (this.hasHelpButton()) {
            buttonPanel.add(this.getHelpButton());
        }
        return buttonPanel;
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public boolean doModal() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.getDialogResult() != 2;
    }

    public Object getBean() {
        return null;
    }

    public int execute(Closure closure, Closure closure2) {
        this.pack();
        closure.execute(this.getBean());
        this.bind(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (this.getDialogResult() != 2 && closure2 != null) {
            closure2.execute(this.getBean());
        }
        return this.getDialogResult();
    }

    protected boolean initialOkEnabledState() {
        return true;
    }

    public static ComboBoxModel getComboBoxModel(String string) {
        Object[] objectArray = FieldDictionary.getInstance().getFieldFromId(string).getOptions(null);
        return new DefaultComboBoxModel<Object>(objectArray);
    }

    public ReferenceNodeModelCache getReferenceCache(boolean bl) {
        DocumentFrame documentFrame = GraphicManager.getInstance(this).getCurrentFrame();
        return documentFrame.getReferenceCache(bl);
    }

    public NodeModelCache createCache(boolean bl, String string) {
        DocumentFrame documentFrame = GraphicManager.getInstance(this).getCurrentFrame();
        return documentFrame.createCache(bl, string);
    }

    protected boolean hasOkAndCancelButtons() {
        return !this.hasCloseButton();
    }

    protected boolean hasCloseButton() {
        return false;
    }

    public static JDialog containedInDialog(Object object) {
        if (!(object instanceof Component)) {
            return null;
        }
        for (Component component = (Component)object; component != null; component = component.getParent()) {
            if (!(component instanceof JDialog)) continue;
            return (JDialog)component;
        }
        return null;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int n) {
        this.dialogResult = n;
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(ButtonPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(JComponent jComponent) {
        this.contentPanel = jComponent;
    }

    public void addDocHelp(String string) {
        HelpUtil.addDocHelp(this, string);
        this.helpAddress = string;
    }

    public class DoubleClickRadio
    extends JRadioButton
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        public DoubleClickRadio(String string, String string2) {
            super(string);
            this.setToolTipText(string2);
            this.addMouseListener(this);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(this.getWidth() - 2, -20);
        }

        public JToolTip createToolTip() {
            HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
            hyperLinkToolTip.setComponent(this);
            return hyperLinkToolTip;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                AbstractDialog.this.bind(false);
                ((JRadioButton)mouseEvent.getSource()).setSelected(true);
                AbstractDialog.this.onOk();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

