/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XDocumentSubStorageSupplier;
import com.sun.star.embed.XStorage;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class XStorageHelper
implements XEventListener {
    XStorage[] xStorages;
    static Map<String, XModel> modelMap = new HashMap<String, XModel>();
    XModel xModel = null;
    private static XStorageHelper listener = new XStorageHelper();

    private XStorageHelper() {
    }

    public XStorageHelper(String string, int n, boolean bl) throws IOException {
        String string2 = null;
        int n2 = string.lastIndexOf("Scripts");
        if (n2 > -1) {
            string2 = string.substring(0, n2 - 1);
            string = string.substring(n2, string.length());
        }
        LogUtils.DEBUG("XStorageHelper ctor, path: " + string);
        this.xModel = this.getModelForURL(string2);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.countTokens() == 0) {
                throw new IOException("Invalid path");
            }
            XDocumentSubStorageSupplier xDocumentSubStorageSupplier = (XDocumentSubStorageSupplier)UnoRuntime.queryInterface(XDocumentSubStorageSupplier.class, (Object)this.xModel);
            this.xStorages = new XStorage[stringTokenizer.countTokens()];
            LogUtils.DEBUG("XStorageHelper ctor, path chunks length: " + this.xStorages.length);
            for (int i = 0; i < this.xStorages.length; ++i) {
                XNameAccess xNameAccess;
                LogUtils.DEBUG("XStorageHelper, processing index " + i);
                String string3 = stringTokenizer.nextToken();
                LogUtils.DEBUG("XStorageHelper, getting: " + string3);
                XStorage xStorage = null;
                if (i == 0) {
                    xStorage = xDocumentSubStorageSupplier.getDocumentSubStorage(string3, n);
                    if (xStorage == null) {
                        LogUtils.DEBUG("** boo hoo Storage is null ");
                    }
                    if ((xNameAccess = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStorage)) != null) {
                        String string4 = AnyConverter.toString((Object)xNameAccess.getPropertyValue("MediaType"));
                        LogUtils.DEBUG("***** media type is " + string4);
                        if (!string4.equals("scripts")) {
                            xNameAccess.setPropertyValue("MediaType", (Object)"scripts");
                        }
                    }
                } else {
                    xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xStorages[i - 1]);
                    if (xNameAccess == null) {
                        this.disposeObject();
                        throw new IOException("No name access " + string3);
                    }
                    if (!xNameAccess.hasByName(string3) || !this.xStorages[i - 1].isStorageElement(string3)) {
                        if (!bl) {
                            this.disposeObject();
                            throw new IOException("No subdir: " + string3);
                        }
                        LogUtils.DEBUG("Attempt to create new storage for " + string3);
                    }
                    xStorage = this.xStorages[i - 1].openStorageElement(string3, n);
                }
                if (xStorage == null) {
                    this.disposeObject();
                    throw new IOException("storage not found: " + string3);
                }
                this.xStorages[i] = xStorage;
            }
        }
        catch (com.sun.star.io.IOException iOException) {
            this.disposeObject();
        }
        catch (com.sun.star.uno.Exception exception) {
            this.disposeObject();
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public static synchronized void addNewModel(XModel xModel) {
        modelMap.put(PathUtils.getOidForModel(xModel), xModel);
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
        if (xComponent != null) {
            try {
                xComponent.addEventListener((XEventListener)listener);
            }
            catch (Exception exception) {
                LogUtils.DEBUG(LogUtils.getTrace(exception));
            }
        }
    }

    public void disposing(EventObject eventObject) {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)eventObject.Source);
        if (xModel != null) {
            LogUtils.DEBUG(" Disposing doc " + xModel.getURL());
            modelMap.remove(PathUtils.getOidForModel(xModel));
        }
    }

    public XStorage getStorage() {
        return this.xStorages[this.xStorages.length - 1];
    }

    public XModel getModel() {
        return this.xModel;
    }

    public void disposeObject() {
        this.disposeObject(false);
    }

    public void disposeObject(boolean bl) {
        LogUtils.DEBUG("In disposeObject");
        for (int i = this.xStorages.length - 1; i > -1; --i) {
            LogUtils.DEBUG("In disposeObject disposing storage " + i);
            try {
                XStorage xStorage = this.xStorages[i];
                if (bl) {
                    XStorageHelper.commit((XInterface)xStorage);
                }
                XStorageHelper.disposeObject((XInterface)xStorage);
                LogUtils.DEBUG("In disposeObject disposed storage " + i);
                continue;
            }
            catch (Exception exception) {
                LogUtils.DEBUG("Exception disposing storage " + i);
            }
        }
    }

    public static void disposeObject(XInterface xInterface) {
        if (xInterface == null) {
            return;
        }
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xInterface);
        if (xComponent == null) {
            return;
        }
        xComponent.dispose();
    }

    public static void commit(XInterface xInterface) {
        XTransactedObject xTransactedObject = (XTransactedObject)UnoRuntime.queryInterface(XTransactedObject.class, (Object)xInterface);
        if (xTransactedObject != null) {
            try {
                xTransactedObject.commit();
            }
            catch (Exception exception) {
                LogUtils.DEBUG("Something went bellyup exception: " + exception);
            }
        }
    }

    public XModel getModelForURL(String string) {
        return modelMap.get(string);
    }
}

