/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.contentassist.DynamicTypeContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.dialogs.SelectionDialog;

public class EditLogicalStructureDialog
extends StatusDialog
implements Listener,
ISelectionChangedListener,
IDocumentListener,
DynamicTypeContext.ITypeProvider {
    private final JavaLogicalStructure fLogicalStructure;
    private Text fQualifiedTypeNameText;
    private Text fDescriptionText;
    private TableViewer fAttributeListViewer;
    private Button fSubTypeButton;
    private Button fValueButton;
    private Button fVariablesButton;
    private Button fAttributeUpButton;
    private Button fAttributeDownButton;
    private JDISourceViewer fSnippetViewer;
    private Document fSnippetDocument;
    private Button fBrowseTypeButton;
    private Button fAttributeAddButton;
    private Button fAttributeRemoveButton;
    private Text fAttributeNameText;
    private Composite fAttributesContainer;
    private Group fCodeGroup;
    private Composite fParentComposite;
    private AttributesContentProvider fAttributesContentProvider;
    private String fValueTmp;
    private IStructuredSelection fCurrentAttributeSelection;
    private IType fType;
    private boolean fTypeSearched = false;
    private DisplayViewerConfiguration fViewerConfiguration;
    private HandlerSubmission fSubmission;

    public EditLogicalStructureDialog(Shell parentShell, JavaLogicalStructure logicalStructure) {
        super(parentShell);
        this.setShellStyle(3184);
        if (logicalStructure.getQualifiedTypeName().length() == 0) {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_32);
        } else {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_31);
        }
        this.fLogicalStructure = logicalStructure;
    }

    protected Control createDialogArea(Composite parent) {
        boolean isValue;
        this.fParentComposite = parent;
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(Map parameterValuesByName) throws ExecutionException {
                EditLogicalStructureDialog.this.findCorrespondingType();
                EditLogicalStructureDialog.this.fSnippetViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        this.fSubmission = new HandlerSubmission(null, parent.getShell(), null, "org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler, Priority.MEDIUM);
        commandSupport.addHandlerSubmission(this.fSubmission);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setFont(parent.getFont());
        Composite typeNameDescriptionContainer = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        typeNameDescriptionContainer.setLayout((Layout)gridLayout);
        typeNameDescriptionContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        Label typeLabel = new Label(typeNameDescriptionContainer, 0);
        typeLabel.setText(DebugUIMessages.EditLogicalStructureDialog_0);
        typeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fQualifiedTypeNameText = new Text(typeNameDescriptionContainer, 2052);
        this.fQualifiedTypeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fQualifiedTypeNameText.addListener(24, (Listener)this);
        this.fBrowseTypeButton = new Button(typeNameDescriptionContainer, 8);
        this.fBrowseTypeButton.setText(DebugUIMessages.EditLogicalStructureDialog_1);
        this.fBrowseTypeButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_25);
        this.setButtonLayoutData(this.fBrowseTypeButton);
        this.fBrowseTypeButton.addListener(13, (Listener)this);
        Label descriptionLabel = new Label(typeNameDescriptionContainer, 0);
        descriptionLabel.setText(DebugUIMessages.EditLogicalStructureDialog_2);
        descriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fDescriptionText = new Text(typeNameDescriptionContainer, 2052);
        this.fDescriptionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fDescriptionText.addListener(24, (Listener)this);
        this.fSubTypeButton = new Button(typeNameDescriptionContainer, 32);
        this.fSubTypeButton.setText(DebugUIMessages.EditLogicalStructureDialog_3);
        this.fSubTypeButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_26);
        this.fSubTypeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Group radioContainer = new Group(container, 0);
        radioContainer.setText(DebugUIMessages.EditLogicalStructureDialog_33);
        gridLayout = new GridLayout(1, true);
        radioContainer.setLayout((Layout)gridLayout);
        radioContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fValueButton = new Button((Composite)radioContainer, 16);
        this.fValueButton.setText(DebugUIMessages.EditLogicalStructureDialog_4);
        this.fValueButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.fValueButton.addListener(13, (Listener)this);
        this.fVariablesButton = new Button((Composite)radioContainer, 16);
        this.fVariablesButton.setText(DebugUIMessages.EditLogicalStructureDialog_5);
        this.fVariablesButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fAttributesContainer = new Composite(container, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        this.fAttributesContainer.setLayout((Layout)gridLayout);
        this.fAttributesContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        boolean bl = isValue = this.fLogicalStructure.getValue() != null;
        if (!isValue) {
            this.createAttributeListWidgets();
        }
        this.fCodeGroup = new Group(container, 0);
        this.fCodeGroup.setLayout((Layout)new GridLayout(1, false));
        this.fCodeGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.createCodeGroupWidgets(isValue);
        EditLogicalStructureDialog.applyDialogFont((Control)container);
        this.initializeData();
        return container;
    }

    private void createCodeGroupWidgets(boolean isValue) {
        Font font = this.fCodeGroup.getFont();
        if (isValue) {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_9);
        } else {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_7);
            Composite attributeNameContainer = new Composite((Composite)this.fCodeGroup, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            attributeNameContainer.setLayout((Layout)gridLayout);
            attributeNameContainer.setLayoutData((Object)new GridData(4, 1, false, false));
            Label attributeNameLabel = new Label(attributeNameContainer, 0);
            attributeNameLabel.setText(DebugUIMessages.EditLogicalStructureDialog_8);
            attributeNameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            attributeNameLabel.setFont(font);
            this.fAttributeNameText = new Text(attributeNameContainer, 2052);
            this.fAttributeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fAttributeNameText.addListener(24, (Listener)this);
            this.fAttributeNameText.setFont(font);
        }
        if (!isValue) {
            Label attributeValueLabel = new Label((Composite)this.fCodeGroup, 0);
            attributeValueLabel.setText(DebugUIMessages.EditLogicalStructureDialog_9);
            attributeValueLabel.setLayoutData((Object)new GridData(1, 4, true, false));
            attributeValueLabel.setFont(font);
        }
        this.fSnippetViewer = new JDISourceViewer((Composite)this.fCodeGroup, null, 2816);
        this.fSnippetViewer.setInput(this);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        if (this.fSnippetDocument == null) {
            this.fSnippetDocument = new Document();
            this.fSnippetDocument.addDocumentListener((IDocumentListener)this);
        }
        tools.setupJavaDocumentPartitioner((IDocument)this.fSnippetDocument, "___java_partitioning");
        if (this.fViewerConfiguration == null) {
            this.fViewerConfiguration = new DisplayViewerConfiguration(){

                public IContentAssistProcessor getContentAssistantProcessor() {
                    return new JavaDebugContentAssistProcessor(new DynamicTypeContext(EditLogicalStructureDialog.this));
                }
            };
        }
        this.fSnippetViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)this.fSnippetDocument);
        Control control = this.fSnippetViewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(isValue ? 20 : 10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
    }

    private void createAttributeListWidgets() {
        Font font = this.fAttributesContainer.getFont();
        this.fAttributeListViewer = new TableViewer(this.fAttributesContainer, 67586);
        Table table = (Table)this.fAttributeListViewer.getControl();
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(font);
        if (this.fAttributesContentProvider == null) {
            this.fAttributesContentProvider = new AttributesContentProvider(this.fLogicalStructure.getVariables());
        }
        this.fAttributeListViewer.setContentProvider((IContentProvider)this.fAttributesContentProvider);
        this.fAttributeListViewer.setLabelProvider((IBaseLabelProvider)new AttributesLabelProvider());
        this.fAttributeListViewer.setInput((Object)this);
        this.fAttributeListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite attributesListButtonsContainer = new Composite(this.fAttributesContainer, 0);
        GridLayout gridLayout = new GridLayout();
        attributesListButtonsContainer.setLayout((Layout)gridLayout);
        attributesListButtonsContainer.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAttributeAddButton = new Button(attributesListButtonsContainer, 8);
        this.fAttributeAddButton.setText(DebugUIMessages.EditLogicalStructureDialog_10);
        this.fAttributeAddButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_27);
        this.fAttributeAddButton.setFont(font);
        this.setButtonLayoutData(this.fAttributeAddButton);
        this.fAttributeAddButton.addListener(13, (Listener)this);
        this.fAttributeRemoveButton = new Button(attributesListButtonsContainer, 8);
        this.fAttributeRemoveButton.setText(DebugUIMessages.EditLogicalStructureDialog_11);
        this.fAttributeRemoveButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_28);
        this.fAttributeRemoveButton.setFont(font);
        this.setButtonLayoutData(this.fAttributeRemoveButton);
        this.fAttributeRemoveButton.addListener(13, (Listener)this);
        this.fAttributeUpButton = new Button(attributesListButtonsContainer, 8);
        this.fAttributeUpButton.setText(DebugUIMessages.EditLogicalStructureDialog_12);
        this.fAttributeUpButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_29);
        this.fAttributeUpButton.setFont(font);
        this.setButtonLayoutData(this.fAttributeUpButton);
        this.fAttributeUpButton.addListener(13, (Listener)this);
        this.fAttributeDownButton = new Button(attributesListButtonsContainer, 8);
        this.fAttributeDownButton.setText(DebugUIMessages.EditLogicalStructureDialog_13);
        this.fAttributeDownButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_30);
        this.fAttributeDownButton.setFont(font);
        this.setButtonLayoutData(this.fAttributeDownButton);
        this.fAttributeDownButton.addListener(13, (Listener)this);
    }

    private void initializeData() {
        this.fQualifiedTypeNameText.setText(this.fLogicalStructure.getQualifiedTypeName());
        this.fDescriptionText.setText(this.fLogicalStructure.getDescription());
        this.fSubTypeButton.setSelection(this.fLogicalStructure.isSubtypes());
        this.fValueTmp = this.fLogicalStructure.getValue();
        if (this.fValueTmp == null) {
            this.fValueTmp = "";
            this.fVariablesButton.setSelection(true);
            this.setAttributesData(false);
        } else {
            this.fValueButton.setSelection(true);
            this.setAttributesData(true);
        }
        this.checkValues();
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        switch (event.type) {
            case 13: {
                if (source == this.fValueButton) {
                    this.toggleAttributesWidgets(this.fValueButton.getSelection());
                    this.checkValues();
                    break;
                }
                if (source == this.fBrowseTypeButton) {
                    this.selectType();
                    break;
                }
                if (source == this.fAttributeAddButton) {
                    this.addAttribute();
                    break;
                }
                if (source == this.fAttributeRemoveButton) {
                    this.removeAttribute();
                    break;
                }
                if (source == this.fAttributeUpButton) {
                    this.attributeUp();
                    break;
                }
                if (source != this.fAttributeDownButton) break;
                this.attributeDown();
                break;
            }
            case 24: {
                if (source == this.fAttributeNameText) {
                    this.saveNewAttributeName();
                    this.checkValues();
                    break;
                }
                if (source == this.fQualifiedTypeNameText) {
                    this.checkValues();
                    this.fTypeSearched = false;
                    break;
                }
                if (source != this.fDescriptionText) break;
                this.checkValues();
            }
        }
    }

    private void addAttribute() {
        String[] newAttribute = new String[]{DebugUIMessages.EditLogicalStructureDialog_14, DebugUIMessages.EditLogicalStructureDialog_15};
        this.fAttributesContentProvider.add(newAttribute);
        this.fAttributeListViewer.refresh();
        this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute));
    }

    private void removeAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            List selectedElements = selection.toList();
            String[][] elements = this.fAttributesContentProvider.getElements();
            String[] newSelectedElement = null;
            int i = 0;
            while (i < elements.length) {
                if (selectedElements.contains(elements[i])) break;
                newSelectedElement = elements[i];
                ++i;
            }
            this.fAttributesContentProvider.remove(selectedElements);
            this.fAttributeListViewer.refresh();
            if (newSelectedElement == null) {
                String[][] newElements = this.fAttributesContentProvider.getElements();
                if (newElements.length > 0) {
                    this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newElements[0]));
                }
            } else {
                this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedElement));
            }
        }
    }

    private void attributeUp() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.up(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void attributeDown() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.down(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void saveNewAttributeName() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            variable[0] = this.fAttributeNameText.getText();
            this.fAttributeListViewer.refresh((Object)variable);
        }
    }

    private void toggleAttributesWidgets(boolean isValue) {
        int i;
        Control[] children;
        if (!isValue) {
            this.fValueTmp = this.fSnippetDocument.get();
            this.createAttributeListWidgets();
        } else if (isValue) {
            this.saveAttributeValue();
            children = this.fAttributesContainer.getChildren();
            i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        children = this.fCodeGroup.getChildren();
        i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fSnippetViewer.dispose();
        this.createCodeGroupWidgets(isValue);
        this.setAttributesData(isValue);
        this.fParentComposite.layout(true, true);
    }

    private void setAttributesData(boolean isValue) {
        if (isValue) {
            this.fSnippetDocument.set(this.fValueTmp);
        } else {
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            this.fCurrentAttributeSelection = new StructuredSelection();
            if (elements.length > 0) {
                StructuredSelection newSelection = new StructuredSelection(elements[0]);
                this.fAttributeListViewer.setSelection((ISelection)newSelection);
            } else {
                this.fAttributeListViewer.setSelection((ISelection)this.fCurrentAttributeSelection);
            }
        }
    }

    private void setNameValueToSelection() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            this.fAttributeNameText.setText(variable[0]);
            this.fSnippetDocument.set(variable[1]);
            this.fAttributeNameText.setEnabled(true);
            this.fSnippetViewer.setEditable(true);
            this.fAttributeNameText.setSelection(0, variable[0].length());
            this.fAttributeNameText.setFocus();
        } else {
            this.fAttributeNameText.setEnabled(false);
            this.fSnippetViewer.setEditable(false);
            this.fAttributeNameText.setText("");
            this.fSnippetDocument.set("");
        }
    }

    private void saveAttributeValue() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            ((String[])this.fCurrentAttributeSelection.getFirstElement())[1] = this.fSnippetDocument.get();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.saveAttributeValue();
        this.fCurrentAttributeSelection = (IStructuredSelection)event.getSelection();
        this.setNameValueToSelection();
        this.updateAttributeListButtons();
    }

    private void updateAttributeListButtons() {
        int selectionSize = this.fCurrentAttributeSelection.size();
        if (selectionSize > 0) {
            this.fAttributeRemoveButton.setEnabled(true);
            String[][] elements = this.fAttributesContentProvider.getElements();
            this.fAttributeUpButton.setEnabled(this.fCurrentAttributeSelection.getFirstElement() != elements[0]);
            this.fAttributeDownButton.setEnabled(this.fCurrentAttributeSelection.toArray()[selectionSize - 1] != elements[elements.length - 1]);
        } else {
            this.fAttributeRemoveButton.setEnabled(false);
            this.fAttributeUpButton.setEnabled(false);
            this.fAttributeDownButton.setEnabled(false);
        }
    }

    public void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.fQualifiedTypeNameText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_16);
        } else if (this.fDescriptionText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_17);
        } else if (this.fValueButton.getSelection() && this.fSnippetDocument.get().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_18);
        } else if (this.fVariablesButton.getSelection()) {
            boolean oneElementSelected;
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            boolean bl = oneElementSelected = this.fCurrentAttributeSelection.size() == 1;
            if (elements.length == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_19);
            } else if (oneElementSelected && this.fAttributeNameText.getText().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_20);
            } else if (oneElementSelected && this.fSnippetDocument.get().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_21);
            } else {
                int i = 0;
                while (i < elements.length) {
                    String[] variable = (String[])elements[i];
                    if (variable[0].trim().length() == 0) {
                        status.setError(DebugUIMessages.EditLogicalStructureDialog_22);
                        break;
                    }
                    if (!(variable[1].trim().length() != 0 || oneElementSelected && this.fCurrentAttributeSelection.getFirstElement() == variable)) {
                        status.setError(MessageFormat.format((String)DebugUIMessages.EditLogicalStructureDialog_23, (Object[])new String[]{variable[0]}));
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!status.isError() && this.fType == null && this.fTypeSearched) {
            status.setWarning(DebugUIMessages.EditLogicalStructureDialog_24);
        }
        this.updateStatus((IStatus)status);
    }

    private void selectType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)this.fQualifiedTypeNameText.getText());
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.DetailFormatterDialog_Select_type_6;
            String message = DebugUIMessages.DetailFormatterDialog_Could_not_open_type_selection_dialog_for_detail_formatters_7;
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.DetailFormatterDialog_Select_type_8);
        dialog.setMessage(DebugUIMessages.DetailFormatterDialog_Select_a_type_to_format_when_displaying_its_detail_9);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fType = (IType)types[0];
            this.fQualifiedTypeNameText.setText(this.fType.getFullyQualifiedName());
            this.fTypeSearched = true;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.checkValues();
    }

    protected void okPressed() {
        this.fLogicalStructure.setType(this.fQualifiedTypeNameText.getText().trim());
        this.fLogicalStructure.setDescription(this.fDescriptionText.getText().trim());
        this.fLogicalStructure.setSubtypes(this.fSubTypeButton.getSelection());
        if (this.fValueButton.getSelection()) {
            this.fLogicalStructure.setValue(this.fSnippetDocument.get());
        } else {
            this.saveAttributeValue();
            this.fLogicalStructure.setValue(null);
        }
        if (this.fAttributesContentProvider != null) {
            this.fLogicalStructure.setVariables(this.fAttributesContentProvider.getElements());
        }
        super.okPressed();
    }

    private void findCorrespondingType() {
        if (this.fTypeSearched) {
            return;
        }
        this.fType = null;
        this.fTypeSearched = true;
        String pattern = this.fQualifiedTypeNameText.getText().trim().replace('$', '.');
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        SearchRequestor collector = new SearchRequestor((IProgressMonitor)monitor){
            private boolean fFirst = true;
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public void endReporting() {
                EditLogicalStructureDialog.this.checkValues();
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object enclosingElement = match.getElement();
                if (!this.fFirst) {
                    return;
                }
                this.fFirst = false;
                if (enclosingElement instanceof IType) {
                    EditLogicalStructureDialog.this.fType = (IType)enclosingElement;
                }
                this.val$monitor.setCanceled(true);
            }
        };
        SearchEngine engine = new SearchEngine(JavaCore.getWorkingCopies(null));
        SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            engine.search(searchPattern, participants, scope, collector, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public IType getType() {
        if (!this.fTypeSearched) {
            this.findCorrespondingType();
        }
        return this.fType;
    }

    public boolean close() {
        PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.fSubmission);
        this.fSnippetViewer.dispose();
        return super.close();
    }

    public class AttributesContentProvider
    implements IStructuredContentProvider {
        private final List fVariables = new ArrayList();

        public AttributesContentProvider(String[][] variables) {
            int i = 0;
            while (i < variables.length) {
                String[] variable = new String[]{variables[i][0], variables[i][1]};
                this.fVariables.add(variable);
                ++i;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        public String[][] getElements() {
            return (String[][])this.fVariables.toArray((T[])new String[this.fVariables.size()][]);
        }

        public void add(String[] newAttribute) {
            this.fVariables.add(newAttribute);
        }

        public void remove(List list) {
            this.fVariables.removeAll(list);
        }

        public void up(List list) {
            for (String[] variable : list) {
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index - 1, variable);
            }
        }

        public void down(List list) {
            for (String[] variable : list) {
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index + 1, variable);
            }
        }
    }

    public class AttributesLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((String[])element)[0];
        }
    }
}

