/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.validation;

import org.eclipse.jface.internal.databinding.internal.BindingMessages;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class String2ShortValidator
implements IValidator {
    public ValidationError isPartiallyValid(Object fragment) {
        if (((String)fragment).matches("\\-?[0-9]*")) {
            return null;
        }
        return ValidationError.error(this.getHint());
    }

    public ValidationError isValid(Object value) {
        try {
            Short.parseShort((String)value);
            return null;
        }
        catch (Throwable throwable) {
            return ValidationError.error(this.getHint());
        }
    }

    private String getHint() {
        return String.valueOf(BindingMessages.getString("Validate_RangeStart")) + Short.MIN_VALUE + BindingMessages.getString("and") + Short.MAX_VALUE + ".";
    }
}

