/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.appserver;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.AppserverResources;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.osgi.framework.BundleContext;

public class AppserverPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help.appserver";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    private static final String APP_SERVER_EXTENSION_ID = "org.eclipse.help.appserver.server";
    private static final String APP_SERVER_CLASS_ATTRIBUTE = "class";
    private static final String APP_SERVER_DEFAULT_ATTRIBUTE = "default";
    private static AppserverPlugin plugin;
    private IWebappServer appServer;
    private String contributingServerPlugin;
    private String hostAddress;
    private int port;

    public static AppserverPlugin getDefault() {
        return plugin;
    }

    public synchronized IWebappServer getAppServer() throws CoreException {
        if (this.appServer == null) {
            this.createWebappServer();
            this.startWebappServer();
        }
        return this.appServer;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.appServer != null) {
            this.appServer.stop();
        }
        plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public String getContributingServerPlugin() {
        return this.contributingServerPlugin;
    }

    private void createWebappServer() throws CoreException {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(APP_SERVER_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            if (elements.length == 0) {
                return;
            }
            IConfigurationElement serverElement = null;
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute(APP_SERVER_DEFAULT_ATTRIBUTE);
                if (defaultValue == null || defaultValue.equals("false")) {
                    serverElement = elements[i];
                    break;
                }
                ++i;
            }
            if (serverElement == null) {
                serverElement = elements[0];
            }
            try {
                this.appServer = (IWebappServer)serverElement.createExecutableExtension(APP_SERVER_CLASS_ATTRIBUTE);
                this.contributingServerPlugin = serverElement.getContributor().getName();
            }
            catch (CoreException e) {
                this.getLog().log(e.getStatus());
                throw e;
            }
        }
    }

    private void startWebappServer() throws CoreException {
        this.hostAddress = this.getPluginPreferences().getString(HOST_KEY);
        if ("".equals(this.hostAddress)) {
            this.hostAddress = null;
        }
        this.port = this.getPluginPreferences().getInt(PORT_KEY);
        try {
            String hostCommandLineOverride = System.getProperty("server_host");
            if (hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0) {
                this.hostAddress = hostCommandLineOverride;
            }
        }
        catch (Exception exception) {}
        try {
            String portCommandLineOverride = System.getProperty("server_port");
            if (portCommandLineOverride != null && portCommandLineOverride.trim().length() > 0) {
                this.port = Integer.parseInt(portCommandLineOverride);
            }
        }
        catch (Exception exception) {}
        if (this.appServer == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, AppserverResources.Appserver_start, null));
        }
        this.appServer.start(this.port, this.hostAddress);
    }
}

