/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ProxyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label proxyTypeLabel;
    private Label proxyHostLabel;
    private Label proxyPortLabel;
    private Label proxyUserLabel;
    private Label proxyPassLabel;
    private Button enableProxy;
    private Combo proxyTypeCombo;
    private Text proxyHostText;
    private Text proxyPortText;
    private Button enableAuth;
    private Text proxyUserText;
    private Text proxyPassText;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createProxyPage(composite);
        this.initializeDefaults();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.proxy_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.enableProxy.setSelection(store.getBoolean("proxyEnabled"));
        this.proxyTypeCombo.select(store.getString("proxyType").equals("HTTP") ? 0 : 1);
        this.proxyHostText.setText(store.getString("proxyHost"));
        this.proxyPortText.setText(store.getString("proxyPort"));
        this.enableAuth.setSelection(store.getBoolean("proxyAuth"));
        this.proxyUserText.setText(CVSProviderPlugin.getPlugin().getProxyUser());
        this.proxyPassText.setText(CVSProviderPlugin.getPlugin().getProxyPassword());
        this.updateControls();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("proxyEnabled", this.enableProxy.getSelection());
        store.setValue("proxyType", this.proxyTypeCombo.getText());
        store.setValue("proxyHost", this.proxyHostText.getText());
        store.setValue("proxyPort", this.proxyPortText.getText());
        store.setValue("proxyAuth", this.enableAuth.getSelection());
        CVSProviderPlugin plugin = CVSProviderPlugin.getPlugin();
        plugin.setUseProxy(this.enableProxy.getSelection());
        plugin.setProxyType(this.proxyTypeCombo.getText());
        plugin.setProxyHost(this.proxyHostText.getText());
        plugin.setProxyPort(this.proxyPortText.getText());
        plugin.setUseProxyAuth(this.enableAuth.getSelection());
        plugin.setProxyAuth(this.proxyUserText.getText(), this.proxyPassText.getText());
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        store.setToDefault("proxyEnabled");
        store.setToDefault("proxyType");
        store.setToDefault("proxyHost");
        store.setToDefault("proxyPort");
        store.setToDefault("proxyAuth");
        CVSProviderPlugin.getPlugin().setProxyAuth("", "");
        this.initializeDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    private void createProxyPage(Composite group) {
        this.enableProxy = new Button(group, 32);
        this.enableProxy.setText(CVSUIMessages.CVSProxyPreferencePage_enableProxy);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.enableProxy.setLayoutData((Object)gd);
        this.enableProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.updateControls();
            }
        });
        this.proxyTypeLabel = new Label(group, 0);
        this.proxyTypeLabel.setText(CVSUIMessages.CVSProxyPreferencePage_proxyTpe);
        this.proxyTypeCombo = new Combo(group, 8);
        this.proxyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.proxyTypeCombo.setLayoutData((Object)gd);
        this.proxyTypeCombo.add("HTTP");
        this.proxyTypeCombo.add("SOCKS5");
        this.proxyTypeCombo.select(0);
        this.proxyTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProxyPreferencePage.this.proxyPortText == null) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                String foo = combo.getText();
                if (foo.equals("HTTP")) {
                    ProxyPreferencePage.this.proxyPortText.setText("80");
                } else if (foo.equals("SOCKS5")) {
                    ProxyPreferencePage.this.proxyPortText.setText("1080");
                }
            }
        });
        this.proxyHostLabel = new Label(group, 0);
        this.proxyHostLabel.setText(CVSUIMessages.CVSProxyPreferencePage_proxyHost);
        this.proxyHostText = new Text(group, 2052);
        this.proxyHostText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.proxyHostText.setLayoutData((Object)gd);
        this.proxyPortLabel = new Label(group, 0);
        this.proxyPortLabel.setText(CVSUIMessages.CVSProxyPreferencePage_proxyPort);
        this.proxyPortText = new Text(group, 2052);
        this.proxyPortText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.proxyPortText.setLayoutData((Object)gd);
        this.proxyPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProxyPreferencePage.this.isValidPort(ProxyPreferencePage.this.proxyPortText.getText())) {
                    ProxyPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.createSpacer(group, 2);
        this.enableAuth = new Button(group, 32);
        this.enableAuth.setText(CVSUIMessages.CVSProxyPreferencePage_enableProxyAuth);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.enableAuth.setLayoutData((Object)gd);
        this.enableAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.updateControls();
            }
        });
        this.proxyUserLabel = new Label(group, 0);
        this.proxyUserLabel.setText(CVSUIMessages.CVSProxyPreferencePage_proxyUser);
        this.proxyUserText = new Text(group, 2052);
        this.proxyUserText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.proxyUserText.setLayoutData((Object)gd);
        this.proxyPassLabel = new Label(group, 0);
        this.proxyPassLabel.setText(CVSUIMessages.CVSProxyPreferencePage_proxyPass);
        this.proxyPassText = new Text(group, 2052);
        this.proxyPassText.setEchoChar('*');
        this.proxyPassText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.proxyPassText.setLayoutData((Object)gd);
    }

    private boolean isValidPort(String port) {
        int i = -1;
        try {
            i = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {}
        if (i < 0 || i > 65535) {
            this.setErrorMessage(CVSUIMessages.CVSProxyPreferencePage_proxyPortError);
            return false;
        }
        return true;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void updateControls() {
        boolean enable = this.enableProxy.getSelection();
        this.proxyTypeLabel.setEnabled(enable);
        this.proxyTypeCombo.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.proxyPortText.setEnabled(enable);
        this.proxyHostLabel.setEnabled(enable);
        this.proxyHostText.setEnabled(enable);
        this.enableAuth.setEnabled(enable);
        this.proxyUserLabel.setEnabled(enable &= this.enableAuth.getSelection());
        this.proxyUserText.setEnabled(enable);
        this.proxyPassLabel.setEnabled(enable);
        this.proxyPassText.setEnabled(enable);
    }
}

