/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JarPackageReader
implements IJarDescriptionReader {
    protected InputStream fInputStream;
    private MultiStatus fWarnings;

    public JarPackageReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
        this.fWarnings = new MultiStatus(JavaPlugin.getPluginId(), 0, JarPackagerMessages.JarPackageReader_jarPackageReaderWarnings, null);
    }

    public void read(JarPackageData jarPackage) throws CoreException {
        try {
            this.readXML(jarPackage);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
        }
        catch (SAXException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
        }
    }

    public void close() throws CoreException {
        if (this.fInputStream != null) {
            try {
                this.fInputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
            }
        }
    }

    public JarPackageData readXML(JarPackageData jarPackage) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Element xmlJarDesc = parser.parse(new InputSource(this.fInputStream)).getDocumentElement();
        if (!xmlJarDesc.getNodeName().equals("jardesc")) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_badFormat);
        }
        NodeList topLevelElements = xmlJarDesc.getChildNodes();
        int i = 0;
        while (i < topLevelElements.getLength()) {
            Node node = topLevelElements.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.xmlReadJarLocation(jarPackage, element);
                this.xmlReadOptions(jarPackage, element);
                this.xmlReadRefactoring(jarPackage, element);
                this.xmlReadSelectedProjects(jarPackage, element);
                if (jarPackage.areGeneratedFilesExported()) {
                    this.xmlReadManifest(jarPackage, element);
                }
                this.xmlReadSelectedElements(jarPackage, element);
            }
            ++i;
        }
        return jarPackage;
    }

    private void xmlReadJarLocation(JarPackageData jarPackage, Element element) {
        if (element.getNodeName().equals("jar")) {
            jarPackage.setJarLocation(Path.fromPortableString((String)element.getAttribute("path")));
        }
    }

    private void xmlReadOptions(JarPackageData jarPackage, Element element) throws IOException {
        if (element.getNodeName().equals("options")) {
            jarPackage.setOverwrite(this.getBooleanAttribute(element, "overwrite"));
            jarPackage.setCompress(this.getBooleanAttribute(element, "compress"));
            jarPackage.setExportErrors(this.getBooleanAttribute(element, "exportErrors"));
            jarPackage.setExportWarnings(this.getBooleanAttribute(element, "exportWarnings"));
            jarPackage.setSaveDescription(this.getBooleanAttribute(element, "saveDescription"));
            jarPackage.setUseSourceFolderHierarchy(this.getBooleanAttribute(element, "useSourceFolders", false));
            jarPackage.setDescriptionLocation(Path.fromPortableString((String)element.getAttribute("descriptionLocation")));
            jarPackage.setBuildIfNeeded(this.getBooleanAttribute(element, "buildIfNeeded", jarPackage.isBuildingIfNeeded()));
            jarPackage.setIncludeDirectoryEntries(this.getBooleanAttribute(element, "includeDirectoryEntries", false));
            jarPackage.setRefactoringAware(this.getBooleanAttribute(element, "storeRefactorings", false));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void xmlReadRefactoring(JarPackageData jarPackage, Element element) throws IOException {
        if (element.getNodeName().equals("storedRefactorings")) {
            jarPackage.setExportStructuralOnly(this.getBooleanAttribute(element, "structuralOnly", jarPackage.isExportStructuralOnly()));
            jarPackage.setDeprecationAware(this.getBooleanAttribute(element, "deprecationInfo", jarPackage.isDeprecationAware()));
            ArrayList<Object> elements = new ArrayList<Object>();
            int count = 1;
            String value = element.getAttribute("project" + count);
            while (value != null && !"".equals(value)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(value);
                if (project.exists()) {
                    elements.add(project);
                }
                value = element.getAttribute("project" + ++count);
            }
            jarPackage.setRefactoringProjects(elements.toArray(new IProject[elements.size()]));
            elements.clear();
            count = 1;
            IRefactoringHistoryService service = RefactoringCore.getHistoryService();
            try {
                service.connect();
                value = element.getAttribute("refactoring" + count);
                while (value != null && !"".equals(value)) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
                    try {
                        RefactoringDescriptorProxy[] descriptors;
                        RefactoringHistory history = service.readRefactoringHistory((InputStream)stream, 0);
                        if (history != null && (descriptors = history.getDescriptors()).length > 0) {
                            int index = 0;
                            while (index < descriptors.length) {
                                elements.add(descriptors[index]);
                                ++index;
                            }
                        }
                    }
                    catch (CoreException exception) {
                        JavaPlugin.log(exception);
                    }
                    value = element.getAttribute("refactoring" + ++count);
                }
            }
            finally {
                service.disconnect();
            }
            jarPackage.setRefactoringDescriptors(elements.toArray(new RefactoringDescriptorProxy[elements.size()]));
        }
    }

    private void xmlReadManifest(JarPackageData jarPackage, Element element) throws IOException {
        if (element.getNodeName().equals("manifest")) {
            jarPackage.setManifestVersion(element.getAttribute("manifestVersion"));
            jarPackage.setUsesManifest(this.getBooleanAttribute(element, "usesManifest"));
            jarPackage.setReuseManifest(this.getBooleanAttribute(element, "reuseManifest"));
            jarPackage.setSaveManifest(this.getBooleanAttribute(element, "saveManifest"));
            jarPackage.setGenerateManifest(this.getBooleanAttribute(element, "generateManifest"));
            jarPackage.setManifestLocation(Path.fromPortableString((String)element.getAttribute("manifestLocation")));
            jarPackage.setManifestMainClass(this.getMainClass(element));
            this.xmlReadSealingInfo(jarPackage, element);
        }
    }

    private void xmlReadSealingInfo(JarPackageData jarPackage, Element element) throws IOException {
        NodeList sealingElementContainer = element.getChildNodes();
        int j = 0;
        while (j < sealingElementContainer.getLength()) {
            Node sealingNode = sealingElementContainer.item(j);
            if (sealingNode.getNodeType() == 1 && sealingNode.getNodeName().equals("sealing")) {
                Element sealingElement = (Element)sealingNode;
                jarPackage.setSealJar(this.getBooleanAttribute(sealingElement, "sealJar"));
                jarPackage.setPackagesToSeal(this.getPackages(sealingElement.getElementsByTagName("packagesToSeal")));
                jarPackage.setPackagesToUnseal(this.getPackages(sealingElement.getElementsByTagName("packagesToUnSeal")));
            }
            ++j;
        }
    }

    private void xmlReadSelectedElements(JarPackageData jarPackage, Element element) throws IOException {
        if (element.getNodeName().equals("selectedElements")) {
            jarPackage.setExportClassFiles(this.getBooleanAttribute(element, "exportClassFiles"));
            jarPackage.setExportOutputFolders(this.getBooleanAttribute(element, "exportOutputFolder", false));
            jarPackage.setExportJavaFiles(this.getBooleanAttribute(element, "exportJavaFiles"));
            NodeList selectedElements = element.getChildNodes();
            HashSet elementsToExport = new HashSet(selectedElements.getLength());
            int j = 0;
            while (j < selectedElements.getLength()) {
                Node selectedNode = selectedElements.item(j);
                if (selectedNode.getNodeType() == 1) {
                    Element selectedElement = (Element)selectedNode;
                    if (selectedElement.getNodeName().equals("file")) {
                        this.addFile(elementsToExport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("folder")) {
                        this.addFolder(elementsToExport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("project")) {
                        this.addProject(elementsToExport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("javaElement")) {
                        this.addJavaElement(elementsToExport, selectedElement);
                    }
                }
                ++j;
            }
            jarPackage.setElements(elementsToExport.toArray());
        }
    }

    private void xmlReadSelectedProjects(JarPackageData jarPackage, Element element) throws IOException {
        if (element.getNodeName().equals("selectedProjects")) {
            NodeList selectedElements = element.getChildNodes();
            HashSet selectedProjects = new HashSet(selectedElements.getLength());
            int index = 0;
            while (index < selectedElements.getLength()) {
                Element selectedElement;
                Node node = selectedElements.item(index);
                if (node.getNodeType() == 1 && (selectedElement = (Element)node).getNodeName().equals("project")) {
                    this.addProject(selectedProjects, selectedElement);
                }
                ++index;
            }
            jarPackage.setRefactoringProjects(selectedProjects.toArray(new IProject[selectedProjects.size()]));
        }
    }

    protected boolean getBooleanAttribute(Element element, String name, boolean defaultValue) throws IOException {
        if (element.hasAttribute(name)) {
            return this.getBooleanAttribute(element, name);
        }
        return defaultValue;
    }

    protected boolean getBooleanAttribute(Element element, String name) throws IOException {
        String value = element.getAttribute(name);
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value != null && value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IOException(JarPackagerMessages.JarPackageReader_error_illegalValueForBooleanAttribute);
    }

    private void addFile(Set selectedElements, Element element) throws IOException {
        IFile file;
        IPath path = this.getPath(element);
        if (path != null && (file = JavaPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            selectedElements.add(file);
        }
    }

    private void addFolder(Set selectedElements, Element element) throws IOException {
        IFolder folder;
        IPath path = this.getPath(element);
        if (path != null && (folder = JavaPlugin.getWorkspace().getRoot().getFolder(path)) != null) {
            selectedElements.add(folder);
        }
    }

    private void addProject(Set selectedElements, Element element) throws IOException {
        String name = element.getAttribute("name");
        if (name.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagNameNotFound);
        }
        IProject project = JavaPlugin.getWorkspace().getRoot().getProject(name);
        if (project != null) {
            selectedElements.add(project);
        }
    }

    private IPath getPath(Element element) throws IOException {
        String pathString = element.getAttribute("path");
        if (pathString.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagPathNotFound);
        }
        return Path.fromPortableString((String)element.getAttribute("path"));
    }

    private void addJavaElement(Set selectedElements, Element element) throws IOException {
        String handleId = element.getAttribute("handleIdentifier");
        if (handleId.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagHandleIdentifierNotFoundOrEmpty);
        }
        IJavaElement je = JavaCore.create((String)handleId);
        if (je == null) {
            this.addWarning(JarPackagerMessages.JarPackageReader_warning_javaElementDoesNotExist, null);
        } else {
            selectedElements.add(je);
        }
    }

    private IPackageFragment[] getPackages(NodeList list) throws IOException {
        if (list.getLength() > 1) {
            throw new IOException(Messages.format(JarPackagerMessages.JarPackageReader_error_duplicateTag, list.item(0).getNodeName()));
        }
        if (list.getLength() == 0) {
            return null;
        }
        NodeList packageNodes = list.item(0).getChildNodes();
        ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(packageNodes.getLength());
        int i = 0;
        while (i < packageNodes.getLength()) {
            Node packageNode = packageNodes.item(i);
            if (packageNode.getNodeType() == 1 && packageNode.getNodeName().equals("package")) {
                String handleId = ((Element)packageNode).getAttribute("handleIdentifier");
                if (handleId.equals("")) {
                    throw new IOException(JarPackagerMessages.JarPackageReader_error_tagHandleIdentifierNotFoundOrEmpty);
                }
                IJavaElement je = JavaCore.create((String)handleId);
                if (je != null && je.getElementType() == 4) {
                    packages.add(je);
                } else {
                    this.addWarning(JarPackagerMessages.JarPackageReader_warning_javaElementDoesNotExist, null);
                }
            }
            ++i;
        }
        return packages.toArray(new IPackageFragment[packages.size()]);
    }

    private IType getMainClass(Element element) {
        String handleId = element.getAttribute("mainClassHandleIdentifier");
        if (handleId.equals("")) {
            return null;
        }
        IJavaElement je = JavaCore.create((String)handleId);
        if (je != null && je.getElementType() == 7) {
            return (IType)je;
        }
        this.addWarning(JarPackagerMessages.JarPackageReader_warning_mainClassDoesNotExist, null);
        return null;
    }

    public IStatus getStatus() {
        if (this.fWarnings.getChildren().length == 0) {
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
        return this.fWarnings;
    }

    protected void addWarning(String message, Throwable error) {
        this.fWarnings.add((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, message, error));
    }
}

