/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class VariableDeclarationCleanUp
extends AbstractCleanUp {
    public static final int ADD_FINAL_MODIFIER_FIELDS = 1;
    public static final int ADD_FINAL_MODIFIER_PARAMETERS = 2;
    public static final int ADD_FINAL_MODIFIER_LOCAL_VARIABLES = 4;
    private static final int DEFAULT_FLAG = 0;
    private static final String SECTION_NAME = "CleanUp_VariableDeclarations";

    public VariableDeclarationCleanUp(int flag) {
        super(flag);
    }

    public VariableDeclarationCleanUp(IDialogSettings settings) {
        super(VariableDeclarationCleanUp.getSection(settings, SECTION_NAME), 0);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return VariableDeclarationFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(2), this.isFlag(4));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(VariableDeclarationCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isFlag(1)) {
            buf.append("private final int i= 0;\n");
        } else {
            buf.append("private int i= 0;\n");
        }
        if (this.isFlag(2)) {
            buf.append("public void foo(final int j) {\n");
        } else {
            buf.append("public void foo(int j) {\n");
        }
        if (this.isFlag(4)) {
            buf.append("    final int k;\n");
            buf.append("    int h;\n");
            buf.append("    h= 0;\n");
        } else {
            buf.append("    int k, h;\n");
            buf.append("    h= 0;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public int getDefaultFlag() {
        return 0;
    }
}

