/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class JavaDeleteProcessor
extends DeleteProcessor
implements ICommentProvider {
    private boolean fWasCanceled;
    private boolean fSuggestGetterSetterDeletion;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private IReorgQueries fDeleteQueries;
    private DeleteModifications fDeleteModifications;
    private String fComment;
    private Change fDeleteChange;
    private boolean fDeleteSubPackages;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.DeleteProcessor";

    public JavaDeleteProcessor(Object[] elements) {
        this.fElements = elements;
        this.fResources = RefactoringAvailabilityTester.getResources(elements);
        this.fJavaElements = RefactoringAvailabilityTester.getJavaElements(elements);
        this.fSuggestGetterSetterDeletion = true;
        this.fDeleteSubPackages = false;
        this.fWasCanceled = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fJavaElements.length) {
            return false;
        }
        int i = 0;
        while (i < this.fResources.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fResources[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fJavaElements.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fJavaElements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fJavaElements != null) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                int type = this.fJavaElements[i].getElementType();
                if (type <= 6) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteRefactoring_7;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fDeleteModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fJavaElements);
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        HashSet result = new HashSet();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public void setSuggestGetterSetterDeletion(boolean suggest) {
        this.fSuggestGetterSetterDeletion = suggest;
    }

    public void setDeleteSubPackages(boolean selection) {
        this.fDeleteSubPackages = selection;
    }

    public boolean getDeleteSubPackages() {
        return this.fDeleteSubPackages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSubPackagesToDelete() {
        try {
            int i = 0;
            while (true) {
                IPackageFragment packageFragment;
                if (i >= this.fJavaElements.length) {
                    return false;
                }
                if (this.fJavaElements[i] instanceof IPackageFragment && !(packageFragment = (IPackageFragment)this.fJavaElements[i]).isDefaultPackage() && packageFragment.hasSubpackages()) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fDeleteQueries = queries;
    }

    public IJavaElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotLinked(this.fResources))));
        IResource[] javaResources = ReorgUtils.getResources(this.fJavaElements);
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IType) {
                ((IType)element).isAnonymous();
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.DeleteRefactoring_1, 1);
        try {
            this.fWasCanceled = false;
            RefactoringStatus result = new RefactoringStatus();
            this.recalculateElementsToDelete();
            TextChangeManager manager = new TextChangeManager();
            this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fJavaElements, this.getProcessorName());
            this.checkDirtyCompilationUnits(result);
            this.checkDirtyResources(result);
            this.fDeleteModifications = new DeleteModifications();
            this.fDeleteModifications.delete(this.fResources);
            this.fDeleteModifications.delete(this.fJavaElements);
            this.fDeleteModifications.postProcess();
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fDeleteModifications.buildDelta(deltaFactory);
            IFile[] files = this.getClassPathFiles();
            int i = 0;
            while (i < files.length) {
                deltaFactory.change(files[i]);
                ++i;
            }
            files = ResourceUtil.getFiles(manager.getAllCompilationUnits());
            i = 0;
            while (i < files.length) {
                deltaFactory.change(files[i]);
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        finally {
            pm.done();
        }
    }

    private void checkDirtyCompilationUnits(RefactoringStatus result) throws CoreException {
        if (this.fJavaElements == null || this.fJavaElements.length == 0) {
            return;
        }
        int je = 0;
        while (je < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[je];
            if (element instanceof ICompilationUnit) {
                this.checkDirtyCompilationUnit(result, (ICompilationUnit)element);
            } else if (element instanceof IPackageFragment) {
                ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
                int u = 0;
                while (u < units.length) {
                    this.checkDirtyCompilationUnit(result, units[u]);
                    ++u;
                }
            }
            ++je;
        }
    }

    private void checkDirtyCompilationUnit(RefactoringStatus result, ICompilationUnit cunit) {
        IResource resource = cunit.getResource();
        if (resource == null || resource.getType() != 1) {
            return;
        }
        this.checkDirtyFile(result, (IFile)resource);
    }

    private void checkDirtyResources(final RefactoringStatus result) throws CoreException {
        int i = 0;
        while (i < this.fResources.length) {
            IResource resource = this.fResources[i];
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) throws CoreException {
                    if (visitedResource instanceof IFile) {
                        JavaDeleteProcessor.this.checkDirtyFile(result, (IFile)visitedResource);
                    }
                    return true;
                }
            }, 2, false);
            ++i;
        }
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath());
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            } else {
                result.addFatalError(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        if (this.fDeleteSubPackages) {
            this.addSubPackages();
        }
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptyCusToDelete();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
        this.addDeletableParentPackagesOnPackageDeletion();
    }

    private void addSubPackages() throws JavaModelException {
        HashSet<IJavaElement> javaElements = new HashSet<IJavaElement>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            if (this.fJavaElements[i] instanceof IPackageFragment) {
                javaElements.addAll((Collection)Arrays.asList(JavaElementUtil.getPackageAndSubpackages((IPackageFragment)this.fJavaElements[i])));
            } else {
                javaElements.add(this.fJavaElements[i]);
            }
            ++i;
        }
        this.fJavaElements = javaElements.toArray(new IJavaElement[javaElements.size()]);
    }

    private void addDeletableParentPackagesOnPackageDeletion() throws CoreException {
        List initialPackagesToDelete = ReorgUtils.getElementsOfType(this.fJavaElements, 4);
        if (initialPackagesToDelete.size() == 0) {
            return;
        }
        Collections.sort(initialPackagesToDelete, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IPackageFragment one = (IPackageFragment)arg0;
                IPackageFragment two = (IPackageFragment)arg1;
                return two.getElementName().compareTo(one.getElementName());
            }
        });
        HashSet<IResource> deletedChildren = new HashSet<IResource>();
        deletedChildren.addAll((Collection)Arrays.asList(this.fResources));
        int i = 0;
        while (i < this.fJavaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(this.fJavaElements[i])) {
                deletedChildren.add(this.fJavaElements[i].getResource());
            }
            ++i;
        }
        ArrayList<Object> allFragmentsToDelete = new ArrayList<Object>();
        for (IPackageFragment currentPackageFragment : initialPackagesToDelete) {
            IPackageFragment parent;
            allFragmentsToDelete.add(currentPackageFragment);
            if (!this.canRemoveCompletely(currentPackageFragment, initialPackagesToDelete) || (parent = JavaElementUtil.getParentSubpackage(currentPackageFragment)) == null || initialPackagesToDelete.contains(parent)) continue;
            ArrayList emptyParents = new ArrayList();
            this.addDeletableParentPackages(parent, initialPackagesToDelete, deletedChildren, emptyParents);
            allFragmentsToDelete.addAll(emptyParents);
        }
        ArrayList<Object> javaElements = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < this.fJavaElements.length) {
            IPackageFragment frag;
            if (!(this.fJavaElements[i2] instanceof IPackageFragment) && !allFragmentsToDelete.contains(frag = (IPackageFragment)this.fJavaElements[i2].getAncestor(4))) {
                javaElements.add(this.fJavaElements[i2]);
            }
            ++i2;
        }
        javaElements.addAll(allFragmentsToDelete);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i3 = 0;
        while (i3 < this.fResources.length) {
            IResource parent = this.fResources[i3];
            if (parent.getType() == 1) {
                parent = parent.getParent();
            }
            if (!deletedChildren.contains(parent)) {
                resources.add(this.fResources[i3]);
            }
            ++i3;
        }
        this.fJavaElements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        this.fResources = resources.toArray(new IResource[resources.size()]);
    }

    private boolean canRemoveCompletely(IPackageFragment pack, List packagesToDelete) throws JavaModelException {
        IPackageFragment[] subPackages = JavaElementUtil.getPackageAndSubpackages(pack);
        int i = 0;
        while (i < subPackages.length) {
            if (!subPackages[i].equals(pack) && !packagesToDelete.contains(subPackages[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addDeletableParentPackages(IPackageFragment frag, List initialPackagesToDelete, Set resourcesToDelete, List deletableParentPackages) throws CoreException {
        IConfirmQuery query;
        if (frag.getResource().isLinked() && !(query = this.fDeleteQueries.createYesNoQuery(RefactoringCoreMessages.JavaDeleteProcessor_confirm_linked_folder_delete, false, 8)).confirm(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_delete_linked_folder_question, new String[]{frag.getResource().getName()}))) {
            return;
        }
        IResource[] children = ((IContainer)frag.getResource()).members();
        int i = 0;
        while (i < children.length) {
            if (!resourcesToDelete.contains(children[i])) {
                return;
            }
            ++i;
        }
        resourcesToDelete.add(frag.getResource());
        deletableParentPackages.add(frag);
        IPackageFragment parent = JavaElementUtil.getParentSubpackage(frag);
        if (parent != null && !initialPackagesToDelete.contains(parent)) {
            this.addDeletableParentPackages(parent, initialPackagesToDelete, resourcesToDelete, deletableParentPackages);
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaModelException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_2;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        int i = 0;
        while (i < this.fResources.length) {
            IPackageFragmentRoot root;
            IJavaProject project;
            IResource resource = this.fResources[i];
            if (resource instanceof IFile && (project = JavaCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findPackageFragmentRoot(resource.getFullPath())) != null) {
                ArrayList<IJavaProject> referencingProjects = new ArrayList<IJavaProject>(1);
                referencingProjects.add(root.getJavaProject());
                referencingProjects.addAll((Collection)Arrays.asList(JavaElementUtil.getReferencingProjects(root)));
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    filesToSkip.add(resource);
                }
            }
            ++i;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> rootsToSkip = new ArrayList<IPackageFragmentRoot>(0);
        int i = 0;
        while (i < this.fJavaElements.length) {
            List<IJavaProject> referencingProjects;
            IPackageFragmentRoot root;
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot && JavaDeleteProcessor.skipDeletingReferencedRoot(query, root = (IPackageFragmentRoot)element, referencingProjects = Arrays.asList(JavaElementUtil.getReferencingProjects(root)))) {
                rootsToSkip.add(root);
            }
            ++i;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IJavaElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IPackageFragmentRoot root, List referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String question = Messages.format(RefactoringCoreMessages.DeleteRefactoring_3, root.getElementName());
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_4;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        int i = 0;
        while (i < this.fResources.length) {
            String question;
            IFolder folder;
            IResource resource = this.fResources[i];
            if (resource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = Messages.format(RefactoringCoreMessages.DeleteRefactoring_5, folder.getName()))) {
                foldersToSkip.add(folder);
            }
            ++i;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentUtil.getJavaElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentUtil.getJavaElements();
    }

    private IFile[] getClassPathFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IProject project;
            IFile classPathFile;
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot && (classPathFile = (project = element.getJavaProject().getProject()).getFile(".classpath")).exists()) {
                result.add(classPathFile);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        pm.done();
        return this.fDeleteChange;
    }

    private void addToSetToDelete(IJavaElement[] newElements) {
        this.fJavaElements = ReorgUtils.union(this.fJavaElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }

    private void addGettersSetters() throws JavaModelException {
        IField[] fields = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (fields.length == 0) {
            return;
        }
        Map getterSetterMapping = JavaDeleteProcessor.createGetterSetterMapping(fields);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(getterSetterMapping);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        List gettersSettersToAdd = this.getGettersSettersToDelete(getterSetterMapping);
        this.addToSetToDelete((IJavaElement[])gettersSettersToAdd.toArray(new IMethod[gettersSettersToAdd.size()]));
    }

    private List getGettersSettersToDelete(Map getterSetterMapping) {
        ArrayList<IMethod> gettersSettersToAdd = new ArrayList<IMethod>(getterSetterMapping.size());
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_8;
        IConfirmQuery getterSetterQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 1);
        for (IField field : getterSetterMapping.keySet()) {
            Assert.isTrue((JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field) ? 1 : 0) != 0);
            String deleteGetterSetter = Messages.format(RefactoringCoreMessages.DeleteRefactoring_9, JavaElementUtil.createFieldSignature(field));
            if (!getterSetterQuery.confirm(deleteGetterSetter)) continue;
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field)) {
                gettersSettersToAdd.add(JavaDeleteProcessor.getGetter(getterSetterMapping, field));
            }
            if (!JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            gettersSettersToAdd.add(JavaDeleteProcessor.getSetter(getterSetterMapping, field));
        }
        return gettersSettersToAdd;
    }

    private void removeAlreadySelectedMethods(Map getterSetterMapping) {
        List<IJavaElement> elementsToDelete = Arrays.asList(this.fJavaElements);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IMethod setter;
            IField field = (IField)iter.next();
            IMethod getter = JavaDeleteProcessor.getGetter(getterSetterMapping, field);
            if (getter != null && elementsToDelete.contains(getter)) {
                JavaDeleteProcessor.removeGetterFromMapping(getterSetterMapping, field);
            }
            if ((setter = JavaDeleteProcessor.getSetter(getterSetterMapping, field)) != null && elementsToDelete.contains(setter)) {
                JavaDeleteProcessor.removeSetterFromMapping(getterSetterMapping, field);
            }
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            iter.remove();
        }
    }

    private static Map createGetterSetterMapping(IField[] fields) throws JavaModelException {
        HashMap<IField, IMethod[]> result = new HashMap<IField, IMethod[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            IMethod[] getterSetter = JavaDeleteProcessor.getGetterSetter(field);
            if (getterSetter != null) {
                result.put(field, getterSetter);
            }
            ++i;
        }
        return result;
    }

    private static boolean hasSetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getSetter(getterSetterMapping, field) != null;
    }

    private static boolean hasGetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getGetter(getterSetterMapping, field) != null;
    }

    private static void removeGetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[0] = null;
    }

    private static void removeSetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[1] = null;
    }

    private static IMethod getGetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[0];
    }

    private static IMethod getSetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[1];
    }

    private static IField[] getFields(IJavaElement[] elements) {
        ArrayList<IJavaElement> fields = new ArrayList<IJavaElement>(3);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IField) {
                fields.add(elements[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IMethod[] getGetterSetter(IField field) throws JavaModelException {
        IMethod getter = GetterSetterUtil.getGetter(field);
        IMethod setter = GetterSetterUtil.getSetter(field);
        if (getter != null && getter.exists() || setter != null && setter.exists()) {
            return new IMethod[]{getter, setter};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaModelException {
        Set cusToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IJavaElement[])cusToEmpty.toArray(new ICompilationUnit[cusToEmpty.size()]));
    }

    private Set getCusToEmpty() throws JavaModelException {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu != null && !result.contains(cu) && this.willHaveAllTopLevelTypesDeleted(cu)) {
                result.add(cu);
            }
            ++i;
        }
        return result;
    }

    private boolean willHaveAllTopLevelTypesDeleted(ICompilationUnit cu) throws JavaModelException {
        HashSet elementSet = new HashSet(Arrays.asList(this.fJavaElements));
        IType[] topLevelTypes = cu.getTypes();
        int i = 0;
        while (i < topLevelTypes.length) {
            if (!elementSet.contains(topLevelTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

