/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory;
import org.eclipse.osgi.framework.internal.protocol.MultiplexingURLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.ProtocolActivator;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerProxy;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StreamHandlerFactory
extends MultiplexingFactory
implements URLStreamHandlerFactory {
    static final SecureAction secureAction = new SecureAction();
    private ServiceTracker handlerTracker;
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    protected static final String INTERNAL_PROTOCOL_HANDLER_PKG = "org.eclipse.osgi.framework.internal.protocol";
    private static final List ignoredClasses = Arrays.asList(MultiplexingURLStreamHandler.class, StreamHandlerFactory.class, URL.class);
    private Hashtable proxies = new Hashtable(15);
    private URLStreamHandlerFactory parentFactory;

    public StreamHandlerFactory(BundleContext context, FrameworkAdaptor adaptor) {
        super(context, adaptor);
        this.handlerTracker = new ServiceTracker(context, URLSTREAMHANDLERCLASS, null);
        this.handlerTracker.open();
    }

    private Class getBuiltIn(String protocol, String builtInHandlers) {
        if (builtInHandlers == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            StringBuffer name = new StringBuffer();
            name.append(tok.nextToken());
            name.append(".");
            name.append(protocol);
            name.append(".Handler");
            try {
                Class clazz = secureAction.forName(name.toString());
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        String builtInHandlers = secureAction.getProperty(PROTOCOL_HANDLER_PKGS);
        Class clazz = this.getBuiltIn(protocol, builtInHandlers);
        if (clazz != null) {
            return null;
        }
        URLStreamHandler result = null;
        if (this.isMultiplexing()) {
            if (this.findAuthorizedURLStreamHandler(protocol) != null) {
                result = new MultiplexingURLStreamHandler(protocol, this);
            }
        } else {
            result = this.createInternalURLStreamHandler(protocol);
        }
        if (result == null && this.parentFactory != null) {
            result = this.parentFactory.createURLStreamHandler(protocol);
        }
        return result;
    }

    public URLStreamHandler createInternalURLStreamHandler(String protocol) {
        String internalHandlerPkgs = secureAction.getProperty("equinox.interal.handler.pkgs");
        internalHandlerPkgs = internalHandlerPkgs == null ? INTERNAL_PROTOCOL_HANDLER_PKG : String.valueOf(internalHandlerPkgs) + '|' + INTERNAL_PROTOCOL_HANDLER_PKG;
        Class clazz = this.getBuiltIn(protocol, internalHandlerPkgs);
        if (clazz == null) {
            URLStreamHandlerProxy handler = (URLStreamHandlerProxy)this.proxies.get(protocol);
            if (handler != null) {
                return handler;
            }
            ServiceReference[] serviceReferences = this.handlerTracker.getServiceReferences();
            if (serviceReferences == null) {
                return null;
            }
            int i = 0;
            while (i < serviceReferences.length) {
                Object prop = serviceReferences[i].getProperty("url.handler.protocol");
                if (prop instanceof String[]) {
                    String[] protocols = (String[])prop;
                    int j = 0;
                    while (j < protocols.length) {
                        if (protocols[j].equals(protocol)) {
                            handler = new URLStreamHandlerProxy(protocol, serviceReferences[i], this.context);
                            this.proxies.put(protocol, handler);
                            return handler;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }
        try {
            URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
            if (handler instanceof ProtocolActivator) {
                ((ProtocolActivator)((Object)handler)).start(this.context, this.adaptor);
            }
            return handler;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected URLStreamHandler findAuthorizedURLStreamHandler(String protocol) {
        Object factory = this.findAuthorizedFactory(ignoredClasses);
        if (factory == null) {
            return null;
        }
        if (factory == this) {
            return this.createInternalURLStreamHandler(protocol);
        }
        try {
            Method createInternalURLStreamHandlerMethod = factory.getClass().getMethod("createInternalURLStreamHandler", String.class);
            return (URLStreamHandler)createInternalURLStreamHandlerMethod.invoke(factory, protocol);
        }
        catch (Exception e) {
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry(StreamHandlerFactory.class.getName(), "findAuthorizedURLStreamHandler-loop", 4, e, null));
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getParentFactory() {
        return this.parentFactory;
    }

    public void setParentFactory(Object parentFactory) {
        if (this.parentFactory == null) {
            this.parentFactory = (URLStreamHandlerFactory)parentFactory;
        }
    }
}

