/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpTransportFactory;
import org.apache.activemq.transport.https.HttpsClientTransport;
import org.apache.activemq.transport.https.HttpsTransportServer;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;

public class HttpsTransportFactory
extends HttpTransportFactory {
    public TransportServer doBind(String brokerId, URI location) throws IOException {
        return this.doBind(location);
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParameters((URI)location));
            HttpsTransportServer result = new HttpsTransportServer(location, this, SslContext.getCurrentSslContext());
            Map httpOptions = IntrospectionSupport.extractProperties(options, (String)"http.");
            Map transportOptions = IntrospectionSupport.extractProperties(options, (String)"transport.");
            result.setTransportOption(transportOptions);
            result.setHttpOptions(httpOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    @Override
    protected Transport createTransport(URI location, WireFormat wf) throws MalformedURLException {
        URI uri;
        try {
            uri = URISupport.removeQuery((URI)location);
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        return new HttpsClientTransport(this.asTextWireFormat(wf), uri);
    }
}

