/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.clock;

import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;

public class ClockUtils {
    public static Timespan toTimespan(Object t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Timespan) {
            return (Timespan)t;
        }
        return Timespan.parse(t.toString());
    }

    public static long toEndTime(Object timeout) {
        return ClockUtils.toEndTime(null, timeout);
    }

    public static long toEndTime(Clock clock, Object timeout) {
        Timespan t = ClockUtils.toTimespan(timeout);
        if (t == null) {
            return 0L;
        }
        if (clock == null) {
            clock = SystemClock.INSTANCE;
        }
        if (t.getDurationInMilliseconds() == 0L) {
            return 0L;
        }
        return t.futureTimeMillis(clock);
    }

    private ClockUtils() {
    }
}

