/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.MQTTWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.fusesource.mqtt.codec.MQTTFrame;

public abstract class AbstractMQTTSocket
extends TransportSupport
implements MQTTTransport,
BrokerServiceAware {
    protected volatile MQTTProtocolConverter protocolConverter = null;
    protected MQTTWireFormat wireFormat = new MQTTWireFormat();
    protected final MQTTInactivityMonitor mqttInactivityMonitor = new MQTTInactivityMonitor(this, this.wireFormat);
    protected final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    protected BrokerService brokerService;
    protected volatile int receiveCounter;
    protected final String remoteAddress;
    protected X509Certificate[] peerCertificates;

    public AbstractMQTTSocket(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            this.getProtocolConverter().onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        this.doConsume(command);
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.mqttInactivityMonitor.stop();
        this.handleStopped();
    }

    @Override
    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.mqttInactivityMonitor.setTransportListener(this.getTransportListener());
        this.mqttInactivityMonitor.startConnectChecker(this.wireFormat.getConnectAttemptTimeout());
    }

    @Override
    public abstract void sendToMQTT(MQTTFrame var1) throws IOException;

    public abstract void handleStopped() throws IOException;

    @Override
    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.mqttInactivityMonitor;
    }

    @Override
    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
        this.peerCertificates = certificates;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQTTProtocolConverter getProtocolConverter() {
        if (this.protocolConverter == null) {
            AbstractMQTTSocket abstractMQTTSocket = this;
            synchronized (abstractMQTTSocket) {
                if (this.protocolConverter == null) {
                    this.protocolConverter = new MQTTProtocolConverter(this, this.brokerService);
                }
            }
        }
        return this.protocolConverter;
    }

    protected boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }
}

