/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro;

import org.apache.activemq.ConfigurationException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.shiro.authc.AuthenticationFilter;
import org.apache.activemq.shiro.authc.AuthenticationPolicy;
import org.apache.activemq.shiro.authc.DefaultAuthenticationPolicy;
import org.apache.activemq.shiro.authz.AuthorizationFilter;
import org.apache.activemq.shiro.env.IniEnvironment;
import org.apache.activemq.shiro.subject.ConnectionSubjectFactory;
import org.apache.activemq.shiro.subject.DefaultConnectionSubjectFactory;
import org.apache.activemq.shiro.subject.SubjectFilter;
import org.apache.shiro.config.Ini;
import org.apache.shiro.env.Environment;
import org.apache.shiro.mgt.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroPlugin.class);
    private volatile boolean enabled = true;
    private Broker broker;
    private SecurityManager securityManager;
    private Environment environment;
    private IniEnvironment iniEnvironment = new IniEnvironment();
    private SubjectFilter subjectFilter;
    private AuthenticationFilter authenticationFilter;
    private AuthorizationFilter authorizationFilter = new AuthorizationFilter();

    public ShiroPlugin() {
        DefaultAuthenticationPolicy authcPolicy = new DefaultAuthenticationPolicy();
        this.authenticationFilter = new AuthenticationFilter();
        this.authenticationFilter.setAuthenticationPolicy(authcPolicy);
        this.authenticationFilter.setNext((Broker)this.authorizationFilter);
        this.subjectFilter = new SubjectFilter();
        DefaultConnectionSubjectFactory subjectFactory = new DefaultConnectionSubjectFactory();
        subjectFactory.setAuthenticationPolicy(authcPolicy);
        this.subjectFilter.setConnectionSubjectFactory(subjectFactory);
        this.subjectFilter.setNext((Broker)this.authenticationFilter);
    }

    public SubjectFilter getSubjectFilter() {
        return this.subjectFilter;
    }

    public void setSubjectFilter(SubjectFilter subjectFilter) {
        this.subjectFilter = subjectFilter;
        this.subjectFilter.setNext((Broker)this.authenticationFilter);
    }

    public AuthenticationFilter getAuthenticationFilter() {
        return this.authenticationFilter;
    }

    public void setAuthenticationFilter(AuthenticationFilter authenticationFilter) {
        this.authenticationFilter = authenticationFilter;
        this.authenticationFilter.setNext((Broker)this.authorizationFilter);
        this.subjectFilter.setNext((Broker)authenticationFilter);
    }

    public AuthorizationFilter getAuthorizationFilter() {
        return this.authorizationFilter;
    }

    public void setAuthorizationFilter(AuthorizationFilter authorizationFilter) {
        this.authorizationFilter = authorizationFilter;
        this.authorizationFilter.setNext(this.broker);
        this.authenticationFilter.setNext((Broker)authorizationFilter);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.isInstalled()) {
            this.applyEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (this.isInstalled()) {
            return this.getNext() == this.subjectFilter;
        }
        return this.enabled;
    }

    private void applyEnabled(boolean enabled) {
        if (enabled) {
            super.setNext((Broker)this.subjectFilter);
        } else {
            super.setNext(this.broker);
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void setIni(Ini ini) {
        this.iniEnvironment.setIni(ini);
    }

    public void setIniConfig(String iniConfig) {
        this.iniEnvironment.setIniConfig(iniConfig);
    }

    public void setIniResourcePath(String resourcePath) {
        this.iniEnvironment.setIniResourcePath(resourcePath);
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationFilter.setEnabled(authenticationEnabled);
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationFilter.isEnabled();
    }

    public AuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationFilter.getAuthenticationPolicy();
    }

    public void setAuthenticationPolicy(AuthenticationPolicy authenticationPolicy) {
        this.authenticationFilter.setAuthenticationPolicy(authenticationPolicy);
        ConnectionSubjectFactory factory = this.subjectFilter.getConnectionSubjectFactory();
        if (factory instanceof DefaultConnectionSubjectFactory) {
            ((DefaultConnectionSubjectFactory)factory).setAuthenticationPolicy(authenticationPolicy);
        }
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationFilter.setEnabled(authorizationEnabled);
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationFilter.isEnabled();
    }

    private Environment ensureEnvironment() throws ConfigurationException {
        if (this.environment != null) {
            return this.environment;
        }
        if (this.securityManager != null) {
            this.environment = new Environment(){

                public SecurityManager getSecurityManager() {
                    return ShiroPlugin.this.securityManager;
                }
            };
            return this.environment;
        }
        this.iniEnvironment.init();
        this.environment = this.iniEnvironment;
        return this.iniEnvironment;
    }

    public Broker installPlugin(Broker broker) throws Exception {
        Environment environment = this.ensureEnvironment();
        this.authorizationFilter.setEnvironment(environment);
        this.authenticationFilter.setEnvironment(environment);
        this.subjectFilter.setEnvironment(environment);
        this.broker = broker;
        this.authorizationFilter.setNext(broker);
        this.authenticationFilter.setNext((Broker)this.authorizationFilter);
        this.subjectFilter.setNext((Broker)this.authenticationFilter);
        SubjectFilter next = this.subjectFilter;
        if (!this.enabled) {
            next = broker;
        }
        this.setNext((Broker)next);
        return this;
    }

    private boolean isInstalled() {
        return this.getNext() != null;
    }
}

