/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.WeakHashMap;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ListCellBehavior
extends CellBehaviorBase<ListCell> {
    private static final WeakHashMap<ListView, Integer> map = new WeakHashMap();
    private boolean latePress = false;
    private final boolean isEmbedded = PlatformUtil.isEmbedded();
    private boolean wasSelected = false;

    static int getAnchor(ListView listView) {
        FocusModel focusModel = listView.getFocusModel();
        if (focusModel == null) {
            return -1;
        }
        return ListCellBehavior.hasAnchor(listView) ? map.get(listView).intValue() : focusModel.getFocusedIndex();
    }

    static void setAnchor(ListView listView, int n) {
        if (listView != null && n < 0) {
            map.remove(listView);
        } else {
            map.put(listView, n);
        }
    }

    static boolean hasAnchor(ListView listView) {
        return map.containsKey(listView) && map.get(listView) != -1;
    }

    public ListCellBehavior(ListCell listCell) {
        super(listCell);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = ((ListCell)this.getControl()).isSelected();
        if (((ListCell)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (this.isEmbedded && bl) {
            this.wasSelected = ((ListCell)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        if (this.isEmbedded && !this.wasSelected && ((ListCell)this.getControl()).isSelected()) {
            ((ListCell)this.getControl()).getListView().getSelectionModel().clearSelection(((ListCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        int n;
        ListCell listCell = (ListCell)this.getControl();
        ListView listView = ((ListCell)this.getControl()).getListView();
        if (listView == null) {
            return;
        }
        if (listCell.isEmpty() || !listCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (!listCell.isEmpty() || platformLogger.isLoggable(900)) {
                // empty if block
            }
            return;
        }
        int n2 = n = listView.getItems() == null ? 0 : listView.getItems().size();
        if (listCell.getIndex() >= n) {
            return;
        }
        int n3 = listCell.getIndex();
        boolean bl = listCell.isSelected();
        MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = listView.getFocusModel();
        if (focusModel == null) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!map.containsKey(listView)) {
                ListCellBehavior.setAnchor(listView, focusModel.getFocusedIndex());
            }
        } else {
            map.remove(listView);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (multipleSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    multipleSelectionModel.clearSelection(n3);
                    focusModel.focus(n3);
                } else {
                    multipleSelectionModel.select(n3);
                }
            } else if (mouseEvent.isShiftDown()) {
                int n4 = ListCellBehavior.getAnchor(listView);
                int n5 = Math.min(n4, n3);
                int n6 = Math.max(n4, n3);
                multipleSelectionModel.clearSelection();
                multipleSelectionModel.selectRange(n5, n6 + 1);
                focusModel.focus(n3);
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        ListView listView = ((ListCell)this.getControl()).getListView();
        int n = ((ListCell)this.getControl()).getIndex();
        MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
        boolean bl = multipleSelectionModel.isSelected(n);
        listView.getSelectionModel().clearAndSelect(n);
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                listView.edit(n);
            } else if (mouseEvent.getClickCount() == 1) {
                listView.edit(-1);
            } else if (mouseEvent.getClickCount() == 2 && ((ListCell)this.getControl()).isEditable()) {
                listView.edit(n);
            }
        }
    }
}

