/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.Date;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.HistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public abstract class AbstractHistoryReferencesTableEntry
implements HistoryReferencesTableEntry {
    private static final Object[] PLACE_HOLDER_VALUES = new Object[HistoryReferencesTableModel.Column.values().length];
    private static final String EMPTY_STRING = "";
    private static final String STRING_VALUE_NOT_LOADED = "...";
    private static final Date EMPTY_DATE = new Date(0L);
    private final HistoryReference historyReference;

    public AbstractHistoryReferencesTableEntry(HistoryReference historyReference) {
        this.historyReference = historyReference;
    }

    @Override
    public HistoryReference getHistoryReference() {
        return this.historyReference;
    }

    public Integer getHistoryId() {
        return 0;
    }

    public Integer getHistoryType() {
        return -1;
    }

    public Long getSessionId() {
        return 0L;
    }

    public String getMethod() {
        return EMPTY_STRING;
    }

    public String getUri() {
        return EMPTY_STRING;
    }

    public Integer getStatusCode() {
        return 0;
    }

    public String getReason() {
        return EMPTY_STRING;
    }

    public Date getRequestTimestamp() {
        return EMPTY_DATE;
    }

    public Date getResponseTimestamp() {
        return EMPTY_DATE;
    }

    public Integer getRtt() {
        return 0;
    }

    public Long getMessageSize() {
        return 0L;
    }

    public Integer getRequestHeaderSize() {
        return 0;
    }

    public Integer getRequestBodySize() {
        return 0;
    }

    public Integer getResponseHeaderSize() {
        return 0;
    }

    public Integer getResponseBodySize() {
        return 0;
    }

    public AlertRiskTableCellItem getHighestAlert() {
        return AlertRiskTableCellItem.NO_RISK_CELL_ITEM;
    }

    public Boolean hasNote() {
        return Boolean.FALSE;
    }

    public String getTags() {
        return EMPTY_STRING;
    }

    @Override
    public Object getValue(HistoryReferencesTableModel.Column column) {
        switch (column) {
            case HREF_ID: {
                return this.getHistoryId();
            }
            case REQUEST_TIMESTAMP: {
                return this.getRequestTimestamp();
            }
            case RESPONSE_TIMESTAMP: {
                return this.getResponseTimestamp();
            }
            case HREF_TYPE: {
                return this.getHistoryType();
            }
            case METHOD: {
                return this.getMethod();
            }
            case URL: {
                return this.getUri();
            }
            case STATUS_CODE: {
                return this.getStatusCode();
            }
            case STATUS_REASON: {
                return this.getReason();
            }
            case RTT: {
                return this.getRtt();
            }
            case SIZE_MESSAGE: {
                return this.getMessageSize();
            }
            case SIZE_REQUEST_HEADER: {
                return this.getRequestHeaderSize();
            }
            case SIZE_REQUEST_BODY: {
                return this.getRequestBodySize();
            }
            case SIZE_RESPONSE_HEADER: {
                return this.getResponseHeaderSize();
            }
            case SIZE_RESPONSE_BODY: {
                return this.getResponseBodySize();
            }
            case SESSION_ID: {
                return this.getSessionId();
            }
            case HIGHEST_ALERT: {
                return this.getHighestAlert();
            }
            case NOTE: {
                return this.hasNote();
            }
            case TAGS: {
                return this.getTags();
            }
            case CUSTOM: {
                return null;
            }
        }
        return EMPTY_STRING;
    }

    public static Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        switch (column) {
            case HREF_ID: {
                return 1000;
            }
            case REQUEST_TIMESTAMP: {
                return new Date(System.currentTimeMillis());
            }
            case RESPONSE_TIMESTAMP: {
                return new Date(System.currentTimeMillis());
            }
            case HREF_TYPE: {
                return Integer.toString(0);
            }
            case METHOD: {
                return "GET";
            }
            case URL: {
                return "http://example.com/some/path?param=value";
            }
            case STATUS_CODE: {
                return 200;
            }
            case STATUS_REASON: {
                return "Not Found";
            }
            case RTT: {
                return 1000;
            }
            case SIZE_MESSAGE: 
            case SIZE_REQUEST_HEADER: 
            case SIZE_REQUEST_BODY: 
            case SIZE_RESPONSE_HEADER: 
            case SIZE_RESPONSE_BODY: {
                return 1000;
            }
            case SESSION_ID: {
                return System.currentTimeMillis();
            }
            case HIGHEST_ALERT: {
                return AlertRiskTableCellItem.getItemForRisk(2);
            }
            case NOTE: {
                return Boolean.FALSE;
            }
            case TAGS: {
                return "Tag1, Tag2, Tag3";
            }
            case CUSTOM: {
                return null;
            }
        }
        return EMPTY_STRING;
    }

    public static Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        switch (column) {
            case HREF_ID: {
                return Integer.class;
            }
            case REQUEST_TIMESTAMP: {
                return Date.class;
            }
            case RESPONSE_TIMESTAMP: {
                return Date.class;
            }
            case HREF_TYPE: {
                return Integer.class;
            }
            case METHOD: {
                return String.class;
            }
            case URL: {
                return String.class;
            }
            case STATUS_CODE: {
                return Integer.class;
            }
            case STATUS_REASON: {
                return String.class;
            }
            case RTT: {
                return Integer.class;
            }
            case SIZE_MESSAGE: 
            case SIZE_REQUEST_HEADER: 
            case SIZE_REQUEST_BODY: 
            case SIZE_RESPONSE_HEADER: 
            case SIZE_RESPONSE_BODY: {
                return Integer.class;
            }
            case SESSION_ID: {
                return Long.class;
            }
            case HIGHEST_ALERT: {
                return AlertRiskTableCellItem.class;
            }
            case NOTE: {
                return Boolean.class;
            }
            case TAGS: {
                return String.class;
            }
            case CUSTOM: {
                return null;
            }
        }
        return String.class;
    }

    public static Object getPlaceHolderValue(HistoryReferencesTableModel.Column column) {
        return PLACE_HOLDER_VALUES[column.ordinal()];
    }

    static {
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.HREF_ID.ordinal()] = Integer.toString(0);
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP.ordinal()] = EMPTY_DATE;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP.ordinal()] = EMPTY_DATE;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.HREF_TYPE.ordinal()] = Integer.toString(0);
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.METHOD.ordinal()] = STRING_VALUE_NOT_LOADED;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.URL.ordinal()] = STRING_VALUE_NOT_LOADED;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.STATUS_CODE.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.STATUS_REASON.ordinal()] = STRING_VALUE_NOT_LOADED;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.RTT.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SIZE_MESSAGE.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY.ordinal()] = 0;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.SESSION_ID.ordinal()] = 0L;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.HIGHEST_ALERT.ordinal()] = AlertRiskTableCellItem.NO_RISK_CELL_ITEM;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.NOTE.ordinal()] = Boolean.FALSE;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.TAGS.ordinal()] = EMPTY_STRING;
        AbstractHistoryReferencesTableEntry.PLACE_HOLDER_VALUES[HistoryReferencesTableModel.Column.CUSTOM.ordinal()] = null;
    }
}

