/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfGroups;
import de.escape.quincunx.gimmicks.Utility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class DedicatedDxfFileInputStream {
    private static final byte[] binDxfTag;
    private static final byte[] shxTag;
    private static final int BUFFER_SIZE = 65536;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_DXF = 1;
    public static final int TYPE_SHX = 2;
    public static final int TYPE_ZIP = 16;
    public static final int TYPE_GZIP = 32;
    public static final int TYPE_PACKED = 48;
    public static final int TYPE_BINARY = 128;
    static final int[] typeLen;
    protected int pos;
    protected long markpos = -1L;
    protected byte[] buffer = new byte[65536];
    protected long bufpos;
    protected int bufused;
    protected int filetype = 0;
    protected long fileLength = -1L;
    private char[] linebuf = new char[256];
    private int lines;
    private InputStream iStream;
    private DxfStreamReader reader;

    private void init(InputStream is) throws DxfException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(256);
        try {
            try {
                ZipInputStream zip = new ZipInputStream(is);
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    throw new ZipException();
                }
                this.fileLength = entry.getSize();
                this.iStream = zip;
                this.filetype |= 0x10;
            }
            catch (ZipException z) {
                is.reset();
                is.mark(256);
                try {
                    this.iStream = new GZIPInputStream(is);
                    this.fileLength = -1L;
                    this.filetype |= 0x20;
                }
                catch (IOException io) {
                    is.reset();
                    this.iStream = is;
                }
            }
            this.byteAvailable();
            this.mark(binDxfTag.length);
            byte[] tag = new byte[binDxfTag.length];
            this.read(tag);
            if (Utility.equalBytes(tag, 0, binDxfTag, 0, binDxfTag.length)) {
                this.filetype |= 0x81;
            } else {
                this.reset();
                this.mark(shxTag.length);
                tag = new byte[shxTag.length];
                this.read(tag);
                if (Utility.equalBytes(tag, 0, shxTag, 0, shxTag.length)) {
                    this.filetype |= 0x82;
                } else {
                    this.reset();
                    this.filetype |= 1;
                }
            }
        }
        catch (IOException iox) {
            throw new DxfException("err!IO", new String[]{"[input stream]", iox.getMessage()});
        }
        if ((this.filetype & 0x80) != 0) {
            this.reader = new BinaryDxfStreamReader();
            this.filetype |= 0x80;
        } else {
            this.reader = new AsciiDxfStreamReader();
        }
    }

    public DedicatedDxfFileInputStream(String fileName) throws DxfException {
        try {
            File file = new File(fileName);
            this.fileLength = file.length();
            this.init(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DxfException("err!FileNotFound", new String[]{fileName});
        }
    }

    public DedicatedDxfFileInputStream(InputStream is) throws DxfException {
        this.init(is);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.iStream != null) {
                this.iStream.close();
                this.iStream = null;
            }
        }
        catch (Exception exception) {}
    }

    private final boolean byteAvailable() throws IOException {
        if (this.pos < this.bufused) {
            return true;
        }
        if (this.bufused == -1) {
            return false;
        }
        this.bufpos += (long)this.bufused;
        this.bufused = this.iStream.read(this.buffer);
        this.pos = 0;
        return this.bufused != -1;
    }

    protected byte read() throws IOException, DxfException {
        if (!this.byteAvailable()) {
            throw new DxfException("err!EOF", new String[]{String.valueOf(this.lines)});
        }
        return this.buffer[this.pos++];
    }

    String byteToString(byte[] buf, int off, int len) {
        if (len > this.linebuf.length) {
            this.linebuf = new char[2 * len];
        }
        int i = 0;
        while (i < len) {
            int b = buf[off + i];
            this.linebuf[i] = (char)(b < 0 ? b + 256 : b);
            ++i;
        }
        return new String(this.linebuf, 0, len);
    }

    protected int read(byte[] b) throws IOException, DxfException {
        return this.read(b, 0, b.length);
    }

    protected int read(byte[] cbuf, int off, int len) throws IOException, DxfException {
        if (!this.byteAvailable()) {
            throw new DxfException("err!EOF", new String[]{String.valueOf(this.lines)});
        }
        if (len < this.bufused - this.pos) {
            System.arraycopy(this.buffer, this.pos, cbuf, off, len);
            this.pos += len;
            return len;
        }
        int rest = this.bufused - this.pos;
        System.arraycopy(this.buffer, this.pos, cbuf, off, rest);
        this.bufpos += (long)this.bufused;
        this.bufused = 0;
        this.pos = 0;
        int chunk = this.iStream.read(cbuf, off + rest, len - rest);
        if (chunk >= 0) {
            this.bufpos += (long)chunk;
            return rest + chunk;
        }
        this.bufused = -1;
        return rest;
    }

    String readLine() throws IOException, DxfException {
        int b = 0;
        int start = this.pos;
        while (this.pos < this.bufused && (b = this.buffer[this.pos]) != 10 && b != 13) {
            ++this.pos;
        }
        if (b == 10 || b == 13) {
            ++this.pos;
            String ret = this.byteToString(this.buffer, start, this.pos - start - 1);
            try {
                byte c = this.read();
                if (c + b != 23 && this.pos > 0) {
                    --this.pos;
                }
            }
            catch (DxfException dxfException) {}
            return ret;
        }
        if (this.pos - start > 0) {
            String ret = this.byteToString(this.buffer, start, this.pos - start);
            if (this.byteAvailable()) {
                return String.valueOf(ret) + this.readLine();
            }
            return ret;
        }
        if (!this.byteAvailable()) {
            return null;
        }
        return this.readLine();
    }

    protected long skip(long n) throws IOException {
        if (n < (long)(this.bufused - this.pos)) {
            this.pos += (int)n;
            return n;
        }
        int rest = this.bufused - this.pos;
        this.bufused = 0;
        this.pos = 0;
        long skipped = this.iStream.skip(n -= (long)rest);
        this.bufpos += skipped;
        return (long)rest + skipped;
    }

    synchronized void mark(int readlimit) {
        if (readlimit >= this.bufused - this.pos) {
            this.iStream.mark(readlimit);
        }
        this.markpos = this.bufpos + (long)this.pos;
    }

    synchronized void reset() throws IOException {
        if (this.markpos < this.bufpos) {
            this.iStream.reset();
            this.bufused = 0;
        }
        this.pos = (int)(this.markpos - this.bufpos);
    }

    long getFilePointer() {
        return this.bufpos + (long)this.pos;
    }

    long getFileLength() {
        return this.fileLength;
    }

    int getLines() {
        return this.lines;
    }

    String getString() throws DxfException {
        return this.reader.getStringData();
    }

    float getFloat() throws DxfException {
        return (float)this.reader.getDoubleData();
    }

    int getInt() throws DxfException {
        return this.reader.getIntData();
    }

    short getColor() throws DxfException {
        return (short)this.reader.getIntData();
    }

    short read2Lines() throws NumberFormatException, IOException, DxfException {
        return this.reader.readChunk();
    }

    boolean isBinary() {
        return (this.filetype & 0x80) != 0;
    }

    int getType() {
        return this.filetype;
    }

    static /* synthetic */ DxfStreamReader access$2(DedicatedDxfFileInputStream $0) {
        return $0.reader;
    }

    static {
        byte[] byArray = new byte[22];
        byArray[0] = 65;
        byArray[1] = 117;
        byArray[2] = 116;
        byArray[3] = 111;
        byArray[4] = 67;
        byArray[5] = 65;
        byArray[6] = 68;
        byArray[7] = 32;
        byArray[8] = 66;
        byArray[9] = 105;
        byArray[10] = 110;
        byArray[11] = 97;
        byArray[12] = 114;
        byArray[13] = 121;
        byArray[14] = 32;
        byArray[15] = 68;
        byArray[16] = 88;
        byArray[17] = 70;
        byArray[18] = 13;
        byArray[19] = 10;
        byArray[20] = 26;
        binDxfTag = byArray;
        byte[] byArray2 = new byte[25];
        byArray2[0] = 65;
        byArray2[1] = 117;
        byArray2[2] = 116;
        byArray2[3] = 111;
        byArray2[4] = 67;
        byArray2[5] = 65;
        byArray2[6] = 68;
        byArray2[7] = 45;
        byArray2[8] = 56;
        byArray2[9] = 54;
        byArray2[10] = 32;
        byArray2[11] = 115;
        byArray2[12] = 104;
        byArray2[13] = 97;
        byArray2[14] = 112;
        byArray2[15] = 101;
        byArray2[16] = 115;
        byArray2[17] = 32;
        byArray2[18] = 49;
        byArray2[19] = 46;
        byArray2[20] = 48;
        byArray2[21] = 13;
        byArray2[22] = 10;
        byArray2[23] = 26;
        shxTag = byArray2;
        int[] nArray = new int[7];
        nArray[0] = -1;
        nArray[2] = 2;
        nArray[3] = 8;
        nArray[4] = 2;
        nArray[6] = 4;
        typeLen = nArray;
    }

    private abstract class DxfStreamReader {
        protected short group;

        abstract short readChunk() throws NumberFormatException, IOException, DxfException;

        short getGroup() {
            return this.group;
        }

        abstract String getStringData() throws DxfException;

        abstract int getIntData() throws DxfException;

        abstract double getDoubleData() throws DxfException;

        abstract byte[] getByteArrayData() throws DxfException;

        abstract int getLongIntData() throws DxfException;

        DxfStreamReader() {
            DedicatedDxfFileInputStream.this = DedicatedDxfFileInputStream.this;
        }
    }

    private class AsciiDxfStreamReader
    extends DxfStreamReader {
        protected String value;

        private short readGroupLine() throws IOException, NumberFormatException, DxfException {
            byte b;
            int ret = 0;
            while ((b = DedicatedDxfFileInputStream.this.read()) == 32 || b == 9) {
            }
            if (b < 48 || b > 57) {
                if (b == -1) {
                    throw new DxfException("err!EOF", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
                }
                throw new NumberFormatException();
            }
            do {
                ret = 10 * ret + (b - 48);
            } while ((b = DedicatedDxfFileInputStream.this.read()) >= 48 && b <= 57);
            while (b == 32 || b == 9) {
                b = DedicatedDxfFileInputStream.this.read();
            }
            if (b == 10 || b == 13) {
                if (b + DedicatedDxfFileInputStream.this.read() != 23) {
                    --DedicatedDxfFileInputStream.this.pos;
                }
            } else {
                throw new NumberFormatException();
            }
            if (ret > Short.MAX_VALUE) {
                throw new NumberFormatException();
            }
            return (short)ret;
        }

        short readChunk() throws NumberFormatException, IOException, DxfException {
            DedicatedDxfFileInputStream dedicatedDxfFileInputStream = DedicatedDxfFileInputStream.this;
            dedicatedDxfFileInputStream.lines = dedicatedDxfFileInputStream.lines + 1;
            this.group = this.readGroupLine();
            DedicatedDxfFileInputStream dedicatedDxfFileInputStream2 = DedicatedDxfFileInputStream.this;
            dedicatedDxfFileInputStream2.lines = dedicatedDxfFileInputStream2.lines + 1;
            this.value = DedicatedDxfFileInputStream.this.readLine();
            return this.group;
        }

        String getStringData() throws DxfException {
            if (DxfGroups.type(this.group) == 1) {
                return this.value;
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        double getDoubleData() throws DxfException {
            if (DxfGroups.type(this.group) == 3) {
                try {
                    return Double.valueOf(this.value.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        AlternativAsciiDxfStreamReader ar = new AlternativAsciiDxfStreamReader();
                        ar.group = this.group;
                        ar.value = this.value;
                        double value = ar.getDoubleData();
                        DedicatedDxfFileInputStream.this.reader = ar;
                        return value;
                    }
                    catch (DxfException dxfException) {
                        throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
                    }
                }
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        int getIntData() throws DxfException {
            switch (DxfGroups.type(this.group)) {
                case 2: 
                case 4: 
                case 6: {
                    return Integer.parseInt(this.value.trim());
                }
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        byte[] getByteArrayData() throws DxfException {
            throw new DxfException("AsciiDxfStreamReader.getByteArrayData(): Not yet implemented!");
        }

        int getLongIntData() throws DxfException {
            if (DxfGroups.type(this.group) == 6) {
                return Integer.parseInt(this.value.trim());
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        AsciiDxfStreamReader() {
            DedicatedDxfFileInputStream.this = DedicatedDxfFileInputStream.this;
        }
    }

    private class AlternativAsciiDxfStreamReader
    extends AsciiDxfStreamReader {
        private NumberFormat format = NumberFormat.getNumberInstance(Locale.GERMAN);

        double getDoubleData() throws DxfException {
            if (DxfGroups.type(this.group) == 3) {
                try {
                    return this.format.parse(this.value.trim()).doubleValue();
                }
                catch (ParseException parseException) {
                    throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
                }
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        AlternativAsciiDxfStreamReader() {
            DedicatedDxfFileInputStream.this = DedicatedDxfFileInputStream.this;
        }
    }

    private class BinaryDxfStreamReader
    extends DxfStreamReader {
        private byte[] value = new byte[256];
        private byte[] groupNumberBytes = new byte[2];
        private int length;
        private boolean shortGroups = false;

        BinaryDxfStreamReader() throws DxfException {
            DedicatedDxfFileInputStream.this = DedicatedDxfFileInputStream.this;
            DedicatedDxfFileInputStream.this.mark(2);
            try {
                byte b1 = DedicatedDxfFileInputStream.this.read();
                byte b2 = DedicatedDxfFileInputStream.this.read();
                if (b1 != 0) {
                    throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
                }
                this.shortGroups = b2 == 0;
                DedicatedDxfFileInputStream.this.reset();
            }
            catch (IOException iOException) {}
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        short readChunk() throws NumberFormatException, IOException, DxfException {
            byte b;
            DedicatedDxfFileInputStream dedicatedDxfFileInputStream = DedicatedDxfFileInputStream.this;
            dedicatedDxfFileInputStream.lines = dedicatedDxfFileInputStream.lines + 1;
            if (this.shortGroups) {
                DedicatedDxfFileInputStream.this.read(this.groupNumberBytes);
                this.group = (short)(this.unsignedShort(this.groupNumberBytes[1]) << 8 | this.unsignedShort(this.groupNumberBytes[0]));
            } else {
                b = DedicatedDxfFileInputStream.this.read();
                if (b == -1) {
                    DedicatedDxfFileInputStream.this.read(this.groupNumberBytes);
                    this.group = (short)(this.unsignedShort(this.groupNumberBytes[1]) << 8 | this.unsignedShort(this.groupNumberBytes[0]));
                } else {
                    this.group = this.unsignedShort(b);
                }
            }
            DedicatedDxfFileInputStream dedicatedDxfFileInputStream2 = DedicatedDxfFileInputStream.this;
            dedicatedDxfFileInputStream2.lines = dedicatedDxfFileInputStream2.lines + 1;
            byte type = DxfGroups.type(this.group);
            this.length = typeLen[type];
            if (this.length > 0) {
                DedicatedDxfFileInputStream.this.read(this.value, 0, this.length);
                return this.group;
            } else {
                if (this.length != 0) throw new DxfException("err!Group", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines - 1)});
                if (type == 1) {
                    int i = 0;
                    while ((b = DedicatedDxfFileInputStream.this.read()) != 0) {
                        this.value[i++] = b;
                    }
                    this.length = i;
                    return this.group;
                } else {
                    if (type != 5) throw new DxfException("err!Group", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines - 1)});
                    this.length = DedicatedDxfFileInputStream.this.read();
                    DedicatedDxfFileInputStream.this.read(this.value, 0, this.length);
                }
            }
            return this.group;
        }

        String getStringData() throws DxfException {
            if (DxfGroups.type(this.group) == 1) {
                return DedicatedDxfFileInputStream.this.byteToString(this.value, 0, this.length);
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        private final long unsignedLong(byte b) {
            long l = b;
            return l >= 0L ? l : l + 256L;
        }

        private final int unsignedInt(byte b) {
            int i = b;
            return i >= 0 ? i : i + 256;
        }

        private final short unsignedShort(byte b) {
            short s = b;
            return s >= 0 ? s : (short)(s + 256);
        }

        double getDoubleData() throws DxfException {
            if (DxfGroups.type(this.group) == 3) {
                long dummy = this.unsignedLong(this.value[7]) << 56 | this.unsignedLong(this.value[6]) << 48 | this.unsignedLong(this.value[5]) << 40 | this.unsignedLong(this.value[4]) << 32 | this.unsignedLong(this.value[3]) << 24 | this.unsignedLong(this.value[2]) << 16 | this.unsignedLong(this.value[1]) << 8 | this.unsignedLong(this.value[0]);
                return Double.longBitsToDouble(dummy);
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        int getIntData() throws DxfException {
            switch (DxfGroups.type(this.group)) {
                case 2: 
                case 4: 
                case 6: {
                    return this.unsignedInt(this.value[1]) << 8 | this.unsignedInt(this.value[0]);
                }
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }

        byte[] getByteArrayData() throws DxfException {
            byte[] ret = new byte[this.length];
            int i = this.length - 1;
            while (i >= 0) {
                ret[i] = this.value[i];
                --i;
            }
            return ret;
        }

        int getLongIntData() throws DxfException {
            if (DxfGroups.type(this.group) == 6) {
                int ret = this.unsignedInt(this.value[3]) << 24 | this.unsignedInt(this.value[2]) << 16 | this.unsignedInt(this.value[1]) << 8 | this.unsignedInt(this.value[0]);
                return ret;
            }
            throw new DxfException("err!Format", new String[]{String.valueOf(DedicatedDxfFileInputStream.this.lines)});
        }
    }
}

