/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.ServerRecord;

public final class ServerUpdateCache {
    private List<ServerRecord> hosts = null;
    private ServerRecord defaultRecord = null;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");

    public synchronized List<ServerRecord> getHosts() {
        List<ServerRecord> h = this.hosts;
        if (h == null) {
            throw new IllegalStateException("hosts should not be null");
        }
        return new ArrayList<ServerRecord>(this.hosts);
    }

    public synchronized void setHosts(Collection<? extends ServerRecord> newHosts) {
        this.hosts = new ArrayList<ServerRecord>(newHosts);
        this.fixDefaultRecordIfNeed();
    }

    private void fixDefaultRecordIfNeed() {
        if (!(this.defaultRecord != null && this.hosts.contains(this.defaultRecord) || this.hosts.isEmpty())) {
            this.defaultRecord = this.hosts.get(0);
        }
    }

    public synchronized ServerRecord getDefaultRecord() {
        this.fixDefaultRecordIfNeed();
        return this.defaultRecord;
    }

    public synchronized void setDefaultRecord(ServerRecord record) {
        assert (this.hosts.contains(record));
        this.defaultRecord = record;
    }
}

