/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.openide.util.NbBundle;

public abstract class MoveAction
extends AbstractAction
implements ActionContext {
    public static final String DISPLAY_NAME_MOVE_UP = NbBundle.getMessage(MoveAction.class, (String)"NAME_MoveUpAction");
    public static final String DISPLAY_NAME_MOVE_DOWN = NbBundle.getMessage(MoveAction.class, (String)"NAME_MoveDownAction");
    public static final String PROPERTY_NAME_REFERENCE = "propertyName";
    private WeakReference<DesignComponent> component;
    private boolean isEnabled;
    private String arrayPropertyName;
    private TypeID newArrayTypeID;

    public static final Action createMoveUpAction(String arrayPropertyName) {
        return new MoveAction(arrayPropertyName, DISPLAY_NAME_MOVE_UP){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control U"));
            }

            @Override
            protected void invokeMoveAction(List<PropertyValue> array, List<PropertyValue> newArray, PropertyValue currentValue) {
                int index = array.indexOf(currentValue);
                if (index != 0) {
                    newArray.remove(currentValue);
                    newArray.add(index - 1, currentValue);
                    this.saveToModel(newArray);
                }
            }
        };
    }

    public static final Action createMoveDownAction(String arrayPropertyName) {
        return new MoveAction(arrayPropertyName, DISPLAY_NAME_MOVE_DOWN){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
            }

            @Override
            protected void invokeMoveAction(List<PropertyValue> array, List<PropertyValue> newArray, PropertyValue currentValue) {
                int index = array.indexOf(currentValue);
                int minIndex = array.size() - index;
                if (minIndex > 1) {
                    newArray.remove(currentValue);
                    newArray.add(index + 1, currentValue);
                    this.saveToModel(newArray);
                }
            }
        };
    }

    private MoveAction(String arrayPropertyName, String displayName) {
        this.putValue("Name", displayName);
        this.arrayPropertyName = arrayPropertyName;
    }

    protected DesignComponent getComponent() {
        return (DesignComponent)this.component.get();
    }

    @Override
    public boolean isEnabled() {
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (((DesignComponent)MoveAction.this.component.get()).getDocument().getSelectedComponents().size() > 1) {
                    MoveAction.this.isEnabled = false;
                } else {
                    MoveAction.this.isEnabled = true;
                }
            }
        });
        return this.isEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                PropertyValue arrayPropertyValue = MoveAction.this.getComponent().getParentComponent().readProperty(MoveAction.this.getArrayPropertyName());
                List<PropertyValue> array = arrayPropertyValue.getArray();
                MoveAction.this.newArrayTypeID = arrayPropertyValue.getType().getComponentType();
                if (array.size() < 1) {
                    return;
                }
                ArrayList<PropertyValue> newArray = new ArrayList<PropertyValue>(array);
                for (PropertyValue value : array) {
                    if (value.getComponent() != MoveAction.this.getComponent()) continue;
                    MoveAction.this.invokeMoveAction(array, newArray, value);
                }
            }
        });
    }

    protected abstract void invokeMoveAction(List<PropertyValue> var1, List<PropertyValue> var2, PropertyValue var3);

    protected TypeID getNewArrayType() {
        return this.newArrayTypeID;
    }

    @Override
    public void setComponent(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
    }

    private String getArrayPropertyName() {
        return this.arrayPropertyName;
    }

    protected void saveToModel(List<PropertyValue> newArray) {
        DesignComponent parentComponent = this.getComponent().getParentComponent();
        parentComponent.writeProperty(this.getArrayPropertyName(), PropertyValue.createArray(this.getNewArrayType(), newArray));
    }
}

