/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.openide.util.ImageUtilities;

public final class InfoPresenter
extends DynamicPresenter {
    private Resolver resolver;
    private String cachedPrimary;
    private String cachedSecondary;
    private String cachedTertiary;
    private Image cached16;
    private Image cached32;
    private Image cached48;
    private Image cached64;

    public static InfoPresenter create(Resolver resolver) {
        return new InfoPresenter(resolver);
    }

    private InfoPresenter(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    protected void notifyAttached(DesignComponent component) {
    }

    @Override
    protected void notifyDetached(DesignComponent component) {
    }

    @Override
    protected DesignEventFilter getEventFilter() {
        return this.resolver.getEventFilter(this.getComponent());
    }

    @Override
    protected void designChanged(DesignEvent event) {
        this.cachedTertiary = null;
        this.cachedSecondary = null;
        this.cachedPrimary = null;
        this.cached64 = null;
        this.cached48 = null;
        this.cached32 = null;
        this.cached16 = null;
        this.firePresenterChanged();
    }

    @Override
    protected void presenterChanged(PresenterEvent event) {
    }

    public String getDisplayName(NameType nameType) {
        switch (nameType) {
            case PRIMARY: {
                if (this.cachedPrimary == null) {
                    this.cachedPrimary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedPrimary;
            }
            case SECONDARY: {
                if (this.cachedSecondary == null) {
                    this.cachedSecondary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedSecondary;
            }
            case TERTIARY: {
                if (this.cachedTertiary == null) {
                    this.cachedTertiary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedTertiary;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isEditable() {
        return this.resolver.isEditable(this.getComponent());
    }

    public String getEditableName() {
        return this.resolver.getEditableName(this.getComponent());
    }

    public void setEditableName(String enteredName) {
        this.resolver.setEditableName(this.getComponent(), enteredName);
    }

    public Image getIcon(IconType iconType) {
        switch (iconType) {
            case COLOR_16x16: {
                if (this.cached16 == null) {
                    this.cached16 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached16;
            }
            case COLOR_32x32: {
                if (this.cached32 == null) {
                    this.cached32 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached32;
            }
            case COLOR_48x48: {
                if (this.cached48 == null) {
                    this.cached48 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached48;
            }
            case COLOR_64x64: {
                if (this.cached64 == null) {
                    this.cached64 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached64;
            }
        }
        throw new IllegalStateException();
    }

    public static InfoPresenter createStatic(String displayName, String typeName, String iconResource) {
        return InfoPresenter.createStatic(displayName, typeName, null, iconResource);
    }

    public static InfoPresenter createStatic(String displayName, String typeName, String toolTip, String iconResource) {
        return InfoPresenter.createStatic(displayName, typeName, toolTip, ImageUtilities.loadImage((String)iconResource));
    }

    public static InfoPresenter createStatic(final String displayName, final String typeName, final String toolTip, final Image icon) {
        return new InfoPresenter(new Resolver(){

            @Override
            public DesignEventFilter getEventFilter(DesignComponent component) {
                return null;
            }

            @Override
            public String getDisplayName(DesignComponent component, NameType nameType) {
                switch (nameType) {
                    case PRIMARY: {
                        return displayName;
                    }
                    case SECONDARY: {
                        return typeName;
                    }
                    case TERTIARY: {
                        return toolTip;
                    }
                }
                throw Debug.illegalState(new Object[0]);
            }

            @Override
            public boolean isEditable(DesignComponent component) {
                return false;
            }

            @Override
            public String getEditableName(DesignComponent component) {
                throw new IllegalStateException();
            }

            @Override
            public void setEditableName(DesignComponent component, String enteredName) {
                throw new IllegalStateException();
            }

            @Override
            public Image getIcon(DesignComponent component, IconType iconType) {
                return IconType.COLOR_16x16.equals((Object)iconType) ? icon : null;
            }
        });
    }

    public static String getHtmlDisplayName(DesignComponent component) {
        InfoPresenter presenter = component.getPresenter(InfoPresenter.class);
        if (presenter == null) {
            Debug.warning("Missing InfoPresenter for: ", component);
            return null;
        }
        String primary = presenter.getDisplayName(NameType.PRIMARY);
        String secondary = presenter.getDisplayName(NameType.SECONDARY);
        return secondary != null ? primary + " <font color=\"#808080\">[" + secondary + "]" : primary;
    }

    public static String getDisplayName(DesignComponent component) {
        InfoPresenter presenter = component.getPresenter(InfoPresenter.class);
        if (presenter == null) {
            Debug.warning("Missing InfoPresenter for: ", component);
            return null;
        }
        String primary = presenter.getDisplayName(NameType.PRIMARY);
        String secondary = presenter.getDisplayName(NameType.SECONDARY);
        return secondary != null ? primary + " [" + secondary + "]" : primary;
    }

    public static String getToolTip(DesignComponent component) {
        InfoPresenter presenter = component.getPresenter(InfoPresenter.class);
        if (presenter == null) {
            Debug.warning("Missing InfoPresenter for: ", component);
            return null;
        }
        return InfoPresenter.getToolTip(presenter);
    }

    public static String getToolTip(InfoPresenter presenter) {
        String text = presenter.getDisplayName(NameType.TERTIARY);
        if (text != null) {
            return text;
        }
        return presenter.getDisplayName(NameType.SECONDARY);
    }

    public static interface Resolver {
        public DesignEventFilter getEventFilter(DesignComponent var1);

        public String getDisplayName(DesignComponent var1, NameType var2);

        public boolean isEditable(DesignComponent var1);

        public String getEditableName(DesignComponent var1);

        public void setEditableName(DesignComponent var1, String var2);

        public Image getIcon(DesignComponent var1, IconType var2);
    }

    public static enum IconType {
        COLOR_16x16,
        COLOR_32x32,
        COLOR_48x48,
        COLOR_64x64;

    }

    public static enum NameType {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

