/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rubyproject.RakeParameters;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;

public final class Migrations {
    private static final Logger LOGGER = Logger.getLogger(Migrations.class.getName());
    private static final Pattern SEQ_PATTERN = Pattern.compile("^\\d\\d\\d_.*");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*");
    private static final List<String> MIGRATE_TASKS = Arrays.asList("db:migrate", "db:migrate:down", "db:migrate:up");

    private Migrations() {
    }

    static boolean isMigrateTask(RakeTask task) {
        if (task == null) {
            return false;
        }
        return MIGRATE_TASKS.contains(task.getTask());
    }

    public static List<Migration> getMigrations(Project project) {
        FileObject projectDir = project.getProjectDirectory();
        FileObject migrate = projectDir.getFileObject("db/migrate");
        if (migrate == null) {
            return Collections.emptyList();
        }
        ArrayList<Migration> result = new ArrayList<Migration>();
        for (FileObject fo : migrate.getChildren()) {
            String name = fo.getName();
            if (!fo.getMIMEType().equals("text/x-ruby")) continue;
            Long version = Migrations.getMigrationVersion(name);
            String description = Migrations.getMigrationDescription(name);
            if (version != null && description != null) {
                result.add(new Migration(version, description));
                continue;
            }
            LOGGER.finer("Could not parse version and description for: " + name);
        }
        Collections.sort(result);
        return result;
    }

    private static boolean isSequentialMigration(String name) {
        return SEQ_PATTERN.matcher(name).matches();
    }

    private static boolean isTimestampMigration(String name) {
        return TIMESTAMP_PATTERN.matcher(name).matches();
    }

    public static Long getMigrationVersion(String name) {
        if (Migrations.isSequentialMigration(name)) {
            return Long.parseLong(name.substring(0, 3));
        }
        if (Migrations.isTimestampMigration(name)) {
            return Long.parseLong(name.substring(0, 14));
        }
        return null;
    }

    public static String getMigrationDescription(String name) {
        if (Migrations.isSequentialMigration(name)) {
            return RubyUtils.underlinedNameToCamel((String)name.substring(4));
        }
        if (Migrations.isTimestampMigration(name)) {
            return RubyUtils.underlinedNameToCamel((String)name.substring(15));
        }
        return null;
    }

    public static class Migration
    implements RakeParameters.RakeParameter,
    Comparable<Migration> {
        private final Long version;
        private final String description;

        public Migration(Long version, String description) {
            this.version = version;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getVersion() {
            return this.version;
        }

        @Override
        public String toRakeParam() {
            return "VERSION=" + this.getVersion();
        }

        private String getDisplayName() {
            return this.toRakeParam() + " (" + this.getDescription() + ")";
        }

        @Override
        public int compareTo(Migration o) {
            return this.getVersion().compareTo(o.getVersion());
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

