/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support.dragging;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;

public final class DraggingSupport
extends MouseAdapter
implements MouseMotionListener {
    private final JComponent component;
    private final List<Draggable> draggables;
    private Draggable currentDraggable;

    public DraggingSupport(JComponent component, List<Draggable> marks) {
        this.component = component;
        this.draggables = Collections.unmodifiableList(new ArrayList<Draggable>(marks));
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(component);
    }

    private Draggable findDraggable(Point p) {
        for (Draggable mark : this.draggables) {
            if (!mark.containsPoint(p)) continue;
            return mark;
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Draggable draggableUnderCursor = this.findDraggable(e.getPoint());
        this.component.setCursor(draggableUnderCursor == null ? Cursor.getDefaultCursor() : draggableUnderCursor.getCursor());
        this.component.setToolTipText(draggableUnderCursor == null ? null : draggableUnderCursor.getTooltip());
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentDraggable != null) {
            this.currentDraggable.dragTo(e.getPoint(), true);
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.currentDraggable == null) {
            this.currentDraggable = this.findDraggable(e.getPoint());
            if (this.currentDraggable != null) {
                this.currentDraggable.startDragging(e.getPoint());
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.currentDraggable != null) {
            this.currentDraggable.dragTo(e.getPoint(), false);
            this.currentDraggable.finishDragging();
            this.currentDraggable = null;
            e.consume();
        }
    }
}

