/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class WhenNode
extends Node {
    private final Node expressionNodes;
    private final Node bodyNode;
    private final Node nextCase;

    public WhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        super(position, NodeType.WHENNODE);
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime.getNil();
        }
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }
}

