/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

public class RefactoringUtils {
    public static Program getRoot(ParserResult info) {
        return info instanceof PHPParseResult ? ((PHPParseResult)info).getProgram() : null;
    }

    public static Source getSource(Document doc) {
        Source source = Source.create((Document)doc);
        return source;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(FileObject fo) {
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return RefactoringUtils.findCloneableEditorSupport(dob);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static String htmlize(String input) {
        try {
            return XMLUtil.toElementContent((String)input);
        }
        catch (CharConversionException cce) {
            Exceptions.printStackTrace((Throwable)cce);
            return input;
        }
    }

    public static String getHtml(String text) {
        StringBuffer buf = new StringBuffer();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)PHPTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-php5"));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = token.id().name();
            AttributeSet set = settings.getTokenFontColors(category);
            if (set == null) {
                category = token.id().primaryCategory();
                if (category == null) {
                    category = "whitespace";
                }
                set = settings.getTokenFontColors(category);
            }
            String tokenText = RefactoringUtils.htmlize(((Object)token.text()).toString());
            buf.append(RefactoringUtils.color(tokenText, set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + RefactoringUtils.getHTMLColor(StyleConstants.getForeground(set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (!p.equals(opened[i]) && !opened[i].equals(p)) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fo) {
        FileObject f;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp != null && (f = cp.findOwnerRoot(fo)) != null) {
            return fo.equals(f);
        }
        return false;
    }

    public static boolean isRefactorable(FileObject file) {
        return FileUtils.isPhpFile((FileObject)file) && RefactoringUtils.isFileInOpenProject(file) && RefactoringUtils.isOnSourceClasspath(file);
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return RefactoringUtils.getPackageName(fo);
                }
                String prefix = RefactoringUtils.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1)) + suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    public static FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = new File(url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    public static boolean isOutsidePhp(Lookup lookup, FileObject fo) {
        EditorCookie ec;
        if (FileUtils.isPhpFile((FileObject)fo) && RefactoringUtils.isFromEditor(ec = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            Document d = textC.getDocument();
            if (!(d instanceof BaseDocument)) {
                return true;
            }
            int caret = textC.getCaretPosition();
            return LexUtilities.getMostEmbeddedTokenSequence((Document)d, (int)caret, (boolean)true).language() != PHPTokenId.language();
        }
        return false;
    }

    static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static List<ASTNode> underCaret(ParserResult info, final int offset) {
        class Result
        extends Error {
            private Stack<ASTNode> result;

            public Result(Stack<ASTNode> result) {
                this.result = result;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
        try {
            new DefaultVisitor(){
                private Stack<ASTNode> s = new Stack();

                public void scan(ASTNode node) {
                    if (node == null) {
                        return;
                    }
                    if (node.getStartOffset() <= offset && offset <= node.getEndOffset()) {
                        this.s.push(node);
                        super.scan(node);
                        throw new Result(this.s);
                    }
                }
            }.scan((ASTNode)RefactoringUtils.getRoot(info));
        }
        catch (Result r) {
            return new LinkedList<ASTNode>(r.result);
        }
        return Collections.emptyList();
    }

    public static boolean isQuoted(String value) {
        return !(value.length() < 2 || !value.startsWith("\"") && !value.startsWith("'") || !value.endsWith("\"") && !value.endsWith("'"));
    }

    public static String dequote(String value) {
        assert (RefactoringUtils.isQuoted(value));
        return value.substring(1, value.length() - 1);
    }

    public static FileObject resolveInclude(ParserResult info, Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return RefactoringUtils.resolveRelativeFile(info, fileName);
        }
        return null;
    }

    private static FileObject resolveRelativeFile(ParserResult info, String name) {
        PhpSourcePath psp = null;
        Project p = FileOwnerQuery.getOwner((FileObject)info.getSnapshot().getSource().getFileObject());
        if (p != null) {
            psp = (PhpSourcePath)p.getLookup().lookup(PhpSourcePath.class);
        }
        while (true) {
            FileObject result = psp != null ? PhpSourcePath.resolveFile((FileObject)info.getSnapshot().getSource().getFileObject().getParent(), (String)name) : info.getSnapshot().getSource().getFileObject().getParent().getFileObject(name);
            if (result != null) {
                return result;
            }
            int slash = name.indexOf(47);
            if (slash == -1) break;
            name = name.substring(slash + 1);
        }
        return null;
    }

    public static FileObject getFile(Document doc) {
        Object o = doc.getProperty("stream");
        if (o instanceof DataObject) {
            DataObject od = (DataObject)o;
            return od.getPrimaryFile();
        }
        return null;
    }
}

