/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class IOUtils {
    public static void runInAWTNoBlocking(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public static void runInAWTBlocking(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (InvocationTargetException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public static JComponent createLoadingPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel(NbBundle.getMessage(IOUtils.class, (String)"DISP_LoadingDocument"));
        label.setFont(new Font("Dialog", label.getFont().getStyle() | 1, label.getFont().getSize() + 5));
        Color background = panel.getBackground();
        Color foreground = background.darker();
        if (foreground.equals(background)) {
            foreground = background.brighter();
        }
        label.setForeground(foreground);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(16, 16, 16, 16), 0, 0));
        return panel;
    }
}

