/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.netbeans.modules.db.explorer.dlg.CreateTableDialog;
import org.netbeans.modules.db.explorer.dlg.TypeElement;

public class ColumnItem
extends Hashtable {
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String SIZE = "size";
    public static final String SCALE = "scale";
    public static final String PRIMARY_KEY = "pkey";
    public static final String INDEX = "idx";
    public static final String NULLABLE = "nullable";
    public static final String DEFVAL = "defval";
    public static final String UNIQUE = "unique";
    public static final String CHECK = "check";
    public static final String CHECK_CODE = "checkcode";
    private PropertyChangeSupport propertySupport;
    static final long serialVersionUID = -6638535249384813829L;

    public static final Map getColumnProperty(int idx) {
        return (Map)ColumnItem.getProperties().elementAt(idx);
    }

    public static final Vector getProperties() {
        return (Vector)CreateTableDialog.getProperties().get("columns");
    }

    public static final Vector getProperties(String pname) {
        Vector vec = ColumnItem.getProperties();
        Vector cnames = new Vector(vec.size());
        Enumeration evec = vec.elements();
        while (evec.hasMoreElements()) {
            Map pmap = (Map)evec.nextElement();
            cnames.add(pmap.get(pname));
        }
        return cnames;
    }

    public static final Vector getColumnNames() {
        return ColumnItem.getProperties(NAME);
    }

    public static final Vector getColumnTitles() {
        return ColumnItem.getProperties("columntitle");
    }

    public static final Vector getColumnClasses() {
        return ColumnItem.getProperties("columnclass");
    }

    public ColumnItem() {
        Vector vec = ColumnItem.getProperties();
        Enumeration evec = vec.elements();
        this.propertySupport = new PropertyChangeSupport(this);
        while (evec.hasMoreElements()) {
            Map pmap = (Map)evec.nextElement();
            Object pdv = pmap.get("default");
            if (pdv == null) continue;
            String pclass = (String)pmap.get("columnclass");
            if (pclass.equals("java.lang.Boolean")) {
                pdv = Boolean.valueOf((String)pdv);
            }
            this.put(pmap.get(NAME), pdv);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public Object getProperty(String pname) {
        return this.get(pname);
    }

    public void setProperty(String pname, Object value) {
        if (pname == null) {
            return;
        }
        Object old = this.get(pname);
        if (old != null) {
            Class<?> oldc = old.getClass();
            if (old.equals(value)) {
                return;
            }
            try {
                if (!oldc.equals(value.getClass()) && oldc.equals(Integer.class)) {
                    value = "".equals((String)value) ? new Integer(0) : Integer.valueOf((String)value);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.put(pname, value);
        this.propertySupport.firePropertyChange(pname, old, value);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public TypeElement getType() {
        return (TypeElement)this.get(TYPE);
    }

    public int getSize() {
        Object size = this.get(SIZE);
        if (size instanceof String) {
            if ("".equals(size)) {
                size = "0";
            }
            return Integer.valueOf((String)size);
        }
        return (Integer)size;
    }

    public boolean isPrimaryKey() {
        Boolean val = (Boolean)this.get(PRIMARY_KEY);
        if (val != null) {
            return val;
        }
        return false;
    }

    public boolean isUnique() {
        Boolean val = (Boolean)this.get(UNIQUE);
        if (val != null) {
            return val;
        }
        return false;
    }

    public boolean isIndexed() {
        Boolean val = (Boolean)this.get(INDEX);
        if (val != null) {
            return val;
        }
        return false;
    }

    public boolean allowsNull() {
        Boolean val = (Boolean)this.get(NULLABLE);
        if (val != null) {
            return val;
        }
        return false;
    }

    public boolean hasCheckConstraint() {
        Boolean val = (Boolean)this.get(CHECK);
        if (val != null) {
            return val;
        }
        return false;
    }

    public String getCheckConstraint() {
        return (String)this.get(CHECK_CODE);
    }

    public boolean hasDefaultValue() {
        String dv = this.getDefaultValue();
        return dv != null && dv.length() > 0;
    }

    public String getDefaultValue() {
        return (String)this.get(DEFVAL);
    }

    public int getScale() {
        return (Integer)this.get(SCALE);
    }
}

