/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class JschSupport {
    private static final int JSCH_CONNECTION_TIMEOUT = Integer.getInteger("jsch.connection.timeout", 10000);
    private static final java.util.logging.Logger log = Logger.getInstance();

    private JschSupport() {
    }

    public static ChannelStreams startCommand(final ExecutionEnvironment env, final String command, final ChannelParams params) throws IOException, JSchException {
        JSchWorker<ChannelStreams> worker = new JSchWorker<ChannelStreams>(){

            @Override
            public ChannelStreams call() throws JSchException, IOException {
                Session session = ConnectionManagerAccessor.getDefault().getConnectionSession(env, true);
                ChannelExec echannel = (ChannelExec)session.openChannel("exec");
                echannel.setCommand(command);
                echannel.setXForwarding(params == null ? false : params.x11forward);
                echannel.connect(JSCH_CONNECTION_TIMEOUT);
                return new ChannelStreams((Channel)echannel, echannel.getInputStream(), echannel.getErrStream(), echannel.getOutputStream());
            }

            public String toString() {
                return command;
            }
        };
        return JschSupport.start(worker, env, 2);
    }

    public static ChannelStreams startLoginShellSession(final ExecutionEnvironment env) throws IOException, JSchException {
        JSchWorker<ChannelStreams> worker = new JSchWorker<ChannelStreams>(){

            @Override
            public ChannelStreams call() throws JSchException, IOException {
                Session session = ConnectionManagerAccessor.getDefault().getConnectionSession(env, true);
                ChannelShell shell = (ChannelShell)session.openChannel("shell");
                shell.setPty(false);
                shell.connect(JSCH_CONNECTION_TIMEOUT);
                return new ChannelStreams((Channel)shell, shell.getInputStream(), new ByteArrayInputStream(new byte[0]), shell.getOutputStream());
            }

            public String toString() {
                return "shell session for " + env.getDisplayName();
            }
        };
        return JschSupport.start(worker, env, 2);
    }

    private static ChannelStreams start(JSchWorker<ChannelStreams> worker, ExecutionEnvironment env, int attempts) throws IOException, JSchException {
        int retry = attempts;
        while (retry-- > 0) {
            try {
                return worker.call();
            }
            catch (JSchException ex) {
                String message = ex.getMessage();
                Throwable cause = ex.getCause();
                if (cause != null && cause instanceof NullPointerException) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Retrying", ex);
                    continue;
                }
                if ("java.io.InterruptedIOException".equals(message)) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Retrying in 0.5 seconds", ex);
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex1) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if ("channel is not opened.".equals(message)) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Reconnecting and retrying", ex);
                    ConnectionManagerAccessor.getDefault().reconnect(env);
                    continue;
                }
                throw ex;
            }
            catch (NullPointerException npe) {
                log.log(Level.FINE, "Exception from JSch", npe);
            }
        }
        throw new IOException("Failed to execute " + worker.toString());
    }

    private static interface JSchWorker<T> {
        public T call() throws JSchException, IOException;
    }

    public static final class ChannelParams {
        private boolean x11forward = false;

        public void setX11Forwarding(boolean forward) {
            this.x11forward = forward;
        }
    }

    public static final class ChannelStreams {
        public final InputStream out;
        public final InputStream err;
        public final OutputStream in;
        public final Channel channel;

        public ChannelStreams(Channel channel, InputStream out, InputStream err, OutputStream in) {
            this.channel = channel;
            this.out = out;
            this.err = err;
            this.in = in;
        }
    }
}

