/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.samples.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class RestSampleUtils {
    public static final String JERSEY_LIBRARY = "restlib";
    public static String[] xlateFiles = new String[]{"build-impl.xml", "project.xml", "project.properties", "AssemblyInformation.xml"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream source, FileObject rootFolder) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)rootFolder, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)rootFolder, (String)entry.getName());
                FileLock lock = fo.lock();
                try {
                    OutputStream out = fo.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)str, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            source.close();
        }
    }

    public static void setProjectName(FileObject prjLoc, String projTypeName, String name) {
        try {
            File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
            Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
            NodeList nlist = doc.getElementsByTagNameNS(projTypeName, "name");
            if (nlist != null) {
                for (int i = 0; i < nlist.getLength(); ++i) {
                    Node n = nlist.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    RestSampleUtils.replaceText(e, name);
                }
                RestSampleUtils.saveXml(doc, prjLoc, "nbproject/project.xml");
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

