/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.WLModuleNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class WLModuleChildFactory
extends ChildFactory<WLModuleNode>
implements RefreshModulesCookie {
    private static final Logger LOGGER = Logger.getLogger(WLModuleChildFactory.class.getName());
    private final Lookup lookup;
    private final ModuleType moduleType;

    public WLModuleChildFactory(Lookup lookup, ModuleType moduleType) {
        this.lookup = lookup;
        this.moduleType = moduleType;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    protected Node createNodeForKey(WLModuleNode wLModuleNode) {
        return wLModuleNode;
    }

    protected boolean createKeys(List<WLModuleNode> list) {
        WLDeploymentManager wLDeploymentManager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        try {
            TargetModuleID[] targetModuleIDArray = wLDeploymentManager.getAvailableModules(this.moduleType, wLDeploymentManager.getTargets());
            TargetModuleID[] targetModuleIDArray2 = wLDeploymentManager.getNonRunningModules(this.moduleType, wLDeploymentManager.getTargets());
            HashSet<String> hashSet = new HashSet<String>();
            if (targetModuleIDArray2 != null) {
                for (TargetModuleID targetModuleID : targetModuleIDArray2) {
                    hashSet.add(targetModuleID.getModuleID());
                }
            }
            if (targetModuleIDArray != null) {
                for (TargetModuleID targetModuleID : targetModuleIDArray) {
                    list.add(new WLModuleNode(targetModuleID, this.lookup, this.moduleType, hashSet.contains(targetModuleID.getModuleID())));
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.log(Level.INFO, null, illegalStateException);
        }
        catch (TargetException targetException) {
            LOGGER.log(Level.INFO, null, targetException);
        }
        return true;
    }
}

