/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.ProgressMonitor;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.DispatchData;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class Controller {
    static final String REPLAY = "netbeans.replay";
    static final String PORT = "netbeans.replay.port";
    static final String REPLAYSTATUS = "netbeans.replay.status";
    static final String REPLAYSESSION = "netbeans.replay.session";
    static final boolean debug = false;
    private static transient String server = "localhost";
    private static transient int port = 8080;
    private static FileObject monDir = null;
    private static FileObject currDir = null;
    private static FileObject saveDir = null;
    private static FileObject replayDir = null;
    static final String monDirStr = "HTTPMonitor";
    static final String currDirStr = "current";
    static final String saveDirStr = "save";
    static final String replayDirStr = "replay";
    private transient NavigateNode root = null;
    private Children.SortedArray currTrans = null;
    private Children.SortedArray savedTrans = null;
    private Hashtable currBeans = null;
    private Hashtable saveBeans = null;
    private transient Comparator comp = null;
    private boolean useBrowserCookie = true;
    private static Controller instance = null;
    private Date startDate = new Date(System.currentTimeMillis() - 30000L);

    private Controller() {
        this.currBeans = new Hashtable();
        this.saveBeans = new Hashtable();
        this.createNodeStructure();
    }

    static Controller getInstance() {
        if (instance == null) {
            instance = new Controller();
        }
        return instance;
    }

    private void createNodeStructure() {
        this.comp = new CompTime(true);
        this.currTrans = new Children.SortedArray();
        this.currTrans.setComparator(this.comp);
        this.savedTrans = new Children.SortedArray();
        this.savedTrans.setComparator(this.comp);
        CurrNode currNode = new CurrNode((Children)this.currTrans);
        SavedNode savedNode = new SavedNode((Children)this.savedTrans);
        Node[] kids = new Node[]{currNode, savedNode};
        Children.Array children = new Children.Array();
        children.add(kids);
        this.root = new NavigateNode((Children)children);
    }

    void addTransaction(String id) {
        TransactionNode[] nodes = new TransactionNode[1];
        MonitorData md = this.retrieveMonitorData(id, currDirStr);
        try {
            nodes[0] = this.createTransactionNode(md, true);
            this.currTrans.add((Node[])nodes);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected NavigateNode getRoot() {
        return this.root;
    }

    protected static FileObject getMonDir() throws FileNotFoundException {
        if (monDir == null || !monDir.isFolder()) {
            Controller.createDirectories();
        }
        return monDir;
    }

    protected static FileObject getCurrDir() throws FileNotFoundException {
        if (currDir == null || !currDir.isFolder()) {
            Controller.createDirectories();
        }
        return currDir;
    }

    protected static FileObject getReplayDir() throws FileNotFoundException {
        if (replayDir == null || !replayDir.isFolder()) {
            Controller.createDirectories();
        }
        return replayDir;
    }

    protected static FileObject getSaveDir() throws FileNotFoundException {
        if (saveDir == null || !saveDir.isFolder()) {
            Controller.createDirectories();
        }
        return saveDir;
    }

    boolean haveDirectories() {
        if (currDir == null) {
            try {
                currDir = Controller.getCurrDir();
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (saveDir == null) {
            try {
                saveDir = Controller.getSaveDir();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private static void createDirectories() throws FileNotFoundException {
        FileObject rootdir = FileUtil.getConfigRoot();
        FileLock lock = null;
        if (monDir == null || !monDir.isFolder()) {
            try {
                monDir = rootdir.getFileObject(monDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (monDir == null || !monDir.isFolder()) {
                if (monDir != null) {
                    try {
                        lock = monDir.lock();
                        monDir.delete(lock);
                    }
                    catch (FileAlreadyLockedException falex) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException ex) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                try {
                    monDir = rootdir.createFolder(monDirStr);
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            if (monDir == null || !monDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (currDir == null || !currDir.isFolder()) {
            try {
                currDir = monDir.getFileObject(currDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (currDir == null || !currDir.isFolder()) {
                lock = null;
                if (currDir != null) {
                    try {
                        lock = currDir.lock();
                        currDir.delete(lock);
                    }
                    catch (FileAlreadyLockedException falex) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException ex) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                try {
                    currDir = monDir.createFolder(currDirStr);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (currDir == null || !currDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (saveDir == null || !saveDir.isFolder()) {
            try {
                saveDir = monDir.getFileObject(saveDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (saveDir == null || !saveDir.isFolder()) {
                if (saveDir != null) {
                    lock = null;
                    try {
                        lock = saveDir.lock();
                        saveDir.delete(lock);
                    }
                    catch (FileAlreadyLockedException falex) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException ex) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                try {
                    saveDir = monDir.createFolder(saveDirStr);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (saveDir == null || !saveDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (replayDir == null || !replayDir.isFolder()) {
            try {
                replayDir = monDir.getFileObject(replayDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (replayDir == null || !replayDir.isFolder()) {
                if (replayDir != null) {
                    lock = null;
                    try {
                        lock = replayDir.lock();
                        replayDir.delete(lock);
                    }
                    catch (FileAlreadyLockedException falex) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException ex) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                try {
                    replayDir = monDir.createFolder(replayDirStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (replayDir == null || !replayDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
    }

    void replayTransaction(Node node) {
        if (!this.checkServer(true)) {
            return;
        }
        TransactionNode tn = null;
        try {
            tn = (TransactionNode)node;
        }
        catch (ClassCastException cce) {
            return;
        }
        MonitorData md = this.getMonitorData(tn, false, false);
        if (md == null) {
            String msg = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
            Logger.getLogger("global").log(Level.INFO, msg);
            return;
        }
        if (!this.useBrowserCookie) {
            md.getRequestData().setReplaceSessionCookie(true);
        }
        String status = tn.isCurrent() ? currDirStr : saveDirStr;
        try {
            this.replayTransaction(md, status);
        }
        catch (UnknownHostException uhe) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)NbBundle.getMessage((Class)Controller.class, (String)"MON_Exec_server_no_host", (Object)md.getServerName()), NbBundle.getBundle((Class)Controller.class).getString("MON_Exec_server"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
        }
        catch (IOException ioe) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)NbBundle.getMessage((Class)Controller.class, (String)"MON_Exec_server_start", (Object)md.getServerAndPort()), NbBundle.getBundle((Class)Controller.class).getString("MON_Exec_server"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
        }
    }

    void replayTransaction(MonitorData md) throws UnknownHostException, IOException {
        FileObject fo;
        FileLock lock = null;
        OutputStream out = null;
        PrintWriter pw = null;
        String id = md.getAttributeValue("id");
        try {
            fo = Controller.getReplayDir().createData(id, "xml");
        }
        catch (IOException ioex) {
            try {
                fo = Controller.getReplayDir().getFileObject(id, "xml");
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException("No replay dir");
            }
            if (!fo.isData()) {
                throw new IOException("Can't create file, giving up");
            }
            try {
                lock = fo.lock();
            }
            catch (FileAlreadyLockedException falex) {
                throw new IOException("Old file exist, islocked");
            }
            try {
                fo.delete(lock);
            }
            catch (IOException ioex2) {
                throw new IOException("Couldn't delete old file");
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            fo = Controller.getReplayDir().createData(id, "xml");
        }
        try {
            lock = fo.lock();
        }
        catch (FileAlreadyLockedException fale) {
            throw new IOException();
        }
        try {
            out = fo.getOutputStream(lock);
            pw = new PrintWriter(out);
            md.write(pw);
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            try {
                pw.close();
            }
            catch (Throwable t) {}
            try {
                out.close();
            }
            catch (Throwable t) {}
        }
        try {
            this.replayTransaction(md, replayDirStr);
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    void replayTransaction(MonitorData md, String status) throws UnknownHostException, IOException {
        URL url = null;
        try {
            String name = md.getServerName();
            int port = md.getServerPort();
            StringBuffer uriBuf = new StringBuffer(128);
            uriBuf.append(md.getRequestData().getAttributeValue("uri"));
            uriBuf.append("?");
            uriBuf.append(REPLAY);
            uriBuf.append("=");
            uriBuf.append(md.getAttributeValue("id"));
            uriBuf.append("&");
            uriBuf.append(REPLAYSTATUS);
            uriBuf.append("=");
            uriBuf.append(status);
            String portS = null;
            try {
                URL u = Controller.getSampleHTTPServerURL();
                portS = String.valueOf(u.getPort());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (portS != null) {
                uriBuf.append("&");
                uriBuf.append(PORT);
                uriBuf.append("=");
                uriBuf.append(portS);
            }
            if (md.getRequestData().getReplaceSessionCookie()) {
                uriBuf.append("&");
                uriBuf.append(REPLAYSESSION);
                uriBuf.append("=");
                uriBuf.append(md.getRequestData().getSessionID());
            }
            url = new URL("http", name, port, uriBuf.toString());
        }
        catch (MalformedURLException me) {
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            this.showReplay(url);
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTransaction(Node[] nodes) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Node[] newNodes = new Node[nodes.length];
        boolean error = false;
        for (int i = 0; i < nodes.length; ++i) {
            TransactionNode mvNode = (TransactionNode)nodes[i];
            String id = mvNode.getID();
            if (this.currBeans.containsKey(id)) {
                this.saveBeans.put(id, this.currBeans.remove(id));
            }
            FileLock lock = null;
            try {
                FileObject fold = currDir.getFileObject(id, "xml");
                lock = fold.lock();
                fold.copy(saveDir, id, "xml");
                fold.delete(lock);
                mvNode.setCurrent(false);
                newNodes[i] = mvNode;
                continue;
            }
            catch (FileAlreadyLockedException falex) {
                error = true;
                continue;
            }
            catch (IOException ioex) {
                error = true;
                continue;
            }
            catch (Exception ex) {
                error = true;
                continue;
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        if (!error) {
            this.currTrans.remove(nodes);
        }
        this.savedTrans.add(newNodes);
    }

    void deleteTransaction(final Node[] nodes) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        if (nodes == null || nodes.length == 0) {
            return;
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.yield();
                Controller.this.currTrans.remove(nodes);
                Controller.this.savedTrans.remove(nodes);
                int oldValue = 0;
                for (int i = 0; i < nodes.length; ++i) {
                    int newValue;
                    String id;
                    TransactionNode node = (TransactionNode)nodes[i];
                    FileObject fileObject = null;
                    if (node.isCurrent()) {
                        id = node.getID();
                        fileObject = currDir.getFileObject(id, "xml");
                        Controller.this.currBeans.remove(id);
                    } else {
                        id = node.getID();
                        fileObject = saveDir.getFileObject(id, "xml");
                        Controller.this.saveBeans.remove(id);
                    }
                    if (fileObject != null) {
                        FileLock lock = null;
                        try {
                            lock = fileObject.lock();
                            fileObject.delete(lock);
                        }
                        catch (FileAlreadyLockedException falex) {
                            Logger.getLogger("global").log(Level.INFO, null, falex);
                        }
                        catch (IOException exception) {
                            Logger.getLogger("global").log(Level.INFO, null, exception);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                    if ((newValue = 100 * (i + 1) / nodes.length) <= oldValue) continue;
                    oldValue = newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressMonitor.setValue(newValue);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressMonitor.close();
                    }
                });
            }
        });
        progressMonitor.setVisible(true);
    }

    void deleteDirectory(String dir) {
        FileObject directory;
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        if (dir.equals(saveDirStr)) {
            directory = saveDir;
            this.savedTrans.remove(this.savedTrans.getNodes());
            this.saveBeans.clear();
        } else {
            directory = currDir;
            this.currTrans.remove(this.currTrans.getNodes());
            this.currBeans.clear();
        }
        if (directory.getChildren().length == 0) {
            return;
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.yield();
                int number = directory.getChildren().length;
                int oldValue = -1;
                int i = 0;
                Enumeration e = directory.getData(false);
                while (e.hasMoreElements()) {
                    FileObject fo = (FileObject)e.nextElement();
                    FileLock lock = null;
                    try {
                        lock = fo.lock();
                        fo.delete(lock);
                    }
                    catch (FileAlreadyLockedException falex) {
                        Logger.getLogger("global").log(Level.INFO, null, falex);
                    }
                    catch (IOException exception) {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                    final int newValue = 100 * i / number;
                    if (newValue > oldValue) {
                        oldValue = newValue;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressMonitor.setValue(newValue);
                            }
                        });
                    }
                    ++i;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressMonitor.close();
                    }
                });
            }
        });
        progressMonitor.setVisible(true);
    }

    void deleteTransactions() {
        this.deleteDirectory(saveDirStr);
        this.deleteDirectory(currDirStr);
        this.savedTrans.remove(this.savedTrans.getNodes());
        this.currTrans.remove(this.currTrans.getNodes());
    }

    void getTransactions() {
        int i;
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Enumeration e = null;
        Vector<TransactionNode> nodes = new Vector<TransactionNode>();
        int numtns = 0;
        TransactionNode[] tns = null;
        FileObject fo = null;
        String id = null;
        MonitorData md = null;
        this.currTrans.remove(this.currTrans.getNodes());
        e = currDir.getData(false);
        final ArrayList<FileObject> fileObjectsToDelete = new ArrayList<FileObject>();
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            if (fo.lastModified().after(this.startDate)) {
                id = fo.getName();
                md = this.retrieveMonitorData(id, currDir);
                if (md == null) continue;
                nodes.add(this.createTransactionNode(md, true));
                continue;
            }
            fileObjectsToDelete.add(fo);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator it = fileObjectsToDelete.iterator();
                while (it.hasNext()) {
                    try {
                        ((FileObject)it.next()).delete();
                    }
                    catch (IOException e) {
                        Logger.getLogger("global").log(Level.INFO, null, e);
                    }
                }
            }
        });
        numtns = nodes.size();
        tns = new TransactionNode[numtns];
        for (i = 0; i < numtns; ++i) {
            tns[i] = (TransactionNode)((Object)nodes.elementAt(i));
        }
        this.currTrans.add((Node[])tns);
        this.savedTrans.remove(this.savedTrans.getNodes());
        nodes = new Vector();
        e = saveDir.getData(false);
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            id = fo.getName();
            md = this.retrieveMonitorData(id, saveDir);
            if (md == null) continue;
            nodes.add(this.createTransactionNode(md, false));
        }
        numtns = nodes.size();
        tns = new TransactionNode[numtns];
        for (i = 0; i < numtns; ++i) {
            tns[i] = (TransactionNode)((Object)nodes.elementAt(i));
        }
        this.savedTrans.add((Node[])tns);
    }

    private int parseStatusCode(String statusCode) {
        if (statusCode == null) {
            return -1;
        }
        int statusCodeNum = 200;
        try {
            int idx = statusCode.indexOf(58);
            if (idx != -1) {
                statusCode = statusCode.substring(0, idx);
                statusCodeNum = Integer.valueOf(statusCode);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return statusCodeNum;
    }

    private TransactionNode createTransactionNode(MonitorData md, boolean current) {
        Dispatches dis = null;
        RequestData rd = md.getRequestData();
        try {
            dis = md.getDispatches();
        }
        catch (Exception ex) {
            // empty catch block
        }
        TransactionNode node = null;
        if (dis == null || dis.sizeDispatchData() == 0) {
            node = new TransactionNode(md.getAttributeValue("id"), md.getAttributeValue("method"), md.getAttributeValue("resource"), current, this.parseStatusCode(rd == null ? null : rd.getAttributeValue("status")));
        } else {
            int numChildren = dis.sizeDispatchData();
            Children.Array nested = new Children.Array();
            NestedNode[] nds = new NestedNode[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                nds[i] = this.createNestedNode(dis.getDispatchData(i), md.getAttributeValue("method"), null, i);
            }
            nested.add((Node[])nds);
            node = new TransactionNode(md.getAttributeValue("id"), md.getAttributeValue("method"), md.getAttributeValue("resource"), (Children)nested, current, this.parseStatusCode(rd == null ? null : rd.getAttributeValue("status")));
        }
        return node;
    }

    private NestedNode createNestedNode(DispatchData dd, String method, int[] locator, int index) {
        Dispatches dis = dd.getDispatches();
        NestedNode node = null;
        int[] newloc = null;
        if (locator != null) {
            newloc = new int[locator.length + 1];
            for (int j = 0; j < locator.length; ++j) {
                newloc[j] = locator[j];
            }
            newloc[j] = index;
        } else {
            newloc = new int[]{index};
        }
        if (dis == null || dis.sizeDispatchData() == 0) {
            RequestData rd = dd.getRequestData();
            node = new NestedNode(dd.getAttributeValue("resource"), method, newloc, this.parseStatusCode(rd == null ? null : rd.getAttributeValue("status")));
        } else {
            int numChildren = dis.sizeDispatchData();
            Children.Array nested = new Children.Array();
            NestedNode[] nds = new NestedNode[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                nds[i] = this.createNestedNode(dis.getDispatchData(i), method, newloc, i);
            }
            nested.add((Node[])nds);
            node = new NestedNode(dd.getAttributeValue("resource"), method, (Children)nested, newloc, this.parseStatusCode(dd.getRequestData().getAttributeValue("status")));
        }
        return node;
    }

    static void setServer(String loc, int p) {
        port = p;
        server = loc;
    }

    void setComparator(Comparator comp) {
        this.currTrans.setComparator(comp);
        this.savedTrans.setComparator(comp);
    }

    void setUseBrowserCookie(boolean value) {
        this.useBrowserCookie = value;
    }

    boolean getUseBrowserCookie() {
        return this.useBrowserCookie;
    }

    DataRecord getDataRecord(AbstractNode node) {
        return this.getDataRecord(node, true);
    }

    DataRecord getDataRecord(AbstractNode anode, boolean fromCache) {
        if (anode instanceof TransactionNode) {
            MonitorData md = this.getMonitorData((TransactionNode)anode, fromCache, true);
            if (md == null) {
                String msg = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
                Logger.getLogger("global").log(Level.INFO, msg);
                return null;
            }
            return md;
        }
        if (anode instanceof NestedNode) {
            NestedNode node = (NestedNode)anode;
            int[] index = node.getIndex();
            AbstractNode parent = (AbstractNode)node.getParentNode();
            if (parent == null) {
                return null;
            }
            while (parent != null && !(parent instanceof TransactionNode)) {
                parent = (AbstractNode)parent.getParentNode();
            }
            MonitorData md = this.getMonitorData((TransactionNode)parent, true, true);
            if (md == null) {
                String msg = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
                Logger.getLogger("global").log(Level.INFO, msg);
                return null;
            }
            BaseBean dr = md;
            int[] nodeindex = node.getIndex();
            for (int c = 0; c < nodeindex.length; ++c) {
                Dispatches dis = dr.getDispatches();
                dr = dis.getDispatchData(nodeindex[c]);
            }
            return dr;
        }
        return null;
    }

    MonitorData getMonitorData(TransactionNode node, boolean fromCache, boolean cacheIt) {
        String id = node.getID();
        Hashtable ht = null;
        FileObject dir = null;
        if (node.isCurrent()) {
            ht = this.currBeans;
            dir = currDir;
        } else {
            ht = this.saveBeans;
            dir = saveDir;
        }
        if (fromCache && ht.containsKey(id)) {
            return (MonitorData)ht.get(id);
        }
        MonitorData md = this.retrieveMonitorData(id, dir);
        if (cacheIt && md != null) {
            ht.put(id, md);
        }
        return md;
    }

    MonitorData retrieveMonitorData(String id, String dirS) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return null;
        }
        FileObject dir = null;
        if (dirS.equalsIgnoreCase(currDirStr)) {
            dir = currDir;
        } else if (dirS.equalsIgnoreCase(saveDirStr)) {
            dir = saveDir;
        } else if (dirS.equalsIgnoreCase(replayDirStr)) {
            dir = replayDir;
        }
        return this.retrieveMonitorData(id, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MonitorData retrieveMonitorData(String id, FileObject dir) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return null;
        }
        MonitorData md = null;
        FileObject fo = null;
        FileLock lock = null;
        InputStreamReader in = null;
        try {
            fo = dir.getFileObject(id, "xml");
            lock = fo.lock();
            in = new InputStreamReader(fo.getInputStream());
            md = MonitorData.createGraph(in);
            try {
                if (dir == replayDir) {
                    fo.delete(lock);
                }
            }
            catch (IOException ioex2) {
                // empty catch block
            }
        }
        catch (FileAlreadyLockedException falex) {
            Logger.getLogger("global").log(Level.INFO, null, falex);
        }
        catch (IOException ioex) {
            Logger.getLogger("global").log(Level.INFO, null, ioex);
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return md;
    }

    private void showReplay(final URL url) throws UnknownHostException, IOException {
        ServerCheck sc = new ServerCheck(url.getHost());
        Thread t = new Thread(sc);
        t.start();
        try {
            t.join(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t = null;
        if (!sc.isServerGood()) {
            throw new UnknownHostException();
        }
        try {
            Socket server = new Socket(url.getHost(), url.getPort());
            server.close();
            server = null;
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        });
    }

    private static void log(String s) {
        System.out.println("Controller::" + s);
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fo == null) {
            return null;
        }
        URL u = URLMapper.findURL((FileObject)fo, (int)2);
        return u;
    }

    boolean checkServer(boolean replay) {
        try {
            URL u = Controller.getSampleHTTPServerURL();
            if (u.getProtocol().equals("http")) {
                return true;
            }
        }
        catch (Throwable t) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            String msg = null;
            msg = replay ? NbBundle.getBundle((Class)Controller.class).getString("MON_CantReplay") : NbBundle.getBundle((Class)Controller.class).getString("MON_NoServer");
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msg, NbBundle.getBundle((Class)Controller.class).getString("MON_NoServerTitle"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
        }
        return false;
    }

    void updateNodeNames() {
        TransactionNode tn;
        int i;
        Node[] nodes = this.currTrans.getNodes();
        int size = nodes.length;
        for (i = 0; i < size; ++i) {
            tn = (TransactionNode)nodes[i];
            tn.setNameString();
        }
        nodes = this.savedTrans.getNodes();
        size = nodes.length;
        for (i = 0; i < size; ++i) {
            tn = (TransactionNode)nodes[i];
            tn.setNameString();
        }
    }

    class CompAlpha
    implements Comparator {
        CompAlpha() {
        }

        public int compare(Object o1, Object o2) {
            TransactionNode n1 = (TransactionNode)((Object)o1);
            TransactionNode n2 = (TransactionNode)((Object)o2);
            int diff = n1.getName().compareTo(n2.getName());
            if (diff == 0) {
                return n1.getID().compareTo(n2.getID());
            }
            return diff;
        }
    }

    class CompTime
    implements Comparator {
        boolean descend = true;

        CompTime(boolean descend) {
            this.descend = descend;
        }

        public int compare(Object o1, Object o2) {
            TransactionNode n1 = (TransactionNode)((Object)o1);
            TransactionNode n2 = (TransactionNode)((Object)o2);
            int result = this.descend ? n1.getID().compareTo(n2.getID()) : n2.getID().compareTo(n1.getID());
            return result;
        }
    }

    class ServerCheck
    implements Runnable {
        boolean serverGood = false;
        String serverName = null;

        ServerCheck(String name) {
            this.serverName = name;
        }

        public void run() {
            try {
                InetAddress.getByName(this.serverName);
                this.serverGood = true;
            }
            catch (UnknownHostException e) {
                this.serverGood = false;
            }
        }

        boolean isServerGood() {
            return this.serverGood;
        }
    }
}

