/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRenameRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public class ChangeParametersPlugin
extends CsmModificationRefactoringPlugin {
    private ChangeParametersRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public ChangeParametersPlugin(ChangeParametersRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private CsmFile getStartCsmFile() {
        CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (startFile == null && this.getEditorContext() != null) {
            startFile = this.getEditorContext().getFile();
        }
        return startFile;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        Collection<CsmObject> objs = this.getRefactoredObjects();
        if (objs == null || objs.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> files = new HashSet<CsmFile>();
        CsmFile startFile = this.getStartCsmFile();
        for (CsmObject obj : objs) {
            Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(obj, null);
            CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
            this.refactoring.getContext().add((Object)ar);
            files.addAll(this.getRelevantFiles(startFile, obj, this.refactoring));
        }
        return files;
    }

    @Override
    public Problem fastCheckParameters() {
        ChangeParametersRefactoring.ParameterInfo[] paramTable = this.refactoring.getParameterInfo();
        Problem p = null;
        for (int i = 0; i < paramTable.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo in;
            int origIndex = paramTable[i].getOriginalIndex();
            if (origIndex == -1) {
                CharSequence s = paramTable[i].getName();
                if (s == null || s.length() < 1) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
                } else if (!CndLexerUtilities.isCppIdentifier((CharSequence)s)) {
                    p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)s));
                }
                CharSequence t = paramTable[i].getType();
                if (t == null) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
                }
                if ((s = paramTable[i].getDefaultValue()) == null || s.length() < 1) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
                }
            }
            if ((in = paramTable[i]).getType() == null || !((Object)in.getType()).toString().endsWith("...") || i == paramTable.length - 1) continue;
            p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_VarargsFinalPosition", (Object[])new Object[0]));
        }
        return p;
    }

    private static String newParMessage(String par) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(par)});
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPlugin.class, (String)key);
    }

    private CsmObject getRefactoredCsmElement() {
        CsmContext editorContext;
        CsmObject out = this.getStartReferenceObject();
        if (out == null && (editorContext = this.getEditorContext()) != null) {
            out = editorContext.getEnclosingFunction();
        }
        return out;
    }

    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 4);
        CsmObject refactoredCsmElement = this.getRefactoredCsmElement();
        preCheckProblem = this.isResovledElement(refactoredCsmElement);
        this.fireProgressListenerStep();
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        CsmObject directReferencedObject = CsmRefactoringUtils.getReferencedElement(refactoredCsmElement);
        if (!CsmKindUtilities.isFunction((CsmObject)directReferencedObject) || CsmKindUtilities.isDestructor((CsmObject)directReferencedObject)) {
            preCheckProblem = ChangeParametersPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return preCheckProblem;
        }
        if (this.referencedObjects == null) {
            this.initReferencedObjects(directReferencedObject);
            this.fireProgressListenerStep();
        }
        preCheckProblem = this.checkIfModificationPossible(preCheckProblem, directReferencedObject, ChangeParametersPlugin.getString("ERR_Overrides_Fatal"), ChangeParametersPlugin.getString("ERR_OverridesOrOverriden"));
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    private void initReferencedObjects(CsmObject directReferencedObject) {
        CsmObject referencedObject = CsmRefactoringUtils.getReferencedElement(directReferencedObject);
        if (referencedObject != null) {
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            if (CsmKindUtilities.isMethod((CsmObject)referencedObject) && !CsmKindUtilities.isConstructor((CsmObject)referencedObject)) {
                CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject));
                this.referencedObjects.add((CsmObject)method);
                if (CsmVirtualInfoQuery.getDefault().isVirtual(method)) {
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + method;
                }
            } else {
                this.referencedObjects.add(referencedObject);
            }
        }
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        Collection<CsmObject> refObjects = this.getRefactoredObjects();
        assert (refObjects != null && refObjects.size() > 0) : "method must be called for resolved element";
        FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet refs = new LinkedHashSet();
        for (CsmObject obj : refObjects) {
            Collection curRefs = CsmReferenceRepository.getDefault().getReferences(obj, csmFile, CsmReferenceKind.ALL, null);
            refs.addAll(curRefs);
        }
        if (refs.size() > 0) {
            ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>(refs);
            Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference o1, CsmReference o2) {
                    return o1.getStartOffset() - o2.getStartOffset();
                }
            });
            CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            this.processRefactoredReferences(sortedRefs, fo, ces, mr, outProblem);
        }
    }

    private boolean needSpaceAfterComma() {
        return true;
    }

    private void processRefactoredReferences(List<CsmReference> sortedRefs, FileObject fo, CloneableEditorSupport ces, ModificationResult mr, AtomicReference<Problem> outProblem) {
        ChangeParametersRefactoring.ParameterInfo[] parameterInfo = this.refactoring.getParameterInfo();
        for (CsmReference ref : sortedRefs) {
            String descr;
            String oldName;
            ModificationResult.Difference diff = this.changeFunRef(ref, ces, oldName = ((Object)ref.getText()).toString(), parameterInfo, descr = this.getDescription(ref, oldName), outProblem);
            if (diff == null) continue;
            mr.addDifference(fo, diff);
        }
    }

    private String getDescription(CsmReference ref, String targetName) {
        boolean decl = CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
        String out = NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)(decl ? "UpdateSignature" : "UpdateFunRef"), (Object)targetName);
        return out;
    }

    private ModificationResult.Difference changeFunRef(CsmReference ref, CloneableEditorSupport ces, String oldName, ChangeParametersRefactoring.ParameterInfo[] parameterInfo, String descr, AtomicReference<Problem> outProblem) {
        int endOffset;
        int startOffset;
        StyledDocument document = ces.getDocument();
        FunctionInfo funInfo = this.prepareFunctionInfo(ref, document);
        StringBuilder oldText = new StringBuilder();
        StringBuilder newText = new StringBuilder();
        if (!funInfo.isValid()) {
            if (oldName == null) {
                oldName = ((Object)ref.getText()).toString();
            }
            oldText.append(oldName);
            newText.append(oldName);
            startOffset = ref.getStartOffset();
            endOffset = ref.getEndOffset();
        } else {
            boolean decl = CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
            boolean def = CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DEFINITION));
            startOffset = funInfo.getStartOffset();
            endOffset = funInfo.getEndOffset();
            boolean skipComma = true;
            boolean wereChanges = false;
            oldText.append(funInfo.getOriginalParamsText());
            newText.append("(");
            for (int i = 0; i < parameterInfo.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo pi;
                int originalIndex;
                if (!skipComma) {
                    newText.append(",");
                }
                if ((originalIndex = (pi = parameterInfo[i]).getOriginalIndex()) == -1) {
                    if (!skipComma && this.needSpaceAfterComma()) {
                        newText.append(" ");
                    }
                    skipComma = false;
                    if (decl) {
                        newText.append(pi.getType()).append(" ").append(pi.getName());
                        if (!def && this.refactoring.isUseDefaultValueOnlyInFunctionDeclaration()) {
                            newText.append(" = ").append(pi.getDefaultValue());
                        } else {
                            newText.append(" /* = ").append(pi.getDefaultValue()).append(" */");
                        }
                        wereChanges = true;
                        continue;
                    }
                    if (!this.refactoring.isUseDefaultValueOnlyInFunctionDeclaration()) {
                        newText.append(pi.getDefaultValue());
                        wereChanges = true;
                        continue;
                    }
                    skipComma = true;
                    continue;
                }
                if (!funInfo.hasParam(originalIndex)) continue;
                CharSequence origText = funInfo.getParameter(originalIndex);
                if (!skipComma && this.needSpaceAfterComma() && !Character.isWhitespace(origText.charAt(0))) {
                    newText.append(" ");
                }
                skipComma = false;
                newText.append(origText);
            }
            newText.append(")");
            if (!wereChanges) {
                return null;
            }
        }
        assert (startOffset <= endOffset);
        PositionRef startPos = ces.createPositionRef(startOffset, Position.Bias.Forward);
        PositionRef endPos = ces.createPositionRef(endOffset, Position.Bias.Backward);
        ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, oldText.toString(), newText.toString(), descr);
        return diff;
    }

    private FunctionInfo prepareFunctionInfo(final CsmReference ref, final Document doc) {
        final FunParamsTokenProcessor tp = new FunParamsTokenProcessor(doc);
        if (doc != null) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    CndTokenUtilities.processTokens((CndTokenProcessor)tp, (Document)doc, (int)ref.getStartOffset(), (int)doc.getLength());
                }
            });
        }
        return tp.getFunctionInfo();
    }

    private static final class FunParamsTokenProcessor
    implements CndTokenProcessor<Token<CppTokenId>> {
        private State state = State.START;
        private BlockConsumer blockConsumer;
        private final FunctionInfo funInfo = new FunctionInfo();
        private final Document doc;
        private Boolean inPP = null;
        private int curParamStartOffset = -1;

        private FunParamsTokenProcessor(Document doc) {
            this.doc = doc;
        }

        public boolean isStopped() {
            return this.state == State.END;
        }

        public FunctionInfo getFunctionInfo() {
            return this.funInfo;
        }

        public boolean token(Token<CppTokenId> token, int tokenOffset) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            if (this.inPP == null) {
                if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.inPP = Boolean.TRUE;
                    return true;
                }
                this.inPP = Boolean.FALSE;
            } else if (this.inPP == Boolean.FALSE && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return false;
            }
            switch (this.state) {
                case START: {
                    this.skipName(token, tokenOffset);
                    break;
                }
                case IN_PARAMS: {
                    this.inParams(token, tokenOffset);
                }
            }
            return false;
        }

        public void start(int startOffset, int firstTokenOffset, int lastOffset) {
        }

        public void end(int offset, int lastTokenOffset) {
            if (this.funInfo.startOffset != this.funInfo.endOffset) {
                try {
                    this.funInfo.origParamsText = this.doc.getText(this.funInfo.startOffset, this.funInfo.endOffset - this.funInfo.startOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void inParams(Token<CppTokenId> token, int offset) {
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LPAREN, CppTokenId.RPAREN);
                    break;
                }
                case LBRACE: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    break;
                }
                case LBRACKET: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACKET, CppTokenId.RBRACKET);
                    break;
                }
                case COMMA: {
                    this.finishParam(offset);
                    this.startParam(offset);
                    break;
                }
                case RPAREN: {
                    this.finishParam(offset);
                    this.state = State.END;
                    break;
                }
                case SEMICOLON: {
                    this.finishParam(offset);
                    this.state = State.END;
                }
            }
        }

        private void skipName(Token<CppTokenId> token, int offset) {
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.state = State.IN_PARAMS;
                    this.startParam(offset);
                    break;
                }
                case LT: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LT, CppTokenId.GT);
                    break;
                }
                case RPAREN: 
                case SEMICOLON: {
                    this.state = State.END;
                }
            }
        }

        private void finishParam(int offset) {
            assert (this.curParamStartOffset > 0);
            try {
                String paramText;
                String string = paramText = offset <= this.curParamStartOffset ? "" : this.doc.getText(this.curParamStartOffset, offset - this.curParamStartOffset);
                if (!this.funInfo.paramText.isEmpty() || paramText.trim().length() != 0) {
                    this.funInfo.addParam(paramText);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.funInfo.setEndOffset(offset + 1);
        }

        private void startParam(int offset) {
            this.funInfo.setStartOffsetIfNeeded(offset);
            this.curParamStartOffset = offset + 1;
        }

        private static class BlockConsumer {
            private final CppTokenId openBracket;
            private final CppTokenId closeBracket;
            private int depth;

            public BlockConsumer(CppTokenId openBracket, CppTokenId closeBracket) {
                this.openBracket = openBracket;
                this.closeBracket = closeBracket;
                this.depth = 0;
            }

            public boolean isLastToken(Token<CppTokenId> token) {
                boolean stop = false;
                if (token.id() == this.openBracket) {
                    ++this.depth;
                } else if (token.id() == this.closeBracket) {
                    --this.depth;
                    stop = this.depth <= 0;
                }
                return stop;
            }
        }

        static enum State {
            START,
            IN_PARAMS,
            END;

        }
    }

    private static final class FunctionInfo {
        private int startOffset = -1;
        private int endOffset = -1;
        private CharSequence origParamsText = "";
        private List<CharSequence> paramText = new ArrayList<CharSequence>();

        private FunctionInfo() {
        }

        public CharSequence getOriginalParamsText() {
            return this.origParamsText;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public List<CharSequence> getParametersText() {
            return this.paramText;
        }

        private void addParam(String param) {
            this.paramText.add(param);
        }

        public void setStartOffsetIfNeeded(int startOffset) {
            if (this.startOffset < 0) {
                this.startOffset = startOffset;
                this.endOffset = startOffset;
            }
        }

        private boolean hasParam(int index) {
            return index < this.paramText.size();
        }

        private CharSequence getParameter(int index) {
            return this.paramText.get(index);
        }

        private boolean isValid() {
            return this.endOffset > this.startOffset;
        }

        private void setEndOffset(int offset) {
            this.endOffset = offset;
        }

        public String toString() {
            return this.origParamsText + "[" + this.startOffset + "-" + this.endOffset + "] params:" + this.paramText;
        }
    }
}

