/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Utilities;

public class LibraryChecker {
    private LibraryChecker() {
    }

    /*
     * Loose catch block
     */
    public static boolean isLibraryAvailable(String lib, AbstractCompiler compiler) throws IOException {
        ExecutionEnvironment execEnv = compiler.getExecutionEnvironment();
        CompilerSet compilerSet = compiler.getCompilerSet();
        ToolchainManager.LinkerDescriptor linker = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
        String dummySourceFile = LibraryChecker.createDummySourceFile(execEnv, compiler.getKind());
        try {
            String linkerPath = LibraryChecker.getLinker(compiler, compilerSet).getPath();
            String dummySourcePath = dummySourceFile;
            if (execEnv.isLocal() && Utilities.isWindows()) {
                linkerPath = LinkSupport.resolveWindowsLink((String)linkerPath);
                dummySourcePath = LibraryChecker.convertToCompilerPath(dummySourcePath, compilerSet);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(Utilities.parseParameters((String)linker.getOutputFileFlag())));
            args.addAll(Arrays.asList(dummySourcePath + ".out", linker.getLibraryFlag() + lib, dummySourcePath));
            NativeProcessBuilder processBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
            processBuilder.setExecutable(linkerPath);
            processBuilder.setArguments(args.toArray(new String[args.size()]));
            NativeProcess process = processBuilder.call();
            try {
                boolean bl = process.waitFor() == 0;
                return bl;
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            finally {
                process.destroy();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (execEnv.isLocal()) {
                new File(dummySourceFile).delete();
                new File(dummySourceFile + ".out").delete();
            } else {
                CommonTasksSupport.rmFile((ExecutionEnvironment)execEnv, (String)dummySourceFile, null);
                CommonTasksSupport.rmFile((ExecutionEnvironment)execEnv, (String)(dummySourceFile + ".out"), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDummySourceFile(ExecutionEnvironment execEnv, ToolKind compilerKind) throws IOException {
        String ext;
        if (compilerKind == PredefinedToolKind.CCompiler) {
            ext = ".c";
        } else if (compilerKind == PredefinedToolKind.CCCompiler) {
            ext = ".cpp";
        } else {
            throw new IllegalArgumentException("Illegal tool kind " + compilerKind);
        }
        HostInfo localHostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        File dummyFile = File.createTempFile("dummy", ext, localHostInfo.getTempDirFile());
        try {
            FileWriter writer = new FileWriter(dummyFile);
            try {
                writer.write("int main(int argc, char** argv) { return 0; }\n");
            }
            finally {
                writer.close();
            }
            if (execEnv.isLocal()) {
                return dummyFile.getCanonicalPath();
            }
            HostInfo remoteHostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            String remoteDummyPath = remoteHostInfo.getTempDir() + '/' + dummyFile.getName();
            CommonTasksSupport.uploadFile((File)dummyFile, (ExecutionEnvironment)execEnv, (String)remoteDummyPath, (int)420, null).get();
            dummyFile.delete();
            return remoteDummyPath;
        }
        catch (Throwable ex) {
            dummyFile.delete();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    private static AbstractCompiler getLinker(AbstractCompiler compiler, CompilerSet compilerSet) {
        String preferred = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getPreferredCompiler();
        if ("c".equals(preferred)) {
            return (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
        }
        if ("cpp".equals(preferred)) {
            return (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        }
        return compiler;
    }

    private static String convertToCompilerPath(String path, CompilerSet compilerSet) {
        CompilerFlavor flavor = compilerSet.getCompilerFlavor();
        if (flavor.isCygwinCompiler()) {
            return WindowsSupport.getInstance().convertToCygwinPath(path);
        }
        return path;
    }
}

