/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.SemanticHighlighter;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class SemanticHighlighterFactory
extends EditorAwareCsmFileTaskFactory
implements PropertyChangeListener {
    public SemanticHighlighterFactory() {
        SemanticHighlightingOptions.instance().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (FileObject file : OpenedEditors.getDefault().getVisibleEditorsFiles()) {
            this.reschedule(file);
        }
    }

    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fo) {
        CsmFileTaskFactory.PhaseRunner pr = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                pr = new SemanticHighlighter(doc);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
        return pr != null ? pr : SemanticHighlighterFactory.lazyRunner();
    }

    protected int taskDelay() {
        return ModelUtils.SEMANTIC_DELAY;
    }

    protected int rescheduleDelay() {
        return ModelUtils.RESCHEDULE_SEMANTIC_DELAY;
    }
}

