/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.file.FileReadOnlyHandler;

public class FileUtils {
    private static FileReadOnlyHandler fileReadOnlyHandler;

    public static FileReadOnlyHandler getFileReadOnlyHandler() {
        return fileReadOnlyHandler;
    }

    public static void setFileReadOnlyHandler(FileReadOnlyHandler fileReadOnlyHandler) {
        FileUtils.fileReadOnlyHandler = fileReadOnlyHandler;
    }

    public static void setFileReadOnly(File file, boolean readOnly) throws IOException {
        if (FileUtils.getFileReadOnlyHandler() == null) {
            return;
        }
        FileUtils.getFileReadOnlyHandler().setFileReadOnly(file, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null || targetFile == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory '" + directory + "'");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
            try {
                byte[] buffer = new byte[32768];
                int readBytes = inputStream.read(buffer);
                while (readBytes > 0) {
                    outputStream.write(buffer, 0, readBytes);
                    readBytes = inputStream.read(buffer);
                }
            }
            catch (IOException ex) {
                targetFile.delete();
                throw ex;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void renameFile(File orig, File dest) throws IOException {
        int i;
        boolean destExists = dest.exists();
        if (destExists) {
            for (i = 0; i < 3; ++i) {
                if (dest.delete()) {
                    destExists = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!destExists) {
            for (i = 0; i < 3; ++i) {
                if (orig.renameTo(dest)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        FileUtils.copyFile(orig, dest);
        for (i = 0; i < 3; ++i) {
            if (orig.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + orig.getAbsolutePath());
    }

    private FileUtils() {
    }
}

