/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class Deployment {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(Deployment.class.getName());
    private static boolean alsoStartTargets = true;
    private static Deployment instance = null;

    public static synchronized Deployment getDefault() {
        if (instance == null) {
            instance = new Deployment();
        }
        return instance;
    }

    private Deployment() {
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2) throws DeploymentException {
        return this.deploy(j2eeModuleProvider, bl ? Mode.DEBUG : Mode.RUN, string, string2, bl2, null);
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, Mode mode, String string, String string2, boolean bl) throws DeploymentException {
        return this.deploy(j2eeModuleProvider, mode, string, string2, bl, null);
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2, Logger logger) throws DeploymentException {
        return this.deploy(j2eeModuleProvider, bl ? Mode.DEBUG : Mode.RUN, string, string2, bl2, logger);
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, Mode mode, String string, String string2, boolean bl, Logger logger) throws DeploymentException {
        DeploymentTargetImpl deploymentTargetImpl = new DeploymentTargetImpl(j2eeModuleProvider, string);
        TargetModuleID[] targetModuleIDArray = null;
        J2eeModule j2eeModule = deploymentTargetImpl.getModule();
        String string3 = NbBundle.getMessage(Deployment.class, (String)"LBL_Deploying", (Object)j2eeModuleProvider.getDeploymentName());
        ProgressUI progressUI = new ProgressUI(string3, false, logger);
        try {
            progressUI.start();
            ServerString serverString = deploymentTargetImpl.getServer();
            if (j2eeModule == null) {
                String string4 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(string4);
            }
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = serverString.getServerInstance();
            if (serverString == null || serverInstance == null) {
                String string5 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(string5);
            }
            DeploymentHelper.deployJdbcDrivers(j2eeModuleProvider, progressUI);
            TargetServer targetServer = new TargetServer(deploymentTargetImpl);
            if (alsoStartTargets || mode != Mode.RUN) {
                targetServer.startTargets(mode, progressUI);
            } else {
                serverString.getServerInstance().start(progressUI);
            }
            DeploymentHelper.deployDatasources(j2eeModuleProvider);
            DeploymentHelper.deployMessageDestinations(j2eeModuleProvider);
            targetModuleIDArray = targetServer.deploy(progressUI, bl);
            targetServer.notifyIncrementalDeployment(targetModuleIDArray);
            if (targetServer.supportsDeployOnSave((TargetModule[])targetModuleIDArray)) {
                DeployOnSaveManager.getDefault().notifyInitialDeployment(j2eeModuleProvider);
            }
            if (targetModuleIDArray == null || targetModuleIDArray.length <= 0) {
                String string6 = NbBundle.getMessage(Deployment.class, (String)"MSG_ModuleNotDeployed");
                throw new DeploymentException(string6);
            }
            deploymentTargetImpl.setTargetModules((TargetModule[])targetModuleIDArray);
            String string7 = deploymentTargetImpl.getClientUrl(string2);
            return string7;
        }
        catch (ServerException serverException) {
            String string8 = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)serverException.getLocalizedMessage());
            java.util.logging.Logger.getLogger("global").log(Level.INFO, null, serverException);
            if (null != serverException.getCause()) {
                throw new DeploymentException(string8, serverException);
            }
            throw new DeploymentException(string8);
        }
        catch (DeploymentException deploymentException) {
            throw deploymentException;
        }
        catch (Exception exception) {
            String string9 = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)exception.getLocalizedMessage());
            LOGGER.log(Level.INFO, null, exception);
            throw new DeploymentException(string9, exception);
        }
        finally {
            if (progressUI != null) {
                progressUI.finish();
            }
        }
    }

    public void undeploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, Logger logger) throws DeploymentException {
        DeploymentTargetImpl deploymentTargetImpl = new DeploymentTargetImpl(j2eeModuleProvider, null);
        J2eeModule j2eeModule = deploymentTargetImpl.getModule();
        String string = NbBundle.getMessage(Deployment.class, (String)"LBL_Undeploying", (Object)j2eeModuleProvider.getDeploymentName());
        ProgressUI progressUI = new ProgressUI(string, false, logger);
        try {
            progressUI.start();
            ServerString serverString = deploymentTargetImpl.getServer();
            if (j2eeModule == null) {
                String string2 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(string2);
            }
            try {
                ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverString.getServerInstance().getUrl());
                if (serverString == null || serverInstance == null) {
                    String string3 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                    throw new DeploymentException(string3);
                }
                ServerInstance.Descriptor descriptor = serverInstance.getDescriptor();
                if (descriptor == null || descriptor.isLocal()) {
                    TargetServer targetServer = new TargetServer(deploymentTargetImpl);
                    targetServer.undeploy(progressUI, bl);
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                String string4 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(string4);
            }
        }
        catch (Exception exception) {
            String string5 = NbBundle.getMessage(Deployment.class, (String)"MSG_UndeployFailed", (Object)exception.getLocalizedMessage());
            LOGGER.log(Level.INFO, null, exception);
            throw new DeploymentException(string5, exception);
        }
        finally {
            if (progressUI != null) {
                progressUI.finish();
            }
        }
    }

    public void enableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager.getDefault().startListening(j2eeModuleProvider);
    }

    public void disableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager.getDefault().stopListening(j2eeModuleProvider);
    }

    public String[] getServerInstanceIDs() {
        return InstanceProperties.getInstanceList();
    }

    public String[] getServerInstanceIDs(Object[] objectArray) {
        return this.getServerInstanceIDs(objectArray, (String)null, null);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> collection) {
        return this.getServerInstanceIDs(collection, (Profile)null, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string) {
        return this.getServerInstanceIDs(objectArray, string, null);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> collection, Profile profile) {
        return this.getServerInstanceIDs(collection, profile, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string, String[] stringArray) {
        Profile profile;
        Profile profile2 = profile = string != null ? Profile.fromPropertiesString((String)string) : null;
        if (profile == null && string != null) {
            return new String[0];
        }
        ArrayList<J2eeModule.Type> arrayList = new ArrayList<J2eeModule.Type>(objectArray.length);
        for (Object object : objectArray) {
            J2eeModule.Type type = J2eeModule.Type.fromJsrType(object);
            if (type == null) continue;
            arrayList.add(type);
        }
        return this.getServerInstanceIDs(arrayList, profile, stringArray);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> collection, Profile profile, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getServerInstanceIDs();
        for (int i = 0; i < stringArray2.length; ++i) {
            Set<J2eeModule.Type> set;
            J2eePlatform j2eePlatform = this.getJ2eePlatform(stringArray2[i]);
            if (j2eePlatform == null) continue;
            boolean bl = true;
            if (collection != null) {
                set = j2eePlatform.getSupportedTypes();
                for (J2eeModule.Type type : collection) {
                    if (set.contains(type)) continue;
                    bl = false;
                }
            }
            if (bl && profile != null) {
                set = j2eePlatform.getSupportedProfiles();
                bl = profile.equals(Profile.J2EE_13) ? set.contains(Profile.J2EE_13) || set.contains(Profile.J2EE_14) : set.contains(profile);
            }
            if (bl && stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j2eePlatform.isToolSupported(stringArray[j])) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            arrayList.add(stringArray2[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getServerInstanceDisplayName(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getDisplayName();
        }
        return null;
    }

    public String getServerID(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getServer().getShortName();
        }
        return null;
    }

    public String getDefaultServerInstanceID() {
        return null;
    }

    public boolean canFileDeploy(String string, J2eeModule j2eeModule) {
        IncrementalDeployment incrementalDeployment;
        boolean bl = false;
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (null != serverInstance && null != (incrementalDeployment = serverInstance.getIncrementalDeployment())) {
            bl = incrementalDeployment.canFileDeploy(null, j2eeModule);
        }
        return bl;
    }

    public String[] getInstancesOfServer(String string) {
        Server server;
        if (string != null && (server = ServerRegistry.getInstance().getServer(string)) != null) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance[] serverInstanceArray = ServerRegistry.getInstance().getServer(string).getInstances();
            String[] stringArray = new String[serverInstanceArray.length];
            for (int i = 0; i < serverInstanceArray.length; ++i) {
                stringArray[i] = serverInstanceArray[i].getUrl();
            }
            return stringArray;
        }
        return new String[0];
    }

    public ServerInstance getServerInstance(String string) {
        Parameters.notNull((CharSequence)"serverInstanceId", (Object)string);
        return new ServerInstance(string);
    }

    public String[] getServerIDs() {
        Collection<Server> collection = ServerRegistry.getInstance().getServers();
        String[] stringArray = new String[collection.size()];
        Iterator<Server> iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            Server server = iterator.next();
            stringArray[i] = server.getShortName();
        }
        return stringArray;
    }

    public J2eePlatform getJ2eePlatform(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return null;
        }
        return J2eePlatform.create(serverInstance);
    }

    public String getServerDisplayName(String string) {
        Server server = ServerRegistry.getInstance().getServer(string);
        if (server == null) {
            return null;
        }
        return server.getDisplayName();
    }

    public boolean isRunning(String string) {
        Parameters.notNull((CharSequence)"serverInstanceID", (Object)string);
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return false;
        }
        return serverInstance.isReallyRunning() || serverInstance.isSuspended();
    }

    public final void addInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().addInstanceListener(instanceListener);
    }

    public final void removeInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().removeInstanceListener(instanceListener);
    }

    public static interface Logger {
        public void log(String var1);
    }

    public static final class DeploymentException
    extends Exception {
        private DeploymentException(String string) {
            super(string);
        }

        private DeploymentException(Throwable throwable) {
            super(throwable);
        }

        private DeploymentException(String string, Throwable throwable) {
            super(string, throwable);
        }

        @Override
        public String toString() {
            String string = this.getClass().getName();
            String string2 = this.getLocalizedMessage();
            return string2 != null ? string2 : string;
        }
    }

    public static enum Mode {
        RUN,
        DEBUG,
        PROFILE;

    }
}

