/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ServiceLocatorStrategy {
    private static final String CREATE_INVOCATION = ".create()";
    private final String serviceLocator;

    private ServiceLocatorStrategy(String string) {
        this.serviceLocator = string;
    }

    public String genLocalEjbStringLookup(String string, String string2, FileObject fileObject, String string3, boolean bl) {
        String string4 = ServiceLocatorStrategy.initString("getLocalHome", string, fileObject, string3, this.serviceLocator, "");
        return "return " + this.addCast(bl, string2, string4, CREATE_INVOCATION) + ";";
    }

    public String genRemoteEjbStringLookup(String string, String string2, FileObject fileObject, String string3, boolean bl) {
        String string4 = ServiceLocatorStrategy.initString("getRemoteHome", string, fileObject, string3, this.serviceLocator, "," + string2 + ".class");
        return "return " + this.addCast(bl, string2, string4, CREATE_INVOCATION) + ";";
    }

    public String genDestinationLookup(String string, FileObject fileObject, String string2) {
        return ServiceLocatorStrategy.initString("getDestination", string, fileObject, string2, this.serviceLocator, "");
    }

    public String genJMSFactory(String string, FileObject fileObject, String string2) {
        return ServiceLocatorStrategy.initString("getConnectionFactory", string, fileObject, string2, this.serviceLocator, "");
    }

    public String genDataSource(String string, FileObject fileObject, String string2) {
        return ServiceLocatorStrategy.initString("getDataSource", string, fileObject, string2, this.serviceLocator, "");
    }

    public String genMailSession(String string, FileObject fileObject, String string2) {
        return ServiceLocatorStrategy.initString("getSession", string, fileObject, string2, this.serviceLocator, "");
    }

    public static ServiceLocatorStrategy create(Project project, FileObject fileObject, String string) {
        return new ServiceLocatorStrategy(string);
    }

    private ClassPath buildClassPathFromImportedProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null) : "cannot find project for file";
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        assert (classPathProvider != null) : "project doesn't have class path provider";
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ClassPath classPath = ClassPathSupport.createClassPath(Collections.emptyList());
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (fileObject2.getChildren().length <= 0) continue;
            ClassPath classPath2 = classPathProvider.findClassPath(fileObject2.getChildren()[0], "classpath/source");
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath});
        }
        return classPath;
    }

    private String addCast(boolean bl, String string, String string2, String string3) {
        String string4 = string2;
        string4 = "(" + string + ") " + string2;
        if (bl) {
            string4 = "(" + string4 + ")" + string3;
        }
        return string4;
    }

    private static String initString(String string, String string2, FileObject fileObject, String string3, String string4, String string5) {
        String string6 = null;
        try {
            String string7 = ServiceLocatorStrategy.getStaticLocator(fileObject, string4);
            string6 = string7 != null ? string4 + "." + string7 + "()." + string + "(\"java:comp/env/" + string2 + "\"" + string5 + ")" : ServiceLocatorStrategy.findOrCreateArtifacts(fileObject, string3, string4) + "()." + string + "(\"java:comp/env/" + string2 + "\"" + string5 + ")";
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return string6;
    }

    private static String findOrCreateArtifacts(FileObject fileObject, final String string, final String string2) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
                for (ExecutableElement parameterizable2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    if (parameterizable2.getParameters().size() != 0 || !workingCopy.getTypes().isSameType(typeElement.asType(), parameterizable2.getReturnType())) continue;
                    stringArray[0] = parameterizable2.getSimpleName().toString();
                    break;
                }
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement typeElement2 = workingCopy.getElements().getTypeElement(string2);
                if (stringArray[0] == null) {
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)"serviceLocator", (Tree)treeMaker.QualIdent((Element)typeElement2), null);
                    ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                    ClassTree classTree2 = treeMaker.insertClassMember(classTree, 0, (Tree)variableTree);
                    MethodModel methodModel = MethodModel.create((String)"getServiceLocator", (String)string2, (String)("if (serviceLocator == null) {\nserviceLocator = new " + string2 + "();\n" + "}\n" + "return serviceLocator;\n"), Collections.emptyList(), Collections.emptyList(), Collections.singleton(Modifier.PRIVATE));
                    MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                    classTree = workingCopy.getTrees().getTree(typeElement);
                    classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                    stringArray[0] = "getServiceLocator";
                }
            }
        }).commit();
        return stringArray[0];
    }

    private static String getStaticLocator(FileObject fileObject, final String string) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    Set<Modifier> set = executableElement.getModifiers();
                    if (!set.contains((Object)Modifier.STATIC) || !set.contains((Object)Modifier.PUBLIC) || !compilationController.getTypes().isSameType(typeElement.asType(), executableElement.getReturnType())) continue;
                    stringArray[0] = executableElement.getSimpleName().toString();
                }
            }
        }, true);
        return stringArray[0];
    }
}

