/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.sql.DataSource;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.clientproject.AppClientProvider;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JarContainerImpl
implements EnterpriseReferenceContainer {
    private Project webProject;
    private AntProjectHelper antHelper;
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private AppClient webApp;

    public JarContainerImpl(Project project, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper) {
        this.webProject = project;
        this.antHelper = antProjectHelper;
    }

    public void setServiceLocatorName(String string) throws IOException {
        EditableProperties editableProperties = this.antHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty(SERVICE_LOCATOR_PROPERTY, string);
        this.antHelper.putProperties("nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject(this.webProject);
    }

    public String addResourceRef(ResourceReference resourceReference, FileObject fileObject, String string) throws IOException {
        ResourceRef resourceRef;
        String string2 = resourceReference.getResRefName();
        AppClient appClient = this.getAppClient();
        if (DataSource.class.getName().equals(resourceReference.getResType())) {
            resourceRef = appClient.getResourceRef();
            for (int i = 0; i < ((ResourceRef[])resourceRef).length; ++i) {
                boolean bl;
                String string3 = resourceReference.getDefaultDescription();
                String string4 = resourceRef[i].getDefaultDescription();
                boolean bl2 = bl = string3 != null && string4 != null;
                if (!DataSource.class.getName().equals(resourceRef[i].getResType()) || bl && !string3.equals(string4) || !resourceReference.getResRefName().equals(resourceRef[i].getResRefName())) continue;
                return resourceRef[i].getResRefName();
            }
        }
        if (!JarContainerImpl.isResourceRefUsed(appClient, resourceReference)) {
            string2 = this.getUniqueName(appClient, "ResourceRef", "ResRefName", resourceReference.getResRefName());
            resourceRef = appClient.newResourceRef();
            EnterpriseReferenceSupport.populate((ResourceReference)resourceReference, (String)string2, (ResourceRef)resourceRef);
            this.getAppClient().addResourceRef(resourceRef);
            this.writeDD(fileObject, string);
        }
        return string2;
    }

    public String addEjbLocalReference(EjbReference ejbReference, EjbReference.EjbRefIType ejbRefIType, String string, FileObject fileObject, String string2) throws IOException {
        throw new UnsupportedOperationException("Local references are not supported in App Client module.");
    }

    public String addEjbReference(EjbReference ejbReference, EjbReference.EjbRefIType ejbRefIType, String string, FileObject fileObject, String string2) throws IOException {
        return this.addReference(ejbReference, ejbRefIType, string, fileObject, string2);
    }

    public String addDestinationRef(MessageDestinationReference messageDestinationReference, FileObject fileObject, String string) throws IOException {
        AppClient appClient = this.getAppClient();
        String string2 = this.getUniqueName(appClient, "MessageDestinationRef", "MessageDestinationRefName", messageDestinationReference.getMessageDestinationRefName());
        try {
            MessageDestinationRef messageDestinationRef = appClient.newMessageDestinationRef();
            EnterpriseReferenceSupport.populate((MessageDestinationReference)messageDestinationReference, (String)string2, (MessageDestinationRef)messageDestinationRef);
            appClient.addMessageDestinationRef(messageDestinationRef);
            this.writeDD(fileObject, string);
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
        return string2;
    }

    public String getServiceLocatorName() {
        EditableProperties editableProperties = this.antHelper.getProperties("nbproject/project.properties");
        return editableProperties.getProperty(SERVICE_LOCATOR_PROPERTY);
    }

    private AppClient getAppClient() throws IOException {
        if (this.webApp == null) {
            AppClientProvider appClientProvider = (AppClientProvider)this.webProject.getLookup().lookup(AppClientProvider.class);
            FileObject fileObject = appClientProvider.getDeploymentDescriptor();
            this.webApp = DDProvider.getDefault().getDDRoot(fileObject);
        }
        return this.webApp;
    }

    private String getUniqueName(AppClient appClient, String string, String string2, String string3) {
        String string4 = string3;
        int n = 1;
        while (appClient.findBeanByName(string, string2, string4) != null) {
            string4 = string3 + Integer.toString(n++);
        }
        return string4;
    }

    private void writeDD(FileObject fileObject, final String string) throws IOException {
        final AppClientProvider appClientProvider = (AppClientProvider)this.webProject.getLookup().lookup(AppClientProvider.class);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                if (JarContainerImpl.isDescriptorMandatory(appClientProvider.getJ2eeProfile()) || !InjectionTargetQuery.isInjectionTarget((CompilationController)compilationController, (TypeElement)typeElement)) {
                    FileObject fileObject = appClientProvider.getDeploymentDescriptor();
                    JarContainerImpl.this.getAppClient().write(fileObject);
                }
            }
        }, true);
    }

    private String addReference(EjbReference ejbReference, EjbReference.EjbRefIType ejbRefIType, String string, FileObject fileObject, String string2) throws IOException {
        EjbRef ejbRef;
        String string3 = null;
        AppClient appClient = this.getAppClient();
        string3 = this.getUniqueName(this.getAppClient(), "EjbRef", "EjbRefName", string);
        try {
            ejbRef = (EjbRef)appClient.createBean("EjbRef");
            ejbRef.setEjbRefName(string);
            ejbRef.setEjbRefType(ejbReference.getEjbRefType());
            ejbRef.setHome(ejbReference.getRemoteHome());
            ejbRef.setRemote(ejbReference.getRemote());
            this.getAppClient().addEjbRef(ejbRef);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ejbRef = (ProjectClassPathExtender)this.webProject.getLookup().lookup(ProjectClassPathExtender.class);
        if (ejbRef != null) {
            try {
                AntArtifact antArtifact = JarContainerImpl.getAntArtifact(ejbReference, ejbRefIType);
                ejbRef.addAntArtifact(antArtifact, antArtifact.getArtifactLocations()[0].normalize());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            Logger.getLogger("global").log(Level.INFO, "WebProjectClassPathExtender not found in the project lookup of project: " + this.webProject.getProjectDirectory().getPath());
        }
        this.writeDD(fileObject, string2);
        return string3;
    }

    private static AntArtifact getAntArtifact(EjbReference ejbReference, EjbReference.EjbRefIType ejbRefIType) throws IOException {
        FileObject fileObject = SourceUtils.getFileObject((String)ejbReference.getComponentName(ejbRefIType), (ClasspathInfo)ejbReference.getClasspathInfo());
        assert (fileObject != null) : "Reference FileObject not found: " + ejbReference.getComponentName(ejbRefIType);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project2, (String)"jar");
        boolean bl = antArtifactArray != null && antArtifactArray.length > 0;
        return bl ? antArtifactArray[0] : null;
    }

    private static boolean isDescriptorMandatory(Profile profile) {
        return Profile.J2EE_13.equals(profile) || Profile.J2EE_14.equals(profile);
    }

    private static boolean isResourceRefUsed(AppClient appClient, ResourceReference resourceReference) {
        String string = resourceReference.getResRefName();
        String string2 = resourceReference.getResType();
        for (ResourceRef resourceRef : appClient.getResourceRef()) {
            if (!string.equals(resourceRef.getResRefName()) || !string2.equals(resourceRef.getResType())) continue;
            return true;
        }
        return false;
    }
}

