/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr;

import persistence.antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int c, boolean forCharLiteral) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return forCharLiteral ? "\\'" : "'";
            }
            case 34: {
                return forCharLiteral ? "\"" : "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (c > 255) {
                String s = Integer.toString(c, 16);
                while (s.length() < 4) {
                    s = '0' + s;
                }
                return "\\u" + s;
            }
            return "\\" + Integer.toString(c, 8);
        }
        return String.valueOf((char)c);
    }

    public String escapeString(String s) {
        String retval = new String();
        for (int i = 0; i < s.length(); ++i) {
            retval = retval + this.escapeChar(s.charAt(i), false);
        }
        return retval;
    }

    public String literalChar(int c) {
        String ret = "0x" + Integer.toString(c, 16);
        if (c >= 0 && c <= 126) {
            ret = ret + " /* '" + this.escapeChar(c, true) + "' */ ";
        }
        return ret;
    }

    public String literalString(String s) {
        return "\"" + this.escapeString(s) + "\"";
    }
}

