/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import java.io.IOException;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.ejb.cmp3.persistence.ArchiveFactoryImpl;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.exceptions.StaticWeaveException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.helper.EJB30ConversionManager;
import oracle.toplink.essentials.internal.weaving.TransformerFactory;
import oracle.toplink.essentials.logging.DefaultSessionLog;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.threetier.ServerSession;

public class StaticWeaveClassTransformer {
    private ArrayList<ClassTransformer> classTransformers;
    private Writer logWriter;
    private int logLevel = 8;
    private ClassLoader aClassLoader;

    public StaticWeaveClassTransformer(URL inputArchiveURL, ClassLoader aclassloader) throws Exception {
        this(inputArchiveURL, aclassloader, null, 8);
    }

    public StaticWeaveClassTransformer(URL inputArchiveURL, ClassLoader aclassloader, Writer logWriter, int loglevel) throws URISyntaxException, IOException {
        this.aClassLoader = aclassloader;
        this.logWriter = logWriter;
        this.logLevel = loglevel;
        this.buildClassTransformers(inputArchiveURL, aclassloader);
    }

    public byte[] transform(String originalClassName, Class originalClass, byte[] originalClassBytes) throws IllegalClassFormatException {
        ClassTransformer transformer;
        byte[] newClassBytes = null;
        Iterator<ClassTransformer> i$ = this.classTransformers.iterator();
        while (i$.hasNext() && (newClassBytes = (transformer = i$.next()).transform(this.aClassLoader, originalClassName, originalClass, null, originalClassBytes)) == null) {
        }
        return newClassBytes;
    }

    private void buildClassTransformers(URL inputArchiveURL, ClassLoader aclassloader) throws URISyntaxException, IOException {
        if (this.classTransformers != null) {
            return;
        }
        this.classTransformers = new ArrayList();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(inputArchiveURL);
        }
        catch (ZipException e) {
            throw StaticWeaveException.exceptionOpeningArchive(inputArchiveURL, e);
        }
        List<SEPersistenceUnitInfo> persistenceUnitsList = PersistenceUnitProcessor.processPersistenceArchive(archive, aclassloader);
        if (persistenceUnitsList == null) {
            throw PersistenceUnitLoadingException.couldNotGetUnitInfoFromUrl(inputArchiveURL);
        }
        for (SEPersistenceUnitInfo unitInfo : persistenceUnitsList) {
            unitInfo.setNewTempClassLoader(aclassloader);
            ClassTransformer transformer = this.buildTransformer(unitInfo, this.logWriter, this.logLevel);
            this.classTransformers.add(transformer);
        }
    }

    private ClassTransformer buildTransformer(PersistenceUnitInfo unitInfo, Writer logWriter, int logLevel) {
        ClassLoader privateClassLoader = unitInfo.getNewTempClassLoader();
        ServerSession session = new ServerSession(new Project(new DatabaseLogin()));
        session.setLogLevel(logLevel);
        if (logWriter != null) {
            ((DefaultSessionLog)session.getSessionLog()).setWriter(logWriter);
        }
        session.getPlatform().setConversionManager(new EJB30ConversionManager());
        MetadataProcessor processor = new MetadataProcessor(unitInfo, session, privateClassLoader, true);
        PersistenceUnitProcessor.processORMetadata(processor, privateClassLoader, session, false);
        Collection<Class> entities = PersistenceUnitProcessor.buildEntityList(processor, privateClassLoader);
        return TransformerFactory.createTransformerAndModifyProject(session, entities, privateClassLoader);
    }
}

