/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.demo;

import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.demo.CommentWindow;
import org.netbeans.jemmy.demo.DefaultCommentWindow;
import org.netbeans.jemmy.demo.DemoInterruptedException;

public class Demonstrator {
    private static CommentWindow displayer;
    private static CommentWindow nonDisplayer;

    public static void setTitle(String title) {
        displayer.setTitle(title);
    }

    public static void setCommentWindow(CommentWindow cw) {
        displayer = cw;
    }

    public static void nextStep(String stepComment) {
        Demonstrator.getDisplayer().nextStep(stepComment);
        while (Demonstrator.getDisplayer().isStopped()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (Demonstrator.getDisplayer() != nonDisplayer) {
            try {
                EventDispatcher.waitQueueEmpty(TestOut.getNullOutput(), JemmyProperties.getCurrentTimeouts());
            }
            catch (TimeoutExpiredException e) {
                e.printStackTrace();
            }
        }
        if (Demonstrator.getDisplayer().isInterrupted()) {
            Demonstrator.getDisplayer().close();
            throw new DemoInterruptedException(Demonstrator.getDisplayer().getInterruptMessage());
        }
    }

    public static void showFinalComment(String stepComment) {
        Demonstrator.getDisplayer().showFinalComment(stepComment);
        while (Demonstrator.getDisplayer().isStopped()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        Demonstrator.getDisplayer().close();
        if (Demonstrator.getDisplayer() != nonDisplayer) {
            try {
                EventDispatcher.waitQueueEmpty(TestOut.getNullOutput(), JemmyProperties.getCurrentTimeouts());
            }
            catch (TimeoutExpiredException e) {
                e.printStackTrace();
            }
        }
    }

    private static CommentWindow getDisplayer() {
        if (System.getProperty("jemmy.demo") != null && System.getProperty("jemmy.demo").equals("on")) {
            return displayer;
        }
        return nonDisplayer;
    }

    static {
        Demonstrator.setCommentWindow(new DefaultCommentWindow());
        Demonstrator.setTitle("Step comments");
        nonDisplayer = new NonWindow();
    }

    private static class NonWindow
    implements CommentWindow {
        private NonWindow() {
        }

        public void setTitle(String title) {
        }

        public boolean isStopped() {
            return false;
        }

        public void nextStep(String stepComment) {
            JemmyProperties.getCurrentOutput().printLine("Step comments:\n" + stepComment);
        }

        public void showFinalComment(String stepComment) {
            JemmyProperties.getCurrentOutput().printLine("Final comments:\n" + stepComment);
        }

        public boolean isInterrupted() {
            return false;
        }

        public String getInterruptMessage() {
            return "";
        }

        public void close() {
        }
    }
}

