/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class FtpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 62342689756412730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private JCheckBox anonymousCheckBox;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JCheckBox passiveModeCheckBox;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public FtpConfigurationPanel() {
        this.initComponents();
        this.setEnabledLoginCredentials();
        this.registerListeners();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidConfiguration() {
        String err = RemoteValidator.validateHost(this.hostTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        err = RemoteValidator.validatePort(this.portTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        if (!this.validateUser()) {
            return false;
        }
        if (!this.validateInitialDirectory()) {
            return false;
        }
        err = RemoteValidator.validateTimeout(this.timeoutTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        this.setError(null);
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    void setEnabledLoginCredentials() {
        this.setEnabledLoginCredentials(!this.anonymousCheckBox.isSelected());
    }

    private void setEnabledLoginCredentials(boolean enabled) {
        this.userTextField.setEnabled(enabled);
        this.passwordTextField.setEnabled(enabled);
    }

    private void registerListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        DefaultActionListener actionListener = new DefaultActionListener();
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.userTextField.getDocument().addDocumentListener(documentListener);
        this.passwordTextField.getDocument().addDocumentListener(documentListener);
        this.anonymousCheckBox.addActionListener(actionListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(documentListener);
        this.timeoutTextField.getDocument().addDocumentListener(documentListener);
        this.passiveModeCheckBox.addActionListener(actionListener);
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpConfigurationPanel.this.setEnabledLoginCredentials();
            }
        });
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private boolean validateUser() {
        if (this.isAnonymousLogin()) {
            return true;
        }
        String err = RemoteValidator.validateUser(this.userTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String err = RunAsValidator.validateUploadDirectory(this.getInitialDirectory(), false);
        if (err != null) {
            this.setError(err);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.anonymousCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.passiveModeCheckBox = new JCheckBox();
        this.passwordLabelInfo = new JLabel();
        this.setFocusTraversalPolicy(null);
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.text_1"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.text_1"));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.text_1"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.text_1"));
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.text_1"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.text_1"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        Mnemonics.setLocalizedText((AbstractButton)this.passiveModeCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.text_1"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.text_1"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.userLabel).addComponent(this.passwordLabel).addComponent(this.initialDirectoryLabel).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userTextField, -1, 150, Short.MAX_VALUE).addComponent(this.hostTextField, -1, 150, Short.MAX_VALUE).addComponent(this.passwordTextField, -1, 150, Short.MAX_VALUE).addComponent(this.initialDirectoryTextField, -1, 150, Short.MAX_VALUE).addComponent(this.timeoutTextField, -1, 150, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField, -1, -1, Short.MAX_VALUE)).addComponent(this.anonymousCheckBox, GroupLayout.Alignment.LEADING)).addGap(0, 0, 0)).addComponent(this.passwordLabelInfo))).addComponent(this.passiveModeCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.anonymousCheckBox).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDirectoryLabel).addComponent(this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutTextField, -2, -1, -2).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passiveModeCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleName"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleName"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String hostName) {
        this.hostTextField.setText(hostName);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String userName) {
        this.userTextField.setText(userName);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordTextField.setText(password);
    }

    public boolean isAnonymousLogin() {
        return this.anonymousCheckBox.isSelected();
    }

    public void setAnonymousLogin(boolean anonymousLogin) {
        this.anonymousCheckBox.setSelected(anonymousLogin);
        this.setEnabledLoginCredentials();
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryTextField.setText(initialDirectory);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String timeout) {
        this.timeoutTextField.setText(timeout);
    }

    public boolean isPassiveMode() {
        return this.passiveModeCheckBox.isSelected();
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveModeCheckBox.setSelected(passiveMode);
    }

    @Override
    public void read(ConfigManager.Configuration cfg) {
        this.setHostName(cfg.getValue("host"));
        this.setPort(cfg.getValue("port"));
        this.setUserName(cfg.getValue("user"));
        this.setPassword(cfg.getValue("password", true));
        this.setAnonymousLogin(Boolean.valueOf(cfg.getValue("anonymousLogin")));
        this.setInitialDirectory(cfg.getValue("initialDirectory"));
        this.setTimeout(cfg.getValue("timeout"));
        this.setPassiveMode(Boolean.valueOf(cfg.getValue("passiveMode")));
    }

    @Override
    public void store(ConfigManager.Configuration cfg) {
        cfg.putValue("host", this.getHostName());
        cfg.putValue("port", this.getPort());
        cfg.putValue("user", this.getUserName());
        cfg.putValue("password", this.getPassword(), true);
        cfg.putValue("anonymousLogin", String.valueOf(this.isAnonymousLogin()));
        cfg.putValue("initialDirectory", RunAsValidator.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        cfg.putValue("timeout", this.getTimeout());
        cfg.putValue("passiveMode", String.valueOf(this.isPassiveMode()));
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FtpConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            FtpConfigurationPanel.this.fireChange();
        }
    }
}

