/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class CdcCopyLibs
extends Jar {
    private static final String LIB = "lib";
    Path runtimePath;

    public void setRuntimeClassPath(Path path) {
        assert (path != null);
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        File[] filesToCopy = new File[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            File f = new File(pathElements[i]);
            if (f.isDirectory() || !f.canRead()) {
                filesToCopy = null;
                break;
            }
            filesToCopy[i] = f;
        }
        super.execute();
        File destFile = this.getDestFile();
        File destFolder = destFile.getParentFile();
        assert (destFolder != null && destFolder.canWrite());
        if (filesToCopy != null && filesToCopy.length > 0) {
            File libFolder = new File(destFolder, LIB);
            if (!libFolder.exists()) {
                libFolder.mkdir();
            }
            assert (libFolder.canWrite());
            FileUtils utils = FileUtils.newFileUtils();
            for (int i = 0; i < filesToCopy.length; ++i) {
                try {
                    File libFile = new File(libFolder, filesToCopy[i].getName());
                    utils.copyFile(filesToCopy[i], libFile);
                    continue;
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        }
    }
}

